/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ElementHelper {
    public static final void validateProperty(Element element, String key, Object value) throws IllegalArgumentException {
        if (null == value) {
            throw ExceptionFactory.propertyValueCanNotBeNull();
        }
        if (null == key) {
            throw ExceptionFactory.propertyKeyCanNotBeNull();
        }
        if (key.equals("id")) {
            throw ExceptionFactory.propertyKeyIdIsReserved();
        }
        if (element instanceof Edge && key.equals("label")) {
            throw ExceptionFactory.propertyKeyLabelIsReservedForEdges();
        }
        if (key.isEmpty()) {
            throw ExceptionFactory.propertyKeyCanNotBeEmpty();
        }
    }

    public static void copyProperties(Element from, Element to) {
        for (String key : from.getPropertyKeys()) {
            to.setProperty(key, from.getProperty(key));
        }
    }

    public static void removeProperties(Iterable<Element> elements) {
        for (Element element : elements) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(element.getPropertyKeys());
            for (String key : keys) {
                element.removeProperty(key);
            }
        }
    }

    public static void removeProperty(String key, Iterable<Element> elements) {
        for (Element element : elements) {
            element.removeProperty(key);
        }
    }

    public static void renameProperty(String oldKey, String newKey, Iterable<Element> elements) {
        for (Element element : elements) {
            Object value = element.removeProperty(oldKey);
            if (null == value) continue;
            element.setProperty(newKey, value);
        }
    }

    public static void typecastProperty(String key, Class classCast, Iterable<Element> elements) {
        for (Element element : elements) {
            Object value = element.removeProperty(key);
            if (null == value) continue;
            try {
                element.setProperty(key, classCast.getConstructor(String.class).newInstance(value.toString()));
            }
            catch (Exception e) {
                element.setProperty(key, value);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static boolean haveEqualProperties(Element a, Element b) {
        Set<String> bKeys;
        Set<String> aKeys = a.getPropertyKeys();
        if (aKeys.containsAll(bKeys = b.getPropertyKeys()) && bKeys.containsAll(aKeys)) {
            for (String key : aKeys) {
                if (a.getProperty(key).equals(b.getProperty(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Map<String, Object> getProperties(Element element) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : element.getPropertyKeys()) {
            properties.put(key, element.getProperty(key));
        }
        return properties;
    }

    public static void setProperties(Element element, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            element.setProperty(property.getKey(), property.getValue());
        }
    }

    public static void setProperties(Element element, Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("The object var args must be divisible by 2");
        }
        for (int i = 0; i < keysValues.length; i += 2) {
            element.setProperty((String)keysValues[i], keysValues[i + 1]);
        }
    }

    public static boolean areEqual(Element a, Object b) {
        if (null == a && b != null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (null == b) {
            return false;
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        return a.getId().equals(((Element)b).getId());
    }

    public static boolean haveEqualIds(Element a, Element b) {
        return a.getId().equals(b.getId());
    }
}

