/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateInstanceRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.ClusterAutoscalingConfig;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateClusterRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.StorageType;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

public final class CreateInstanceRequest {
    private final CreateInstanceRequest.Builder builder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateInstanceRequest.newBuilder();
    private final List<CreateClusterRequest> clusterRequests = Lists.newArrayList();

    public static CreateInstanceRequest of(@Nonnull String instanceId) {
        return new CreateInstanceRequest(instanceId);
    }

    private CreateInstanceRequest(@Nonnull String instanceId) {
        Preconditions.checkNotNull(instanceId, "InstanceId can't be null");
        this.builder.setInstanceId(instanceId);
        this.builder.getInstanceBuilder().setDisplayName(instanceId);
        this.builder.getInstanceBuilder().setType(Instance.Type.PRODUCTION);
    }

    public CreateInstanceRequest setDisplayName(@Nonnull String displayName) {
        Preconditions.checkNotNull(displayName);
        this.builder.getInstanceBuilder().setDisplayName(displayName);
        return this;
    }

    public CreateInstanceRequest setType(@Nonnull Instance.Type type) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(type != Instance.Type.UNRECOGNIZED, "Type is unrecognized");
        this.builder.getInstanceBuilder().setType(type.toProto());
        return this;
    }

    public CreateInstanceRequest addLabel(@Nonnull String key, @Nonnull String value) {
        Preconditions.checkNotNull(key, "Key can't be null");
        Preconditions.checkNotNull(value, "Value can't be null");
        this.builder.getInstanceBuilder().putLabels(key, value);
        return this;
    }

    public CreateInstanceRequest addCluster(@Nonnull String clusterId, @Nonnull String zone, int serveNodes, @Nonnull StorageType storageType) {
        CreateClusterRequest clusterRequest = CreateClusterRequest.of("ignored-instance-id", clusterId).setZone(zone).setServeNodes(serveNodes).setStorageType(storageType);
        this.clusterRequests.add(clusterRequest);
        return this;
    }

    public CreateInstanceRequest addCluster(@Nonnull String clusterId, @Nonnull String zone, @Nonnull ClusterAutoscalingConfig clusterAutoscalingConfig, @Nonnull StorageType storageType) {
        CreateClusterRequest clusterRequest = CreateClusterRequest.of("ignored-instance-id", clusterId).setZone(zone).setScalingMode(clusterAutoscalingConfig).setStorageType(storageType);
        this.clusterRequests.add(clusterRequest);
        return this;
    }

    public CreateInstanceRequest addCmekCluster(@Nonnull String clusterId, @Nonnull String zone, int serveNodes, @Nonnull StorageType storageType, @Nonnull String kmsKeyName) {
        CreateClusterRequest clusterRequest = CreateClusterRequest.of("ignored-instance-id", clusterId).setZone(zone).setServeNodes(serveNodes).setStorageType(storageType).setKmsKeyName(kmsKeyName);
        this.clusterRequests.add(clusterRequest);
        return this;
    }

    public CreateInstanceRequest addDevelopmentCluster(@Nonnull String clusterId, @Nonnull String zone, @Nonnull StorageType storageType) {
        CreateClusterRequest developmentCluster = CreateClusterRequest.of("ignored-instance-id", clusterId).setZone(zone).setStorageType(storageType);
        this.clusterRequests.add(developmentCluster);
        return this;
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateInstanceRequest toProto(String projectId) {
        this.builder.setParent(NameUtil.formatProjectName(projectId)).clearClusters();
        for (CreateClusterRequest clusterRequest : this.clusterRequests) {
            this.builder.putClusters(clusterRequest.getClusterId(), clusterRequest.toEmbeddedProto(projectId));
        }
        return this.builder.build();
    }
}

