/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.grpclb;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.io.grpc.InternalServiceProviders;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.NameResolverProvider;
import com.google.bigtable.repackaged.io.grpc.grpclb.GrpclbNameResolver;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import java.net.URI;

final class SecretGrpclbNameResolverProvider {
    private SecretGrpclbNameResolverProvider() {
    }

    public static final class Provider
    extends NameResolverProvider {
        private static final String SCHEME = "dns";

        @Override
        public GrpclbNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            if (SCHEME.equals(targetUri.getScheme())) {
                String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
                Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
                String name = targetPath.substring(1);
                return new GrpclbNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()));
            }
            return null;
        }

        @Override
        public String getDefaultScheme() {
            return SCHEME;
        }

        @Override
        protected boolean isAvailable() {
            return true;
        }

        @Override
        public int priority() {
            return 6;
        }
    }
}

