/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerRegistry;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.internal.ServiceConfigUtil;
import com.google.bigtable.repackaged.io.grpc.xds.CdsLoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.xds.ClusterResolverLoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.xds.InternalXdsAttributes;
import com.google.bigtable.repackaged.io.grpc.xds.LeastRequestLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.xds.RingHashLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.XdsLogger;
import com.google.bigtable.repackaged.io.grpc.xds.XdsSubchannelPickers;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class CdsLoadBalancer2
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final LoadBalancerRegistry lbRegistry;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private CdsLbState cdsLbState;
    private LoadBalancer.ResolvedAddresses resolvedAddresses;

    CdsLoadBalancer2(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    @VisibleForTesting
    CdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.lbRegistry = Preconditions.checkNotNull(lbRegistry, "lbRegistry");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cds-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.resolvedAddresses != null) {
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        this.resolvedAddresses = resolvedAddresses;
        this.xdsClientPool = resolvedAddresses.getAttributes().get(InternalXdsAttributes.XDS_CLIENT_POOL);
        this.xdsClient = this.xdsClientPool.getObject();
        CdsLoadBalancerProvider.CdsConfig config = (CdsLoadBalancerProvider.CdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Config: {0}", config);
        this.cdsLbState = new CdsLbState(config.name);
        this.cdsLbState.start();
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.cdsLbState != null && this.cdsLbState.childLb != null) {
            this.cdsLbState.childLb.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.cdsLbState != null) {
            this.cdsLbState.shutdown();
        }
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject(this.xdsClient);
        }
    }

    private final class CdsLbState {
        private final ClusterState root;
        private LoadBalancer childLb;

        private CdsLbState(String rootCluster) {
            this.root = new ClusterState(rootCluster);
        }

        private void start() {
            this.root.start();
        }

        private void shutdown() {
            this.root.shutdown();
            if (this.childLb != null) {
                this.childLb.shutdown();
            }
        }

        private void handleClusterDiscovered() {
            ArrayList<ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism> instances = new ArrayList<ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism>();
            ArrayDeque<ClusterState> queue = new ArrayDeque<ClusterState>();
            queue.add(this.root);
            while (!queue.isEmpty()) {
                int size = queue.size();
                for (int i = 0; i < size; ++i) {
                    ClusterState clusterState = (ClusterState)queue.remove();
                    if (!clusterState.discovered) {
                        return;
                    }
                    if (clusterState.result == null) continue;
                    if (clusterState.isLeaf) {
                        ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance = clusterState.result.clusterType() == XdsClient.CdsUpdate.ClusterType.EDS ? ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.forEds(clusterState.name, clusterState.result.edsServiceName(), clusterState.result.lrsServerInfo(), clusterState.result.maxConcurrentRequests(), clusterState.result.upstreamTlsContext()) : ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.forLogicalDns(clusterState.name, clusterState.result.dnsHostName(), clusterState.result.lrsServerInfo(), clusterState.result.maxConcurrentRequests(), clusterState.result.upstreamTlsContext());
                        instances.add(instance);
                        continue;
                    }
                    if (clusterState.childClusterStates == null) continue;
                    queue.addAll(clusterState.childClusterStates.values());
                }
            }
            if (instances.isEmpty()) {
                if (this.childLb != null) {
                    this.childLb.shutdown();
                    this.childLb = null;
                }
                Status unavailable = Status.UNAVAILABLE.withDescription("CDS error: found 0 leaf (logical DNS or EDS) clusters for root cluster " + this.root.name);
                CdsLoadBalancer2.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(unavailable));
                return;
            }
            LoadBalancerProvider lbProvider = null;
            Object lbConfig = null;
            if (this.root.result.lbPolicy() == XdsClient.CdsUpdate.LbPolicy.RING_HASH) {
                lbProvider = CdsLoadBalancer2.this.lbRegistry.getProvider("ring_hash_experimental");
                lbConfig = new RingHashLoadBalancer.RingHashConfig(this.root.result.minRingSize(), this.root.result.maxRingSize());
            }
            if (this.root.result.lbPolicy() == XdsClient.CdsUpdate.LbPolicy.LEAST_REQUEST) {
                lbProvider = CdsLoadBalancer2.this.lbRegistry.getProvider("least_request_experimental");
                lbConfig = new LeastRequestLoadBalancer.LeastRequestConfig(this.root.result.choiceCount());
            }
            if (lbProvider == null) {
                lbProvider = CdsLoadBalancer2.this.lbRegistry.getProvider("round_robin");
                lbConfig = null;
            }
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = new ClusterResolverLoadBalancerProvider.ClusterResolverConfig(Collections.unmodifiableList(instances), new ServiceConfigUtil.PolicySelection(lbProvider, lbConfig));
            if (this.childLb == null) {
                this.childLb = CdsLoadBalancer2.this.lbRegistry.getProvider("cluster_resolver_experimental").newLoadBalancer(CdsLoadBalancer2.this.helper);
            }
            this.childLb.handleResolvedAddresses(CdsLoadBalancer2.this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config).build());
        }

        private void handleClusterDiscoveryError(Status error) {
            if (this.childLb != null) {
                this.childLb.handleNameResolutionError(error);
            } else {
                CdsLoadBalancer2.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
            }
        }

        private final class ClusterState
        implements XdsClient.CdsResourceWatcher {
            private final String name;
            @Nullable
            private Map<String, ClusterState> childClusterStates;
            @Nullable
            private XdsClient.CdsUpdate result;
            private boolean isLeaf;
            private boolean discovered;
            private boolean shutdown;

            private ClusterState(String name) {
                this.name = name;
            }

            private void start() {
                CdsLoadBalancer2.this.xdsClient.watchCdsResource(this.name, this);
            }

            void shutdown() {
                this.shutdown = true;
                CdsLoadBalancer2.this.xdsClient.cancelCdsResourceWatch(this.name, this);
                if (this.childClusterStates != null) {
                    for (ClusterState state : this.childClusterStates.values()) {
                        state.shutdown();
                    }
                }
            }

            @Override
            public void onError(Status error) {
                final Status status = Status.UNAVAILABLE.withDescription(String.format("Unable to load CDS %s. xDS server returned: %s: %s", new Object[]{this.name, error.getCode(), error.getDescription()})).withCause(error.getCause());
                CdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ClusterState.this.shutdown) {
                            return;
                        }
                        if (ClusterState.this == CdsLbState.this.root) {
                            CdsLbState.this.handleClusterDiscoveryError(status);
                        }
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                CdsLoadBalancer2.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ClusterState.this.shutdown) {
                            return;
                        }
                        ClusterState.this.discovered = true;
                        ClusterState.this.result = null;
                        if (ClusterState.this.childClusterStates != null) {
                            for (ClusterState state : ClusterState.this.childClusterStates.values()) {
                                state.shutdown();
                            }
                            ClusterState.this.childClusterStates = null;
                        }
                        CdsLbState.this.handleClusterDiscovered();
                    }
                });
            }

            @Override
            public void onChanged(final XdsClient.CdsUpdate update) {
                class ClusterDiscovered
                implements Runnable {
                    ClusterDiscovered() {
                    }

                    @Override
                    public void run() {
                        if (ClusterState.this.shutdown) {
                            return;
                        }
                        CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received cluster update {0}", update);
                        ClusterState.this.discovered = true;
                        ClusterState.this.result = update;
                        if (update.clusterType() == XdsClient.CdsUpdate.ClusterType.AGGREGATE) {
                            ClusterState.this.isLeaf = false;
                            CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Aggregate cluster {0}, underlying clusters: {1}", update.clusterName(), update.prioritizedClusterNames());
                            LinkedHashMap<String, ClusterState> newChildStates = new LinkedHashMap<String, ClusterState>();
                            for (String cluster : update.prioritizedClusterNames()) {
                                if (ClusterState.this.childClusterStates == null || !ClusterState.this.childClusterStates.containsKey(cluster)) {
                                    ClusterState childState = new ClusterState(cluster);
                                    childState.start();
                                    newChildStates.put(cluster, childState);
                                    continue;
                                }
                                newChildStates.put(cluster, (ClusterState)ClusterState.this.childClusterStates.remove(cluster));
                            }
                            if (ClusterState.this.childClusterStates != null) {
                                for (ClusterState watcher : ClusterState.this.childClusterStates.values()) {
                                    watcher.shutdown();
                                }
                            }
                            ClusterState.this.childClusterStates = newChildStates;
                        } else if (update.clusterType() == XdsClient.CdsUpdate.ClusterType.EDS) {
                            ClusterState.this.isLeaf = true;
                            CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "EDS cluster {0}, edsServiceName: {1}", update.clusterName(), update.edsServiceName());
                        } else {
                            ClusterState.this.isLeaf = true;
                            CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Logical DNS cluster {0}", update.clusterName());
                        }
                        CdsLbState.this.handleClusterDiscovered();
                    }
                }
                CdsLoadBalancer2.this.syncContext.execute(new ClusterDiscovered());
            }
        }
    }
}

