/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.CellDeduplicationHelper;
import com.google.cloud.bigtable.hbase.adapters.OperationAdapter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class IncrementAdapter
implements OperationAdapter<Increment, ReadModifyWriteRow> {
    @Override
    public void adapt(Increment operation, ReadModifyWriteRow readModifyWriteRow) {
        if (!operation.getTimeRange().isAllTime()) {
            throw new UnsupportedOperationException("Setting the time range in an Increment is not implemented");
        }
        for (Map.Entry familyEntry : operation.getFamilyMapOfLongs().entrySet()) {
            String familyName = Bytes.toString((byte[])((byte[])familyEntry.getKey()));
            List<Cell> mutationCells = CellDeduplicationHelper.deduplicateFamily((Mutation)operation, (byte[])familyEntry.getKey());
            for (Cell cell : mutationCells) {
                readModifyWriteRow.increment(familyName, ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()), Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            }
        }
    }
}

