/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.uniquerowsbyhashset;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.uniquerowsbyhashset.UniqueRowsByHashSet;
import org.apache.hop.pipeline.transforms.uniquerowsbyhashset.UniqueRowsByHashSetData;
import org.w3c.dom.Node;

@Transform(id="UniqueRowsByHashSet", image="uniquerowsbyhashset.svg", name="i18n::UniqueRowsByHashSet.Name", description="i18n::UniqueRowsByHashSet.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::UniqueRowsByHashSetMeta.keyword"}, documentationUrl="/pipeline/transforms/uniquerowsbyhashset.html")
public class UniqueRowsByHashSetMeta
extends BaseTransformMeta<UniqueRowsByHashSet, UniqueRowsByHashSetData> {
    private static final Class<?> PKG = UniqueRowsByHashSetMeta.class;
    private boolean storeValues;
    private String[] compareFields;
    private boolean rejectDuplicateRow;
    private String errorDescription;

    public void setCompareFields(String[] compareField) {
        this.compareFields = compareField;
    }

    public boolean getStoreValues() {
        return this.storeValues;
    }

    public void setStoreValues(boolean storeValues) {
        this.storeValues = storeValues;
    }

    public String[] getCompareFields() {
        return this.compareFields;
    }

    public void allocate(int nrFields) {
        this.compareFields = new String[nrFields];
    }

    public void setRejectDuplicateRow(boolean rejectDuplicateRow) {
        this.rejectDuplicateRow = rejectDuplicateRow;
    }

    public boolean isRejectDuplicateRow() {
        return this.rejectDuplicateRow;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        UniqueRowsByHashSetMeta retval = (UniqueRowsByHashSetMeta)((Object)super.clone());
        int nrFields = this.compareFields.length;
        retval.allocate(nrFields);
        System.arraycopy(this.compareFields, 0, retval.compareFields, 0, nrFields);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.storeValues = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"store_values"));
            this.rejectDuplicateRow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"reject_duplicate_row"));
            this.errorDescription = XmlHandler.getTagValue((Node)transformNode, (String)"error_description");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.compareFields[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.rejectDuplicateRow = false;
        this.errorDescription = null;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.compareFields[i] = "field" + i;
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("      " + XmlHandler.addTagValue((String)"store_values", (boolean)this.storeValues));
        retval.append("      " + XmlHandler.addTagValue((String)"reject_duplicate_row", (boolean)this.rejectDuplicateRow));
        retval.append("      " + XmlHandler.addTagValue((String)"error_description", (String)this.errorDescription));
        retval.append("    <fields>");
        for (int i = 0; i < this.compareFields.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.compareFields[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UniqueRowsByHashSetMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return this.isRejectDuplicateRow();
    }
}

