/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.AuthAgentCallback;
import com.trilead.ssh2.channel.Channel;
import com.trilead.ssh2.channel.IChannelWorkerThread;
import com.trilead.ssh2.channel.RemoteAcceptThread;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.ECDSASHA2Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import com.trilead.ssh2.signature.RSASHA256Verify;
import com.trilead.ssh2.signature.RSASHA512Verify;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;

public class AuthAgentForwardThread
extends Thread
implements IChannelWorkerThread {
    private static final byte[] SSH_AGENT_FAILURE = new byte[]{0, 0, 0, 1, 5};
    private static final byte[] SSH_AGENT_SUCCESS = new byte[]{0, 0, 0, 1, 6};
    private static final int SSH2_AGENTC_REQUEST_IDENTITIES = 11;
    private static final int SSH2_AGENT_IDENTITIES_ANSWER = 12;
    private static final int SSH2_AGENTC_SIGN_REQUEST = 13;
    private static final int SSH2_AGENT_SIGN_RESPONSE = 14;
    private static final int SSH2_AGENTC_ADD_IDENTITY = 17;
    private static final int SSH2_AGENTC_REMOVE_IDENTITY = 18;
    private static final int SSH2_AGENTC_REMOVE_ALL_IDENTITIES = 19;
    private static final int SSH_AGENTC_LOCK = 22;
    private static final int SSH_AGENTC_UNLOCK = 23;
    private static final int SSH2_AGENTC_ADD_ID_CONSTRAINED = 25;
    private static final int SSH_AGENT_CONSTRAIN_LIFETIME = 1;
    private static final int SSH_AGENT_CONSTRAIN_CONFIRM = 2;
    private static final int SSH_AGENT_RSA_SHA2_256 = 2;
    private static final int SSH_AGENT_RSA_SHA2_512 = 4;
    private static final Logger log = Logger.getLogger(RemoteAcceptThread.class);
    AuthAgentCallback authAgent;
    OutputStream os;
    InputStream is;
    Channel c;
    byte[] buffer = new byte[30000];

    public AuthAgentForwardThread(Channel c, AuthAgentCallback authAgent) {
        this.c = c;
        this.authAgent = authAgent;
        if (log.isEnabled()) {
            log.log(20, "AuthAgentForwardThread started");
        }
    }

    @Override
    public void run() {
        try {
            this.c.cm.registerThread(this);
        }
        catch (IOException e) {
            this.stopWorking();
            return;
        }
        try {
            this.c.cm.sendOpenConfirmation(this.c);
            this.is = this.c.getStdoutStream();
            this.os = this.c.getStdinStream();
            int totalSize = 4;
            int readSoFar = 0;
            while (true) {
                TypesReader tr;
                int len;
                try {
                    len = this.is.read(this.buffer, readSoFar, this.buffer.length - readSoFar);
                }
                catch (IOException e) {
                    this.stopWorking();
                    return;
                }
                if (len <= 0) break;
                if ((readSoFar += len) >= 4) {
                    tr = new TypesReader(this.buffer, 0, 4);
                    totalSize = tr.readUINT32() + 4;
                }
                if (totalSize != readSoFar) continue;
                tr = new TypesReader(this.buffer, 4, readSoFar - 4);
                int messageType = tr.readByte();
                switch (messageType) {
                    case 11: {
                        this.sendIdentities();
                        break;
                    }
                    case 17: {
                        this.addIdentity(tr, false);
                        break;
                    }
                    case 25: {
                        this.addIdentity(tr, true);
                        break;
                    }
                    case 18: {
                        this.removeIdentity(tr);
                        break;
                    }
                    case 19: {
                        this.removeAllIdentities(tr);
                        break;
                    }
                    case 13: {
                        this.processSignRequest(tr);
                        break;
                    }
                    case 22: {
                        this.processLockRequest(tr);
                        break;
                    }
                    case 23: {
                        this.processUnlockRequest(tr);
                        break;
                    }
                    default: {
                        this.os.write(SSH_AGENT_FAILURE);
                    }
                }
                readSoFar = 0;
            }
            this.c.cm.closeChannel(this.c, "EOF on both streams reached.", true);
        }
        catch (IOException e) {
            log.log(50, "IOException in agent forwarder: " + e.getMessage());
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.c.cm.closeChannel(this.c, "IOException in agent forwarder (" + e.getMessage() + ")", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stopWorking() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean failWhenLocked() throws IOException {
        if (this.authAgent.isAgentLocked()) {
            this.os.write(SSH_AGENT_FAILURE);
            return true;
        }
        return false;
    }

    private void sendIdentities() throws IOException {
        Map<String, byte[]> keys = null;
        TypesWriter tw = new TypesWriter();
        tw.writeByte(12);
        int numKeys = 0;
        if (!this.authAgent.isAgentLocked()) {
            keys = this.authAgent.retrieveIdentities();
        }
        if (keys != null) {
            numKeys = keys.size();
        }
        tw.writeUINT32(numKeys);
        if (keys != null) {
            for (Map.Entry<String, byte[]> entry : keys.entrySet()) {
                byte[] keyBytes = entry.getValue();
                tw.writeString(keyBytes, 0, keyBytes.length);
                tw.writeString(entry.getKey());
            }
        }
        this.sendPacket(tw.getBytes());
    }

    private void addIdentity(TypesReader tr, boolean checkConstraints) {
        try {
            PrivateKey privKey;
            PublicKey pubKey;
            KeySpec privSpec;
            KeySpec pubSpec;
            String comment;
            String keyType;
            if (this.failWhenLocked()) {
                return;
            }
            String type = tr.readString();
            if (type.equals("ssh-rsa")) {
                keyType = "RSA";
                BigInteger n = tr.readMPINT();
                BigInteger e = tr.readMPINT();
                BigInteger d = tr.readMPINT();
                BigInteger iqmp = tr.readMPINT();
                BigInteger p = tr.readMPINT();
                BigInteger q = tr.readMPINT();
                comment = tr.readString();
                BigInteger dmp1 = d.mod(p.subtract(BigInteger.ONE));
                BigInteger dmq1 = d.mod(q.subtract(BigInteger.ONE));
                pubSpec = new RSAPublicKeySpec(n, e);
                privSpec = new RSAPrivateCrtKeySpec(n, e, d, p, q, dmp1, dmq1, iqmp);
            } else if (type.equals("ssh-dss")) {
                keyType = "DSA";
                BigInteger p = tr.readMPINT();
                BigInteger q = tr.readMPINT();
                BigInteger g = tr.readMPINT();
                BigInteger y = tr.readMPINT();
                BigInteger x = tr.readMPINT();
                comment = tr.readString();
                pubSpec = new DSAPublicKeySpec(y, p, q, g);
                privSpec = new DSAPrivateKeySpec(x, p, q, g);
            } else if (type.equals(ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get().getKeyFormat())) {
                ECDSASHA2Verify.ECDSASHA2NISTP256Verify verifier = ECDSASHA2Verify.ECDSASHA2NISTP256Verify.get();
                keyType = "EC";
                String curveName = tr.readString();
                byte[] groupBytes = tr.readByteString();
                BigInteger exponent = tr.readMPINT();
                comment = tr.readString();
                if (!"nistp256".equals(curveName)) {
                    log.log(2, "Invalid curve name for ecdsa-sha2-nistp256: " + curveName);
                    this.os.write(SSH_AGENT_FAILURE);
                    return;
                }
                ECParameterSpec params = ((ECDSASHA2Verify)verifier).getParameterSpec();
                ECPoint group = verifier.decodeECPoint(groupBytes);
                if (group == null) {
                    this.os.write(SSH_AGENT_FAILURE);
                    return;
                }
                pubSpec = new ECPublicKeySpec(group, params);
                privSpec = new ECPrivateKeySpec(exponent, params);
            } else {
                log.log(2, "Unknown key type: " + type);
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            try {
                KeyFactory kf = KeyFactory.getInstance(keyType);
                pubKey = kf.generatePublic(pubSpec);
                privKey = kf.generatePrivate(privSpec);
            }
            catch (NoSuchAlgorithmException ex) {
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            catch (InvalidKeySpecException ex) {
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            KeyPair pair = new KeyPair(pubKey, privKey);
            boolean confirmUse = false;
            int lifetime = 0;
            if (checkConstraints) {
                while (tr.remain() > 0) {
                    int constraint = tr.readByte();
                    if (constraint == 2) {
                        confirmUse = true;
                        continue;
                    }
                    if (constraint == 1) {
                        lifetime = tr.readUINT32();
                        continue;
                    }
                    this.os.write(SSH_AGENT_FAILURE);
                    return;
                }
            }
            if (this.authAgent.addIdentity(pair, comment, confirmUse, lifetime)) {
                this.os.write(SSH_AGENT_SUCCESS);
            } else {
                this.os.write(SSH_AGENT_FAILURE);
            }
        }
        catch (IOException e) {
            try {
                this.os.write(SSH_AGENT_FAILURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void removeIdentity(TypesReader tr) {
        try {
            if (this.failWhenLocked()) {
                return;
            }
            byte[] publicKey = tr.readByteString();
            if (this.authAgent.removeIdentity(publicKey)) {
                this.os.write(SSH_AGENT_SUCCESS);
            } else {
                this.os.write(SSH_AGENT_FAILURE);
            }
        }
        catch (IOException e) {
            try {
                this.os.write(SSH_AGENT_FAILURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void removeAllIdentities(TypesReader tr) {
        try {
            if (this.failWhenLocked()) {
                return;
            }
            if (this.authAgent.removeAllIdentities()) {
                this.os.write(SSH_AGENT_SUCCESS);
            } else {
                this.os.write(SSH_AGENT_FAILURE);
            }
        }
        catch (IOException e) {
            try {
                this.os.write(SSH_AGENT_FAILURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processSignRequest(TypesReader tr) {
        try {
            byte[] response;
            if (this.failWhenLocked()) {
                return;
            }
            byte[] publicKeyBytes = tr.readByteString();
            byte[] challenge = tr.readByteString();
            int flags = tr.readUINT32();
            if ((flags & 0xFFFFFFFB & 0xFFFFFFFD) != 0) {
                log.log(2, "Unrecognized ssh-agent flags: " + flags);
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            KeyPair pair = this.authAgent.getKeyPair(publicKeyBytes);
            if (pair == null) {
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            PrivateKey privKey = pair.getPrivate();
            if (privKey instanceof RSAPrivateKey) {
                RSAPrivateKey rsaPrivKey = (RSAPrivateKey)privKey;
                response = (flags & 4) != 0 ? RSASHA512Verify.get().generateSignature(challenge, rsaPrivKey, new SecureRandom()) : ((flags & 2) != 0 ? RSASHA256Verify.get().generateSignature(challenge, rsaPrivKey, new SecureRandom()) : RSASHA1Verify.get().generateSignature(challenge, rsaPrivKey, new SecureRandom()));
            } else if (privKey instanceof DSAPrivateKey) {
                response = DSASHA1Verify.get().generateSignature(challenge, privKey, new SecureRandom());
            } else {
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            TypesWriter tw = new TypesWriter();
            tw.writeByte(14);
            tw.writeString(response, 0, response.length);
            this.sendPacket(tw.getBytes());
        }
        catch (IOException e) {
            try {
                this.os.write(SSH_AGENT_FAILURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processLockRequest(TypesReader tr) {
        try {
            if (this.failWhenLocked()) {
                return;
            }
            String lockPassphrase = tr.readString();
            if (!this.authAgent.setAgentLock(lockPassphrase)) {
                this.os.write(SSH_AGENT_FAILURE);
                return;
            }
            this.os.write(SSH_AGENT_SUCCESS);
        }
        catch (IOException e) {
            try {
                this.os.write(SSH_AGENT_FAILURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processUnlockRequest(TypesReader tr) {
        try {
            String unlockPassphrase = tr.readString();
            if (this.authAgent.requestAgentUnlock(unlockPassphrase)) {
                this.os.write(SSH_AGENT_SUCCESS);
            } else {
                this.os.write(SSH_AGENT_FAILURE);
            }
        }
        catch (IOException e) {
            try {
                this.os.write(SSH_AGENT_FAILURE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendPacket(byte[] message) throws IOException {
        TypesWriter packet = new TypesWriter();
        packet.writeUINT32(message.length);
        packet.writeBytes(message);
        this.os.write(packet.getBytes());
    }
}

