/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.checkdbconnection;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.checkdbconnection.ActionCheckDbConnections;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ActionCheckDbConnectionsDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionCheckDbConnectionsDialog.class;
    private Shell shell;
    private Text wName;
    private ActionCheckDbConnections action;
    private boolean changed;
    private TableView wFields;

    public ActionCheckDbConnectionsDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionCheckDbConnections)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        int rows;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wName, 2 * margin);
        wlFields.setLayoutData((Object)fdlFields);
        Button wbGetConnections = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbGetConnections);
        wbGetConnections.setText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.GetConnections", (String[])new String[0]));
        wbGetConnections.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.GetConnections.Tooltip", (String[])new String[0]));
        FormData fdbGetConnections = new FormData();
        fdbGetConnections.right = new FormAttachment(100, -margin);
        fdbGetConnections.top = new FormAttachment((Control)wlFields, margin);
        wbGetConnections.setLayoutData((Object)fdbGetConnections);
        Button wbdSourceFileFolder = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbdSourceFileFolder);
        wbdSourceFileFolder.setText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.DeleteEntry", (String[])new String[0]));
        wbdSourceFileFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.DeleteSourceFileButton.Label", (String[])new String[0]));
        FormData fdbdSourceFileFolder = new FormData();
        fdbdSourceFileFolder.right = new FormAttachment(100, -margin);
        fdbdSourceFileFolder.top = new FormAttachment((Control)wbGetConnections, margin);
        wbdSourceFileFolder.setLayoutData((Object)fdbdSourceFileFolder);
        int FieldsRows = rows = this.action.getConnections() == null ? 1 : (this.action.getConnections().length == 0 ? 0 : this.action.getConnections().length);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Fields.Argument.Label", (String[])new String[0]), 2, this.getWorkflowMeta().getDatabaseNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Fields.WaitFor.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Fields.WaitForTime.Label", (String[])new String[0]), 2, ActionCheckDbConnections.unitTimeDesc, false)};
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Fields.Column", (String[])new String[0]));
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.WaitFor.ToolTip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)wbGetConnections, -margin);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        wbdSourceFileFolder.addListener(13, e -> {
            int[] idx = this.wFields.getSelectionIndices();
            this.wFields.remove(idx);
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
        });
        wbGetConnections.addListener(13, e -> this.getDatabases());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getDatabases() {
        this.wFields.removeAll();
        List databases = this.getWorkflowMeta().getDatabases();
        for (DatabaseMeta ci : databases) {
            if (ci == null) continue;
            this.wFields.add(new String[]{ci.getName(), "0", ActionCheckDbConnections.unitTimeDesc[0]});
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getConnections() != null) {
            for (int i = 0; i < this.action.getConnections().length; ++i) {
                TableItem ti = this.wFields.table.getItem(i);
                if (this.action.getConnections()[i] == null) continue;
                ti.setText(1, this.action.getConnections()[i].getName());
                ti.setText(2, "" + Const.toInt((String)this.action.getWaitfors()[i], (int)0));
                ti.setText(3, ActionCheckDbConnections.getWaitTimeDesc(this.action.getWaittimes()[i]));
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        int nrItems = this.wFields.nrNonEmpty();
        DatabaseMeta[] connections = new DatabaseMeta[nrItems];
        String[] waitfors = new String[nrItems];
        int[] waittimes = new int[nrItems];
        for (int i = 0; i < nrItems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            DatabaseMeta dbMeta = this.getWorkflowMeta().findDatabase(arg);
            if (dbMeta == null) continue;
            connections[i] = dbMeta;
            waitfors[i] = "" + Const.toInt((String)this.wFields.getNonEmpty(i).getText(2), (int)0);
            waittimes[i] = ActionCheckDbConnections.getWaitTimeByDesc(this.wFields.getNonEmpty(i).getText(3));
        }
        this.action.setConnections(connections);
        this.action.setWaitfors(waitfors);
        this.action.setWaittimes(waittimes);
        this.dispose();
    }
}

