/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.util.Preconditions;

public class HandlerRequest<R extends RequestBody, M extends MessageParameters> {
    private final R requestBody;
    private final Collection<File> uploadedFiles;
    private final Map<Class<? extends MessagePathParameter<?>>, MessagePathParameter<?>> pathParameters = new HashMap(2);
    private final Map<Class<? extends MessageQueryParameter<?>>, MessageQueryParameter<?>> queryParameters = new HashMap(2);

    public HandlerRequest(R requestBody, M messageParameters) throws HandlerRequestException {
        this(requestBody, messageParameters, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    public HandlerRequest(R requestBody, M messageParameters, Map<String, String> receivedPathParameters, Map<String, List<String>> receivedQueryParameters) throws HandlerRequestException {
        this(requestBody, messageParameters, receivedPathParameters, receivedQueryParameters, Collections.emptyList());
    }

    public HandlerRequest(R requestBody, M messageParameters, Map<String, String> receivedPathParameters, Map<String, List<String>> receivedQueryParameters, Collection<File> uploadedFiles) throws HandlerRequestException {
        this.requestBody = (RequestBody)Preconditions.checkNotNull(requestBody);
        this.uploadedFiles = Collections.unmodifiableCollection((Collection)Preconditions.checkNotNull(uploadedFiles));
        Preconditions.checkNotNull(messageParameters);
        Preconditions.checkNotNull(receivedQueryParameters);
        Preconditions.checkNotNull(receivedPathParameters);
        for (MessagePathParameter<?> messagePathParameter : ((MessageParameters)messageParameters).getPathParameters()) {
            String value = receivedPathParameters.get(messagePathParameter.getKey());
            if (value == null) continue;
            try {
                messagePathParameter.resolveFromString(value);
            }
            catch (Exception e) {
                throw new HandlerRequestException("Cannot resolve path parameter (" + messagePathParameter.getKey() + ") from value \"" + value + "\".");
            }
            Class<?> clazz = messagePathParameter.getClass();
            this.pathParameters.put(clazz, messagePathParameter);
        }
        for (MessageQueryParameter messageQueryParameter : ((MessageParameters)messageParameters).getQueryParameters()) {
            List<String> values = receivedQueryParameters.get(messageQueryParameter.getKey());
            if (values == null || values.isEmpty()) continue;
            StringJoiner joiner = new StringJoiner(",");
            values.forEach(joiner::add);
            try {
                messageQueryParameter.resolveFromString(joiner.toString());
            }
            catch (Exception e) {
                throw new HandlerRequestException("Cannot resolve query parameter (" + messageQueryParameter.getKey() + ") from value \"" + joiner + "\".");
            }
            Class<?> clazz = messageQueryParameter.getClass();
            this.queryParameters.put(clazz, messageQueryParameter);
        }
    }

    public R getRequestBody() {
        return this.requestBody;
    }

    public <X, PP extends MessagePathParameter<X>> X getPathParameter(Class<PP> parameterClass) {
        MessagePathParameter<?> pathParameter = this.pathParameters.get(parameterClass);
        Preconditions.checkState((pathParameter != null ? 1 : 0) != 0, (Object)"No parameter could be found for the given class.");
        return pathParameter.getValue();
    }

    public <X, QP extends MessageQueryParameter<X>> List<X> getQueryParameter(Class<QP> parameterClass) {
        MessageQueryParameter<?> queryParameter = this.queryParameters.get(parameterClass);
        if (queryParameter == null) {
            return Collections.emptyList();
        }
        return (List)queryParameter.getValue();
    }

    @Nonnull
    public Collection<File> getUploadedFiles() {
        return this.uploadedFiles;
    }
}

