/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarItem;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.BaseGuiWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class GuiToolbarWidgets
extends BaseGuiWidgets {
    private Map<String, GuiToolbarItem> guiToolBarMap = new HashMap<String, GuiToolbarItem>();
    private Map<String, Control> widgetsMap = new HashMap<String, Control>();
    private Map<String, ToolItem> toolItemMap = new HashMap<String, ToolItem>();

    public GuiToolbarWidgets() {
        super(UUID.randomUUID().toString());
    }

    public void createToolbarWidgets(Composite parent, String root) {
        List toolbarItems = GuiRegistry.getInstance().findGuiToolbarItems(root);
        if (toolbarItems.isEmpty()) {
            System.err.println("Create widgets: no GUI toolbar items found for root: " + root);
            return;
        }
        Collections.sort(toolbarItems);
        for (GuiToolbarItem toolbarItem : toolbarItems) {
            this.addToolbarWidgets(parent, toolbarItem);
        }
        parent.layout(true, true);
        this.addDeRegisterGuiPluginObjectListener((Control)parent);
    }

    private void addToolbarWidgets(Composite parent, GuiToolbarItem toolbarItem) {
        CLabel label;
        ToolItem labelSeparator;
        if (toolbarItem.isIgnored()) {
            return;
        }
        this.guiToolBarMap.put(toolbarItem.getId(), toolbarItem);
        if (!(parent instanceof ToolBar)) {
            throw new RuntimeException("We can only add toolbar items to a toolbar, not class " + parent.getClass().getName());
        }
        ToolBar toolBar = (ToolBar)parent;
        PropsUi props = PropsUi.getInstance();
        if (toolbarItem.isAddingSeparator() || toolbarItem.getType() != GuiToolbarElementType.BUTTON) {
            new ToolItem(toolBar, 2);
        }
        if (toolbarItem.getType() != GuiToolbarElementType.LABEL && toolbarItem.getType() != GuiToolbarElementType.CHECKBOX && StringUtils.isNotEmpty((String)toolbarItem.getLabel())) {
            labelSeparator = new ToolItem(toolBar, 2);
            label = new CLabel(parent, 0x1000000 | (toolbarItem.isAlignRight() ? 131072 : 16384));
            label.setText(Const.NVL((String)toolbarItem.getLabel(), (String)""));
            label.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
            props.setLook((Control)label, 6);
            label.pack();
            labelSeparator.setWidth(label.getSize().x);
            labelSeparator.setControl((Control)label);
        }
        switch (toolbarItem.getType()) {
            case LABEL: {
                labelSeparator = new ToolItem(toolBar, 2);
                label = new CLabel(parent, 0x1000000 | (toolbarItem.isAlignRight() ? 131072 : 16384));
                label.setText(Const.NVL((String)toolbarItem.getLabel(), (String)""));
                label.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
                props.setLook((Control)label, 6);
                label.pack();
                labelSeparator.setWidth(label.getSize().x);
                labelSeparator.setControl((Control)label);
                this.toolItemMap.put(toolbarItem.getId(), labelSeparator);
                this.widgetsMap.put(toolbarItem.getId(), (Control)label);
                Listener listener = this.getListener(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), toolbarItem.getListenerMethod());
                label.addListener(4, listener);
                break;
            }
            case BUTTON: {
                ToolItem item = new ToolItem(toolBar, 0);
                this.setImages(item, toolbarItem.getClassLoader(), toolbarItem.getImage(), toolbarItem.getDisabledImage());
                if (StringUtils.isNotEmpty((String)toolbarItem.getToolTip())) {
                    item.setToolTipText(toolbarItem.getToolTip());
                }
                Listener listener = this.getListener(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), toolbarItem.getListenerMethod());
                item.addListener(13, listener);
                this.toolItemMap.put(toolbarItem.getId(), item);
                this.setToolItemKeyboardShortcut(item, toolbarItem);
                break;
            }
            case COMBO: {
                ToolItem comboSeparator = new ToolItem(toolBar, 2);
                Combo combo = new Combo(parent, 4 | (toolbarItem.isAlignRight() ? 131072 : 16384));
                combo.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
                combo.setItems(this.getComboItems(toolbarItem));
                props.setLook((Control)combo);
                combo.pack();
                comboSeparator.setWidth(this.calculateComboWidth(combo) + toolbarItem.getExtraWidth());
                comboSeparator.setControl((Control)combo);
                Listener listener = this.getListener(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), toolbarItem.getListenerMethod());
                combo.addListener(13, listener);
                combo.addListener(14, listener);
                this.toolItemMap.put(toolbarItem.getId(), comboSeparator);
                this.widgetsMap.put(toolbarItem.getId(), (Control)combo);
                props.setLook((Control)combo, 6);
                break;
            }
            case CHECKBOX: {
                ToolItem checkboxSeparator = new ToolItem(toolBar, 2);
                Button checkbox = new Button(parent, 0x20 | (toolbarItem.isAlignRight() ? 131072 : 16384));
                checkbox.setToolTipText(Const.NVL((String)toolbarItem.getToolTip(), (String)""));
                checkbox.setText(Const.NVL((String)toolbarItem.getLabel(), (String)""));
                props.setLook((Control)checkbox);
                checkbox.pack();
                checkboxSeparator.setWidth(checkbox.getSize().x + toolbarItem.getExtraWidth());
                checkboxSeparator.setControl((Control)checkbox);
                Listener listener = this.getListener(toolbarItem.getClassLoader(), toolbarItem.getListenerClass(), toolbarItem.getListenerMethod());
                checkbox.addListener(13, listener);
                this.toolItemMap.put(toolbarItem.getId(), checkboxSeparator);
                this.widgetsMap.put(toolbarItem.getId(), (Control)checkbox);
                break;
            }
        }
    }

    private void setToolItemKeyboardShortcut(ToolItem toolItem, GuiToolbarItem guiToolbarItem) {
        KeyboardShortcut shortcut = GuiRegistry.getInstance().findKeyboardShortcut(guiToolbarItem.getListenerClass(), guiToolbarItem.getListenerMethod(), Const.isOSX());
        if (shortcut != null) {
            toolItem.setToolTipText(toolItem.getToolTipText() + " (" + shortcut.toString() + ")");
        }
    }

    private void setImages(ToolItem item, ClassLoader classLoader, String location, String disabledLocation) {
        GuiResource gr = GuiResource.getInstance();
        int width = 16;
        int height = 16;
        if (StringUtils.isNotEmpty((String)location)) {
            item.setImage(gr.getImage(location, classLoader, width, height));
            Image disabledImage = StringUtils.isNotEmpty((String)disabledLocation) ? gr.getImage(disabledLocation, classLoader, width, height) : gr.getImage(location, classLoader, width, height, true);
            item.setDisabledImage(disabledImage);
        }
    }

    private int calculateComboWidth(Combo combo) {
        int maxWidth = combo.getSize().x;
        for (String item : combo.getItems()) {
            int width = TextSizeUtilFacade.textExtent((String)item).x;
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public void enableToolbarItem(String id, boolean enabled) {
        ToolItem toolItem = this.toolItemMap.get(id);
        if (toolItem == null || toolItem.isDisposed()) {
            return;
        }
        if (enabled != toolItem.isEnabled()) {
            toolItem.setEnabled(enabled);
        }
    }

    public ToolItem enableToolbarItem(IHopFileType fileType, String id, String permission) {
        return this.enableToolbarItem(fileType, id, permission, true);
    }

    public ToolItem enableToolbarItem(IHopFileType fileType, String id, String permission, boolean active) {
        ToolItem item = this.findToolItem(id);
        if (item == null || item.isDisposed()) {
            return null;
        }
        boolean hasCapability = fileType.hasCapability(permission);
        item.setEnabled(hasCapability && active);
        return item;
    }

    public ToolItem findToolItem(String id) {
        return this.toolItemMap.get(id);
    }

    public void refreshComboItemList(String id) {
        GuiToolbarItem item = this.guiToolBarMap.get(id);
        if (item != null) {
            Control control = this.widgetsMap.get(id);
            if (control != null) {
                if (control instanceof Combo) {
                    Combo combo = (Combo)control;
                    combo.setItems(this.getComboItems(item));
                } else {
                    System.err.println("toolbar item with id '" + id + "' : widget not of instance Combo");
                }
            } else {
                System.err.println("toolbar item with id '" + id + "' : control not found when refreshing combo");
            }
        } else {
            System.err.println("toolbar item with id '" + id + "' : not found when refreshing combo");
        }
    }

    public void selectComboItem(String id, String string) {
        Control control;
        GuiToolbarItem item = this.guiToolBarMap.get(id);
        if (item != null && (control = this.widgetsMap.get(id)) != null && control instanceof Combo) {
            Combo combo = (Combo)control;
            combo.setText(Const.NVL((String)string, (String)""));
            int index = Const.indexOfString((String)string, (String[])combo.getItems());
            if (index >= 0) {
                combo.select(index);
            }
        }
    }

    public Map<String, Control> getWidgetsMap() {
        return this.widgetsMap;
    }

    public void setWidgetsMap(Map<String, Control> widgetsMap) {
        this.widgetsMap = widgetsMap;
    }

    public Map<String, ToolItem> getToolItemMap() {
        return this.toolItemMap;
    }

    public void setToolItemMap(Map<String, ToolItem> toolItemMap) {
        this.toolItemMap = toolItemMap;
    }

    public Map<String, GuiToolbarItem> getGuiToolBarMap() {
        return this.guiToolBarMap;
    }

    public void setGuiToolBarMap(Map<String, GuiToolbarItem> guiToolBarMap) {
        this.guiToolBarMap = guiToolBarMap;
    }
}

