/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.VariableRegistry;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.IGetCaretPosition;
import org.apache.hop.ui.core.widget.IInsertText;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;

public class ControlSpaceKeyAdapter
extends KeyAdapter {
    private static final Class<?> PKG = ControlSpaceKeyAdapter.class;
    private static final PropsUi props = PropsUi.getInstance();
    private final IGetCaretPosition getCaretPositionInterface;
    private final IInsertText insertTextInterface;
    private IVariables variables;
    private final Control control;

    public ControlSpaceKeyAdapter(IVariables variables, Control control) {
        this(variables, control, null, null);
    }

    public ControlSpaceKeyAdapter(IVariables variables, Control control, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface) {
        this.variables = variables;
        this.control = control;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
    }

    private boolean isHotKey(KeyEvent e) {
        if (System.getProperty("user.language").equals("zh")) {
            return e.character == ' ' && (e.stateMask & 0x40000) != 0 && (e.stateMask & 0x10000) != 0;
        }
        if (OsHelper.isMac()) {
            return e.keyCode == 32 && (e.stateMask & 0x40000) != 0 && (e.stateMask & 0x10000) == 0;
        }
        return e.character == ' ' && (e.stateMask & 0x40000) != 0 && (e.stateMask & 0x10000) == 0;
    }

    public void keyPressed(KeyEvent e) {
        if (this.isHotKey(e)) {
            e.doit = false;
            this.control.setData((Object)Boolean.TRUE);
            final int position = this.getCaretPositionInterface != null ? this.getCaretPositionInterface.getCaretPosition() : -1;
            Rectangle bounds = this.control.getBounds();
            Point location = GuiResource.calculateControlPosition(this.control);
            final Shell shell = new Shell(this.control.getShell(), 0);
            shell.setSize(bounds.width > 300 ? bounds.width : 300, 200);
            shell.setLocation(location.x, location.y + bounds.height);
            shell.setLayout((Layout)new FillLayout());
            final List list = new List((Composite)shell, 772);
            props.setLook((Control)list);
            list.setItems(ControlSpaceKeyAdapter.getVariableNames(this.variables));
            final ToolTip toolTip = new ToolTip(list.getShell(), 4096);
            toolTip.setAutoHide(true);
            list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public synchronized void widgetDefaultSelected(SelectionEvent e) {
                    ControlSpaceKeyAdapter.applyChanges(shell, list, ControlSpaceKeyAdapter.this.control, position, ControlSpaceKeyAdapter.this.insertTextInterface);
                }

                public void widgetSelected(SelectionEvent event) {
                    if (list.getSelectionCount() <= 0) {
                        return;
                    }
                    String name = list.getSelection()[0];
                    String value = ControlSpaceKeyAdapter.this.variables.getVariable(name);
                    Rectangle shellBounds = shell.getBounds();
                    Object message = BaseMessages.getString(PKG, (String)"TextVar.VariableValue.Message", (String[])new String[]{name, value});
                    if (name.startsWith("Internal")) {
                        message = (String)message + BaseMessages.getString(PKG, (String)"TextVar.InternalVariable.Message", (String[])new String[0]);
                    }
                    toolTip.setText((String)message);
                    toolTip.setVisible(false);
                    toolTip.setLocation(shell.getLocation().x, shell.getLocation().y + shellBounds.height);
                    toolTip.setVisible(true);
                }
            });
            list.addKeyListener((KeyListener)new KeyAdapter(){

                public synchronized void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 && (e.keyCode & 0x40000) == 0 && (e.keyCode & 0x20000) == 0) {
                        ControlSpaceKeyAdapter.applyChanges(shell, list, ControlSpaceKeyAdapter.this.control, position, ControlSpaceKeyAdapter.this.insertTextInterface);
                    }
                }
            });
            list.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    shell.dispose();
                    if (!ControlSpaceKeyAdapter.this.control.isDisposed()) {
                        ControlSpaceKeyAdapter.this.control.setData((Object)Boolean.FALSE);
                    }
                }
            });
            shell.open();
        }
    }

    private static void applyChanges(Shell shell, List list, Control control, int position, IInsertText insertTextInterface) {
        String selection = list.getSelection()[0].contains(Const.getDeprecatedPrefix()) ? list.getSelection()[0].replace(Const.getDeprecatedPrefix(), "") : list.getSelection()[0];
        String extra = "${" + selection + "}";
        if (insertTextInterface != null) {
            insertTextInterface.insertText(extra, position);
        } else {
            if (control.isDisposed()) {
                return;
            }
            if (list.getSelectionCount() <= 0) {
                return;
            }
            if (control instanceof Text) {
                ((Text)control).insert(extra);
            } else if (control instanceof CCombo) {
                CCombo combo = (CCombo)control;
                combo.setText(extra);
            } else if (control instanceof StyledTextComp) {
                ((StyledTextComp)control).insert(extra);
            }
        }
        if (!shell.isDisposed()) {
            shell.dispose();
        }
        if (!control.isDisposed()) {
            control.setData((Object)Boolean.FALSE);
        }
    }

    public static String[] getVariableNames(IVariables variables) {
        Object[] variableNames = variables.getVariableNames();
        block2: for (int i = 0; i < variableNames.length; ++i) {
            for (String deprecatedName : VariableRegistry.getInstance().getDeprecatedVariableNames()) {
                if (!variableNames[i].equals(deprecatedName)) continue;
                variableNames[i] = variableNames[i] + Const.getDeprecatedPrefix();
                continue block2;
            }
        }
        Properties systemProperties = System.getProperties();
        Set hopVariablesSet = VariableRegistry.getInstance().getVariableNames();
        HashSet deprecatedSet = new HashSet(VariableRegistry.getInstance().getDeprecatedVariableNames());
        Set hopSystemSettings = VariableRegistry.getInstance().getVariableNames(new VariableScope[]{VariableScope.SYSTEM});
        HashMap pluginsPrefixesMap = new HashMap();
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopExtensionPoint.HopGuiGetControlSpaceSortOrderPrefix.name(), pluginsPrefixesMap);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calling extension point 'HopGuiGetControlSpaceSortOrderPrefix'", (Throwable)e);
        }
        Arrays.sort(variableNames);
        return variableNames;
    }

    private static String addPrefix(String variableName, Properties systemProperties, Set<String> hopVariablesSet, Set<String> deprecatedSet, Set<String> hopSystemSettings, Map<String, String> pluginsPrefixesMap) {
        String pluginPrefix;
        String prefix = "300_";
        String systemValue = systemProperties.getProperty(variableName);
        if (systemValue != null) {
            prefix = "900_";
        }
        if (hopVariablesSet.contains(variableName)) {
            prefix = "800_";
        }
        if (hopSystemSettings.contains(variableName)) {
            prefix = "700_";
        }
        if (deprecatedSet.contains(variableName)) {
            prefix = "600_";
        }
        if (variableName.startsWith("Internal")) {
            prefix = "500_";
        }
        if ((pluginPrefix = pluginsPrefixesMap.get(variableName)) != null) {
            prefix = pluginPrefix;
        }
        return prefix;
    }

    public void setVariables(IVariables vars) {
        this.variables = vars;
    }
}

