/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget.tree;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TreeToolbar
extends Composite {
    private PropsUi props = PropsUi.getInstance();
    private Text selectionFilter;
    private ToolItem expandAll;
    private ToolItem collapseAll;

    public TreeToolbar(Composite composite, int i) {
        super(composite, i);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        Label sep3 = new Label((Composite)this, 258);
        sep3.setBackground(GuiResource.getInstance().getColorWhite());
        FormData fdSep3 = new FormData();
        fdSep3.left = new FormAttachment(0, 0);
        fdSep3.right = new FormAttachment(100, 0);
        fdSep3.top = new FormAttachment(0);
        sep3.setLayoutData((Object)fdSep3);
        ToolBar treeTb = new ToolBar((Composite)this, 0x800100);
        this.props.setLook((Control)treeTb, 6);
        this.expandAll = new ToolItem(treeTb, 8);
        this.expandAll.setImage(GuiResource.getInstance().getImageExpandAll());
        this.collapseAll = new ToolItem(treeTb, 8);
        this.collapseAll.setImage(GuiResource.getInstance().getImageCollapseAll());
        FormData fdTreeToolbar = new FormData();
        fdTreeToolbar.top = Const.isLinux() ? new FormAttachment((Control)sep3, 3) : new FormAttachment((Control)sep3, 5);
        fdTreeToolbar.right = new FormAttachment(100, -10);
        treeTb.setLayoutData((Object)fdTreeToolbar);
        ToolBar selectionFilterTb = new ToolBar((Composite)this, 0x800100);
        this.props.setLook((Control)selectionFilterTb, 6);
        ToolItem clearSelectionFilter = new ToolItem(selectionFilterTb, 8);
        clearSelectionFilter.setImage(GuiResource.getInstance().getImageClearText());
        FormData fdSelectionFilterToolbar = new FormData();
        fdSelectionFilterToolbar.top = Const.isLinux() ? new FormAttachment((Control)sep3, 3) : new FormAttachment((Control)sep3, 5);
        fdSelectionFilterToolbar.right = new FormAttachment((Control)treeTb, -20);
        selectionFilterTb.setLayoutData((Object)fdSelectionFilterToolbar);
        this.selectionFilter = new Text((Composite)this, 18564);
        FormData fdSelectionFilter = new FormData();
        int offset = -(GuiResource.getInstance().getImageClearText().getBounds().height + 6);
        if (Const.isLinux()) {
            offset = -(GuiResource.getInstance().getImageClearText().getBounds().height + 13);
        }
        fdSelectionFilter.top = new FormAttachment((Control)selectionFilterTb, offset);
        fdSelectionFilter.right = new FormAttachment((Control)selectionFilterTb, 0);
        fdSelectionFilter.left = new FormAttachment(0, 10);
        this.selectionFilter.setLayoutData((Object)fdSelectionFilter);
        clearSelectionFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeToolbar.this.selectionFilter.setText("");
            }
        });
        clearSelectionFilter.setEnabled(!Utils.isEmpty((CharSequence)this.selectionFilter.getText()));
        this.selectionFilter.addModifyListener(modifyEvent -> clearSelectionFilter.setEnabled(!Utils.isEmpty((CharSequence)this.selectionFilter.getText())));
        Label sep4 = new Label((Composite)this, 258);
        sep4.setBackground(GuiResource.getInstance().getColorWhite());
        FormData fdSep4 = new FormData();
        fdSep4.left = new FormAttachment(0, 0);
        fdSep4.right = new FormAttachment(100, 0);
        fdSep4.top = new FormAttachment((Control)treeTb, 5);
        sep4.setLayoutData((Object)fdSep4);
    }

    public void setSearchTooltip(String tooltip) {
        this.selectionFilter.setToolTipText(tooltip);
    }

    public void setSearchPlaceholder(String searchPlaceholder) {
        this.selectionFilter.setMessage(searchPlaceholder);
    }

    public void addSearchModifyListener(ModifyListener modifyListener) {
        this.selectionFilter.addModifyListener(modifyListener);
    }

    public void addExpandAllListener(SelectionAdapter selectionAdapter) {
        this.expandAll.addSelectionListener((SelectionListener)selectionAdapter);
    }

    public void addCollapseAllListener(SelectionAdapter selectionAdapter) {
        this.collapseAll.addSelectionListener((SelectionListener)selectionAdapter);
    }

    public String getSearchText() {
        return this.selectionFilter.getText();
    }

    public boolean setFocus() {
        return this.selectionFilter.setFocus();
    }

    public void clear() {
        this.selectionFilter.setText("");
    }
}

