/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.action.GuiContextActionFilter;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.gui.plugin.GuiPluginType;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.gui.plugin.callback.GuiCallback;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.SearchableAnalyserPluginType;
import org.apache.hop.ui.hopgui.file.HopFileTypePluginType;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePluginType;
import org.apache.hop.ui.util.EnvironmentUtils;

public class HopGuiEnvironment
extends HopClientEnvironment {
    public static void init() throws HopException {
        HopGuiEnvironment.init(List.of(GuiPluginType.getInstance(), HopPerspectivePluginType.getInstance(), HopFileTypePluginType.getInstance(), SearchableAnalyserPluginType.getInstance()));
    }

    public static void init(List<IPluginType> pluginTypes) throws HopException {
        pluginTypes.forEach(PluginRegistry::addPluginType);
        for (IPluginType pluginType : pluginTypes) {
            pluginType.searchPlugins();
        }
        HopGuiEnvironment.initGuiPlugins();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initGuiPlugins() throws HopException {
        try {
            GuiRegistry guiRegistry = GuiRegistry.getInstance();
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            List guiPlugins = pluginRegistry.getPlugins(GuiPluginType.class);
            for (IPlugin guiPlugin : guiPlugins) {
                ClassLoader classLoader = pluginRegistry.getClassLoader(guiPlugin);
                Class[] typeClasses = guiPlugin.getClassMap().keySet().toArray(new Class[0]);
                String guiPluginClassName = (String)guiPlugin.getClassMap().get(typeClasses[0]);
                Class<?> guiPluginClass = classLoader.loadClass(guiPluginClassName);
                List fields = HopGuiEnvironment.findDeclaredFields(guiPluginClass);
                for (Field field : fields) {
                    GuiWidgetElement guiElement = field.getAnnotation(GuiWidgetElement.class);
                    if (guiElement == null) continue;
                    guiRegistry.addGuiWidgetElement(guiPluginClassName, guiElement, field);
                }
                List methods = HopGuiEnvironment.findDeclaredMethods(guiPluginClass);
                for (Method method : methods) {
                    GuiCallback guiCallback;
                    GuiContextActionFilter actionFilter;
                    GuiContextAction contextAction;
                    GuiOsxKeyboardShortcut osxShortcut;
                    GuiKeyboardShortcut shortcut;
                    GuiToolbarElement toolbarElement;
                    GuiMenuElement menuElement = method.getAnnotation(GuiMenuElement.class);
                    if (menuElement != null) {
                        guiRegistry.addGuiWidgetElement(guiPluginClassName, menuElement, method, classLoader);
                    }
                    if ((toolbarElement = method.getAnnotation(GuiToolbarElement.class)) != null) {
                        guiRegistry.addGuiToolbarElement(guiPluginClassName, toolbarElement, method, classLoader);
                    }
                    if ((shortcut = method.getAnnotation(GuiKeyboardShortcut.class)) != null) {
                        if (EnvironmentUtils.getInstance().isWeb() && shortcut.key() == 27) continue;
                        guiRegistry.addKeyboardShortcut(guiPluginClassName, method, shortcut);
                    }
                    if ((osxShortcut = method.getAnnotation(GuiOsxKeyboardShortcut.class)) != null) {
                        if (EnvironmentUtils.getInstance().isWeb() && osxShortcut.key() == 27) continue;
                        guiRegistry.addKeyboardShortcut(guiPluginClassName, method, osxShortcut);
                    }
                    if ((contextAction = method.getAnnotation(GuiContextAction.class)) != null) {
                        guiRegistry.addGuiContextAction(guiPluginClassName, method, contextAction, classLoader);
                    }
                    if ((actionFilter = method.getAnnotation(GuiContextActionFilter.class)) != null) {
                        guiRegistry.addGuiActionFilter(guiPluginClassName, method, actionFilter, classLoader);
                    }
                    if ((guiCallback = method.getAnnotation(GuiCallback.class)) == null) continue;
                    guiRegistry.registerGuiCallback(guiPluginClass, method, guiCallback);
                }
            }
            guiRegistry.sortAllElements();
            PluginRegistry registry = PluginRegistry.getInstance();
            List plugins = registry.getPlugins(HopFileTypePluginType.class);
            for (IPlugin plugin : plugins) {
                try {
                    IHopFileType hopFileTypeInterface = (IHopFileType)registry.loadClass(plugin, IHopFileType.class);
                    HopFileTypeRegistry.getInstance().registerHopFile(hopFileTypeInterface);
                }
                catch (HopPluginException e) {
                    throw new HopException("Unable to load plugin with ID '" + plugin.getIds()[0] + "' and type : " + plugin.getPluginType().getName(), (Throwable)e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error looking for Elements in GUI Plugins ", (Throwable)e);
        }
    }
}

