/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.dataorch;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;

public abstract class HopGuiAbstractGraph
extends Composite {
    public static final String STATE_MAGNIFICATION = "magnification";
    public static final String STATE_SCROLL_X_THUMB = "scroll-x-thumb";
    public static final String STATE_SCROLL_X_SELECTION = "scroll-x-selection";
    public static final String STATE_SCROLL_X_MIN = "scroll-x-min";
    public static final String STATE_SCROLL_X_MAX = "scroll-x-max";
    public static final String STATE_SCROLL_Y_THUMB = "scroll-y-thumb";
    public static final String STATE_SCROLL_Y_SELECTION = "scroll-y-selection";
    public static final String STATE_SCROLL_Y_MIN = "scroll-y-min";
    public static final String STATE_SCROLL_Y_MAX = "scroll-y-max";
    protected HopGui hopGui;
    protected IVariables variables;
    protected Composite parentComposite;
    protected CTabItem parentTabItem;
    protected Point offset;
    protected Point iconOffset;
    protected Point noteOffset;
    protected ScrolledComposite wsCanvas;
    protected Canvas canvas;
    protected float magnification = 1.0f;
    private boolean changedState;
    private Font defaultFont;
    protected final String id;
    protected ToolTip toolTip;
    protected Map<String, Object> stateMap;
    protected boolean avoidScrollAdjusting;
    protected boolean viewDrag;
    protected Point viewDragStart;
    protected int startHorizontalDragSelection;
    protected int startVerticalDragSelection;

    public HopGuiAbstractGraph(HopGui hopGui, Composite parent, int style, CTabItem parentTabItem) {
        super(parent, style);
        this.parentComposite = parent;
        this.hopGui = hopGui;
        this.variables = new Variables();
        this.variables.copyFrom(hopGui.getVariables());
        this.parentTabItem = parentTabItem;
        this.defaultFont = parentTabItem.getFont();
        this.changedState = false;
        this.id = UUID.randomUUID().toString();
        this.stateMap = new HashMap<String, Object>();
    }

    protected Shell hopShell() {
        return this.hopGui.getShell();
    }

    protected Display hopDisplay() {
        return this.hopGui.getDisplay();
    }

    protected abstract Point getOffset();

    protected Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        ScrollBar horizontalScrollBar = this.wsCanvas.getHorizontalBar();
        ScrollBar verticalScrollBar = this.wsCanvas.getVerticalBar();
        Point sel = new Point(horizontalScrollBar.getSelection(), verticalScrollBar.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        float cm = this.calculateCorrectedMagnification();
        p.x = Math.round((float)(-sel.x * area.x / thumb.x) / cm);
        p.y = Math.round((float)(-sel.y * area.y / thumb.y) / cm);
        return p;
    }

    protected float calculateCorrectedMagnification() {
        return (float)((double)this.magnification * PropsUi.getInstance().getZoomFactor());
    }

    protected Point magnifyPoint(Point p) {
        float cm = this.calculateCorrectedMagnification();
        return new Point(Math.round((float)p.x * cm), Math.round((float)p.y * cm));
    }

    protected Point getThumb(Point area, Point pipelineMax) {
        Point resizedMax = this.magnifyPoint(pipelineMax);
        Point thumb = new Point(0, 0);
        thumb.x = resizedMax.x <= area.x ? 100 : 100 * area.x / resizedMax.x;
        thumb.y = resizedMax.y <= area.y ? 100 : 100 * area.y / resizedMax.y;
        return thumb;
    }

    public int sign(int n) {
        return n < 0 ? -1 : (n > 0 ? 1 : 1);
    }

    protected Point getArea() {
        Rectangle rect = this.canvas.getClientArea();
        Point area = new Point(rect.width, rect.height);
        return area;
    }

    public abstract boolean hasChanged();

    public void redraw() {
        if (this.isDisposed() || this.canvas == null || this.canvas.isDisposed() || this.parentTabItem.isDisposed()) {
            return;
        }
        if (this.hasChanged() != this.changedState) {
            this.changedState = this.hasChanged();
            if (this.hasChanged()) {
                this.parentTabItem.setFont(GuiResource.getInstance().getFontBold());
            } else {
                this.parentTabItem.setFont(this.defaultFont);
            }
        }
        this.canvas.redraw();
    }

    public abstract void setZoomLabel();

    @GuiKeyboardShortcut(control=true, key=61)
    public void zoomInShortcut() {
        this.zoomIn();
    }

    @GuiKeyboardShortcut(control=true, key=43)
    public void zoomIn() {
        this.magnification += 0.1f;
        if (this.magnification > 10.0f) {
            this.magnification = 10.0f;
        }
        this.adjustScrolling();
        this.setZoomLabel();
        this.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=45)
    public void zoomOut() {
        this.magnification -= 0.1f;
        if (this.magnification < 0.1f) {
            this.magnification = 0.1f;
        }
        this.adjustScrolling();
        this.setZoomLabel();
        this.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=48)
    public void zoom100Percent() {
        this.magnification = 1.0f;
        this.adjustScrolling();
        this.setZoomLabel();
        this.redraw();
    }

    public Point screen2real(int x, int y) {
        this.offset = this.getOffset();
        float correctedMagnification = this.calculateCorrectedMagnification();
        Point real = this.offset != null ? new Point(Math.round((float)x / correctedMagnification - (float)this.offset.x), Math.round((float)y / correctedMagnification - (float)this.offset.y)) : new Point(x, y);
        return real;
    }

    public Point real2screen(int x, int y) {
        this.offset = this.getOffset();
        Point screen = new Point(x + this.offset.x, y + this.offset.y);
        return screen;
    }

    public boolean forceFocus() {
        return this.canvas.forceFocus();
    }

    public void dispose() {
        this.parentTabItem.dispose();
    }

    public CTabItem getParentTabItem() {
        return this.parentTabItem;
    }

    public void setParentTabItem(CTabItem parentTabItem) {
        this.parentTabItem = parentTabItem;
    }

    public Composite getParentComposite() {
        return this.parentComposite;
    }

    public void setParentComposite(Composite parentComposite) {
        this.parentComposite = parentComposite;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getStateProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STATE_MAGNIFICATION, Float.valueOf(this.magnification));
        ScrollBar horizontalScrollBar = this.wsCanvas.getHorizontalBar();
        ScrollBar verticalScrollBar = this.wsCanvas.getVerticalBar();
        map.put(STATE_SCROLL_X_SELECTION, horizontalScrollBar != null ? horizontalScrollBar.getSelection() : 0);
        map.put(STATE_SCROLL_Y_SELECTION, verticalScrollBar != null ? verticalScrollBar.getSelection() : 0);
        return map;
    }

    public void applyStateProperties(Map<String, Object> stateProperties) {
        Integer scrollYSelection;
        Double fMagnification = (Double)stateProperties.get(STATE_MAGNIFICATION);
        this.magnification = fMagnification == null ? 1.0f : fMagnification.floatValue();
        this.setZoomLabel();
        this.adjustScrolling();
        ScrollBar horizontalScrollBar = this.wsCanvas.getHorizontalBar();
        ScrollBar verticalScrollBar = this.wsCanvas.getVerticalBar();
        Integer scrollXSelection = (Integer)stateProperties.get(STATE_SCROLL_X_SELECTION);
        if (scrollXSelection != null && horizontalScrollBar != null) {
            horizontalScrollBar.setSelection(scrollXSelection.intValue());
        }
        if ((scrollYSelection = (Integer)stateProperties.get(STATE_SCROLL_Y_SELECTION)) != null && verticalScrollBar != null) {
            verticalScrollBar.setSelection(scrollYSelection.intValue());
        }
        this.redraw();
    }

    public abstract void adjustScrolling();

    protected void adjustScrolling(Point maximum) {
        int newWidth = (int)(this.calculateCorrectedMagnification() * (float)maximum.x);
        int newHeight = (int)(this.calculateCorrectedMagnification() * (float)maximum.y);
        int horizontalPct = 1;
        int verticalPct = 1;
        Rectangle canvasBounds = this.wsCanvas.getBounds();
        ScrollBar h = this.wsCanvas.getHorizontalBar();
        ScrollBar v = this.wsCanvas.getVerticalBar();
        if (canvasBounds.width == 0 || canvasBounds.height == 0) {
            h.setVisible(false);
            v.setVisible(false);
            return;
        }
        if (h != null) {
            horizontalPct = (int)Math.round(100.0 * (double)h.getSelection() / 100.0);
        }
        if (v != null) {
            verticalPct = (int)Math.round(100.0 * (double)v.getSelection() / 100.0);
        }
        this.canvas.setSize(canvasBounds.width, canvasBounds.height);
        if (h != null) {
            h.setVisible(newWidth >= canvasBounds.width);
        }
        if (v != null) {
            v.setVisible(newHeight >= canvasBounds.height);
        }
        int hThumb = (int)(100.0 * (double)canvasBounds.width / (double)newWidth);
        int vThumb = (int)(100.0 * (double)canvasBounds.height / (double)newHeight);
        if (h != null) {
            h.setMinimum(1);
            h.setMaximum(100);
            h.setThumb(Math.min(hThumb, 100));
            if (!EnvironmentUtils.getInstance().isWeb()) {
                h.setPageIncrement(5);
                h.setIncrement(1);
            }
            h.setSelection(horizontalPct);
        }
        if (v != null) {
            v.setMinimum(1);
            v.setMaximum(100);
            v.setThumb(Math.min(vThumb, 100));
            if (!EnvironmentUtils.getInstance().isWeb()) {
                v.setPageIncrement(5);
                v.setIncrement(1);
            }
            v.setSelection(verticalPct);
        }
        this.canvas.setFocus();
    }

    protected void showToolTip(org.eclipse.swt.graphics.Point location) {
        org.eclipse.swt.graphics.Point p = this.canvas.toDisplay(location);
        this.toolTip.setLocation(p.x + 5, p.y + 5);
        this.toolTip.setVisible(true);
    }

    protected void setupDragView(int button, Point screenClick) {
        boolean bl = this.viewDrag = button == 2;
        if (this.viewDrag) {
            this.viewDragStart = screenClick;
            this.startHorizontalDragSelection = this.wsCanvas.getHorizontalBar() != null ? this.wsCanvas.getHorizontalBar().getSelection() : -1;
            this.startVerticalDragSelection = this.wsCanvas.getVerticalBar() != null ? this.wsCanvas.getVerticalBar().getSelection() : -1;
        }
    }

    protected void dragView(Point lastClick, Point real) {
        ScrollBar v;
        int deltaX = (int)Math.round((double)(lastClick.x - real.x) / (10.0 * PropsUi.getInstance().getZoomFactor()) / Math.max(1.0, (double)this.magnification));
        int deltaY = (int)Math.round((double)(lastClick.y - real.y) / (10.0 * PropsUi.getInstance().getZoomFactor()) / Math.max(1.0, (double)this.magnification));
        ScrollBar h = this.wsCanvas.getHorizontalBar();
        if (h != null && this.startHorizontalDragSelection > 0) {
            int newSelection = Math.max(h.getMinimum(), Math.min(this.startHorizontalDragSelection + deltaX, h.getMaximum()));
            h.setSelection(newSelection);
        }
        if ((v = this.wsCanvas.getVerticalBar()) != null && this.startVerticalDragSelection > 0) {
            int newSelection = Math.max(v.getMinimum(), Math.min(this.startVerticalDragSelection + deltaY, v.getMaximum()));
            v.setSelection(newSelection);
        }
        this.redraw();
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public Map<String, Object> getStateMap() {
        return this.stateMap;
    }

    public void setStateMap(Map<String, Object> stateMap) {
        this.stateMap = stateMap;
    }

    public boolean isAvoidScrollAdjusting() {
        return this.avoidScrollAdjusting;
    }

    public void setAvoidScrollAdjusting(boolean avoidScrollAdjusting) {
        this.avoidScrollAdjusting = avoidScrollAdjusting;
    }
}

