/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.ui.core.PropsUi;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class EnvironmentUtils {
    private static final EnvironmentUtils ENVIRONMENT_UTILS = new EnvironmentUtils();
    private static final Pattern MSIE_PATTERN = Pattern.compile("MSIE (\\d+)");
    private static final Pattern SAFARI_PATTERN = Pattern.compile("AppleWebKit\\/(\\d+)");
    private static final String SUPPORTED_DISTRIBUTION_NAME = "ubuntu";
    public static final String UBUNTU_BROWSER = "Midori";
    public static final String MAC_BROWSER = "Safari";
    public static final String WINDOWS_BROWSER = "MSIE";
    private final ILogChannel log = new LogChannel((Object)this);

    public static synchronized EnvironmentUtils getInstance() {
        return ENVIRONMENT_UTILS;
    }

    public synchronized boolean isUnsupportedBrowserEnvironment() {
        if (this.getEnvironmentName().contains("linux")) {
            return false;
        }
        String userAgent = this.getUserAgent();
        if (userAgent == null) {
            return true;
        }
        return this.checkUserAgent(MSIE_PATTERN.matcher(userAgent), this.getSupportedVersion("min.windows.browser.supported")) || this.checkUserAgent(SAFARI_PATTERN.matcher(userAgent), this.getSupportedVersion("min.mac.browser.supported"));
    }

    private boolean checkUserAgent(Matcher matcher, int version) {
        return matcher.find() && Integer.parseInt(matcher.group(1)) < version;
    }

    protected String getUserAgent() {
        Browser browser;
        try {
            browser = new Browser((Composite)new Shell(), 0);
        }
        catch (SWTError e) {
            this.log.logError("Could not open a browser", (Throwable)e);
            return "";
        }
        String userAgent = browser.evaluate("return window.navigator.userAgent;").toString();
        browser.close();
        return userAgent;
    }

    public synchronized boolean isWebkitUnavailable() {
        String path = this.getWebkitPath();
        String osName = this.getEnvironmentName();
        return !(path != null && path.length() >= 1 && path.contains("webkit") || !osName.contains("ubuntu " + this.getSupportedVersion("max.ubuntu.os.distribution.supported")) && !osName.contains("ubuntu " + this.getSupportedVersion("min.ubuntu.os.distribution.supported")));
    }

    protected String getWebkitPath() {
        return System.getenv("LIBWEBKITGTK");
    }

    private String getEnvironmentName() {
        String osName = this.getOsName();
        if (osName.contentEquals("linux")) {
            return osName + " " + this.getLinuxDistribution().toLowerCase();
        }
        return osName;
    }

    protected String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    protected int getSupportedVersion(String property) {
        return PropsUi.getInstance().getSupportedVersion(property);
    }

    public boolean isBrowserEnvironmentCheckDisabled() {
        return PropsUi.getInstance().isBrowserEnvironmentCheckDisabled();
    }

    private String getLinuxDistribution() {
        Process p = null;
        try {
            p = this.ExecuteCommand("lsb_release -d");
        }
        catch (IOException e) {
            this.log.logError("Could not execute command", (Throwable)e);
            return "";
        }
        BufferedReader in = this.getBufferedReaderFromProcess(p);
        try {
            return in.readLine();
        }
        catch (IOException e) {
            this.log.logError("Could not read the distribution name", (Throwable)e);
            return "";
        }
    }

    protected Process ExecuteCommand(String command) throws IOException {
        return Runtime.getRuntime().exec(command);
    }

    protected BufferedReader getBufferedReaderFromProcess(Process p) {
        return new BufferedReader(new InputStreamReader(p.getInputStream()));
    }

    public synchronized String getBrowserName() {
        String userAgent = this.getUserAgent();
        if (userAgent == null) {
            return "";
        }
        if (userAgent.contains(WINDOWS_BROWSER)) {
            return WINDOWS_BROWSER;
        }
        if (userAgent.contains(UBUNTU_BROWSER)) {
            return UBUNTU_BROWSER;
        }
        if (userAgent.contains(MAC_BROWSER)) {
            return MAC_BROWSER;
        }
        return "";
    }

    public boolean isWeb() {
        return SWT.getPlatform().equals("rap");
    }

    public String getHopWebTheme() {
        return System.getProperty("HOP_WEB_THEME");
    }
}

