/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import java.io.Serializable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableServiceImpl;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
abstract class BigtableConfig
implements Serializable {
    BigtableConfig() {
    }

    abstract @Nullable ValueProvider<String> getProjectId();

    abstract @Nullable ValueProvider<String> getInstanceId();

    abstract @Nullable ValueProvider<String> getTableId();

    @Deprecated
    abstract @Nullable BigtableOptions getBigtableOptions();

    abstract @Nullable SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
    BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
    BigtableOptions.Builder> getBigtableOptionsConfigurator();

    abstract boolean getValidate();

    abstract @Nullable BigtableService getBigtableService();

    abstract @Nullable String getEmulatorHost();

    abstract Builder toBuilder();

    static Builder builder() {
        return new AutoValue_BigtableConfig.Builder();
    }

    BigtableConfig withProjectId(ValueProvider<String> projectId) {
        Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"Project Id of BigTable can not be null");
        return this.toBuilder().setProjectId(projectId).build();
    }

    BigtableConfig withInstanceId(ValueProvider<String> instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"Instance Id of BigTable can not be null");
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    BigtableConfig withTableId(ValueProvider<String> tableId) {
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId can not be null");
        return this.toBuilder().setTableId(tableId).build();
    }

    @Deprecated
    BigtableConfig withBigtableOptions(BigtableOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"Bigtable options can not be null");
        return this.toBuilder().setBigtableOptions(options).build();
    }

    BigtableConfig withBigtableOptionsConfigurator(SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> configurator) {
        Preconditions.checkArgument((configurator != null ? 1 : 0) != 0, (Object)"configurator can not be null");
        return this.toBuilder().setBigtableOptionsConfigurator(configurator).build();
    }

    BigtableConfig withValidate(boolean isEnabled) {
        return this.toBuilder().setValidate(isEnabled).build();
    }

    @VisibleForTesting
    BigtableConfig withBigtableService(BigtableService bigtableService) {
        Preconditions.checkArgument((bigtableService != null ? 1 : 0) != 0, (Object)"bigtableService can not be null");
        return this.toBuilder().setBigtableService(bigtableService).build();
    }

    @VisibleForTesting
    BigtableConfig withEmulator(String emulatorHost) {
        Preconditions.checkArgument((emulatorHost != null ? 1 : 0) != 0, (Object)"emulatorHost can not be null");
        return this.toBuilder().setEmulatorHost(emulatorHost).build();
    }

    void validate() {
        Preconditions.checkArgument((this.getTableId() != null && (!this.getTableId().isAccessible() || !((String)this.getTableId().get()).isEmpty()) ? 1 : 0) != 0, (Object)"Could not obtain Bigtable table id");
        Preconditions.checkArgument((this.getProjectId() != null && (!this.getProjectId().isAccessible() || !((String)this.getProjectId().get()).isEmpty()) || this.getBigtableOptions() != null && this.getBigtableOptions().getProjectId() != null && !this.getBigtableOptions().getProjectId().isEmpty() ? 1 : 0) != 0, (Object)"Could not obtain Bigtable project id");
        Preconditions.checkArgument((this.getInstanceId() != null && (!this.getInstanceId().isAccessible() || !((String)this.getInstanceId().get()).isEmpty()) || this.getBigtableOptions() != null && this.getBigtableOptions().getInstanceId() != null && !this.getBigtableOptions().getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)"Could not obtain Bigtable instance id");
    }

    void populateDisplayData(DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Bigtable Project Id")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Bigtable Instance Id")).addIfNotNull(DisplayData.item((String)"tableId", this.getTableId()).withLabel("Bigtable Table Id")).add(DisplayData.item((String)"withValidation", (Boolean)this.getValidate()).withLabel("Check is table exists"));
        if (this.getBigtableOptions() != null) {
            builder.add(DisplayData.item((String)"bigtableOptions", (String)this.getBigtableOptions().toString()).withLabel("Bigtable Options"));
        }
    }

    @VisibleForTesting
    BigtableService getBigtableService(PipelineOptions pipelineOptions) {
        if (this.getBigtableService() != null) {
            return this.getBigtableService();
        }
        BigtableOptions.Builder bigtableOptions = this.effectiveUserProvidedBigtableOptions();
        bigtableOptions.setUserAgent(pipelineOptions.getUserAgent());
        if (bigtableOptions.build().getCredentialOptions().getCredentialType() == CredentialOptions.CredentialType.DefaultCredentials) {
            bigtableOptions.setCredentialOptions(CredentialOptions.credential((Credentials)((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential()));
        }
        return new BigtableServiceImpl(bigtableOptions.build());
    }

    boolean isDataAccessible() {
        return !(!this.getTableId().isAccessible() || this.getProjectId() != null && !this.getProjectId().isAccessible() || this.getInstanceId() != null && !this.getInstanceId().isAccessible());
    }

    private BigtableOptions.Builder effectiveUserProvidedBigtableOptions() {
        BigtableOptions.Builder effectiveOptions;
        BigtableOptions.Builder builder = effectiveOptions = this.getBigtableOptions() != null ? this.getBigtableOptions().toBuilder() : new BigtableOptions.Builder();
        if (this.getBigtableOptionsConfigurator() != null) {
            effectiveOptions = (BigtableOptions.Builder)this.getBigtableOptionsConfigurator().apply((Object)effectiveOptions);
        }
        effectiveOptions.setUseCachedDataPool(true);
        if (this.getInstanceId() != null) {
            effectiveOptions.setInstanceId((String)this.getInstanceId().get());
        }
        if (this.getProjectId() != null) {
            effectiveOptions.setProjectId((String)this.getProjectId().get());
        }
        if (this.getEmulatorHost() != null) {
            effectiveOptions.enableEmulator(this.getEmulatorHost());
            effectiveOptions.setUseCachedDataPool(false);
        }
        return effectiveOptions;
    }

    public final String toString() {
        return MoreObjects.toStringHelper(BigtableConfig.class).add("projectId", this.getProjectId()).add("instanceId", this.getInstanceId()).add("tableId", this.getTableId()).add("bigtableOptionsConfigurator", this.getBigtableOptionsConfigurator() == null ? null : this.getBigtableOptionsConfigurator().getClass().getName()).add("options", (Object)this.getBigtableOptions()).toString();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setProjectId(ValueProvider<String> var1);

        abstract Builder setInstanceId(ValueProvider<String> var1);

        abstract Builder setTableId(ValueProvider<String> var1);

        @Deprecated
        abstract Builder setBigtableOptions(BigtableOptions var1);

        abstract Builder setValidate(boolean var1);

        abstract Builder setBigtableOptionsConfigurator(SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> var1);

        abstract Builder setBigtableService(BigtableService var1);

        abstract Builder setEmulatorHost(String var1);

        abstract BigtableConfig build();
    }
}

