/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.WriteResult;
import com.google.rpc.Status;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1WriteFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public final class FirestoreV1 {
    static final FirestoreV1 INSTANCE = new FirestoreV1();

    private FirestoreV1() {
    }

    public Read read() {
        return Read.INSTANCE;
    }

    public Write write() {
        return Write.INSTANCE;
    }

    private static abstract class Transform<InT extends PInput, OutT extends POutput, TrfmT extends Transform<InT, OutT, TrfmT, BldrT>, BldrT extends Builder<InT, OutT, TrfmT, BldrT>>
    extends PTransform<InT, OutT>
    implements HasDisplayData {
        final JodaClock clock;
        final FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
        final RpcQosOptions rpcQosOptions;

        Transform(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            this.clock = clock;
            this.firestoreStatefulComponentFactory = firestoreStatefulComponentFactory;
            this.rpcQosOptions = rpcQosOptions;
        }

        public final void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
        }

        public abstract BldrT toBuilder();

        static abstract class Builder<InT extends PInput, OutT extends POutput, TrfmT extends Transform<InT, OutT, TrfmT, BldrT>, BldrT extends Builder<InT, OutT, TrfmT, BldrT>> {
            JodaClock clock;
            FirestoreStatefulComponentFactory firestoreStatefulComponentFactory;
            RpcQosOptions rpcQosOptions;

            Builder() {
                this.clock = JodaClock.DEFAULT;
                this.firestoreStatefulComponentFactory = FirestoreStatefulComponentFactory.INSTANCE;
                this.rpcQosOptions = RpcQosOptions.defaultOptions();
            }

            private Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                this.clock = clock;
                this.firestoreStatefulComponentFactory = firestoreStatefulComponentFactory;
                this.rpcQosOptions = rpcQosOptions;
            }

            BldrT self() {
                return (BldrT)this;
            }

            public abstract TrfmT build();

            final TrfmT genericBuild() {
                return this.buildSafe(Objects.requireNonNull(this.clock, "clock must be non null"), Objects.requireNonNull(this.firestoreStatefulComponentFactory, "firestoreFactory must be non null"), Objects.requireNonNull(this.rpcQosOptions, "rpcQosOptions must be non null"));
            }

            abstract TrfmT buildSafe(JodaClock var1, FirestoreStatefulComponentFactory var2, RpcQosOptions var3);

            public final BldrT withRpcQosOptions(RpcQosOptions rpcQosOptions) {
                Objects.requireNonNull(rpcQosOptions, "rpcQosOptions must be non null");
                this.rpcQosOptions = rpcQosOptions;
                return this.self();
            }
        }
    }

    public static class FailedWritesException
    extends RuntimeException {
        private final List<WriteFailure> writeFailures;

        public FailedWritesException(List<WriteFailure> writeFailures) {
            super(String.format("Not-retryable status code(s) for %d writes", writeFailures.size()));
            this.writeFailures = writeFailures;
        }

        public List<WriteFailure> getWriteFailures() {
            return this.writeFailures;
        }
    }

    @Immutable
    public static final class WriteFailure
    implements Serializable {
        private final com.google.firestore.v1.Write write;
        private final WriteResult writeResult;
        private final Status status;

        public WriteFailure(com.google.firestore.v1.Write write, WriteResult writeResult, Status status) {
            this.write = write;
            this.writeResult = writeResult;
            this.status = status;
        }

        public com.google.firestore.v1.Write getWrite() {
            return this.write;
        }

        public WriteResult getWriteResult() {
            return this.writeResult;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WriteFailure)) {
                return false;
            }
            WriteFailure that = (WriteFailure)o;
            return this.write.equals((Object)that.write) && this.writeResult.equals((Object)that.writeResult) && this.status.equals((Object)that.status);
        }

        public int hashCode() {
            return Objects.hash(this.write, this.writeResult, this.status);
        }
    }

    @Immutable
    public static final class WriteSuccessSummary
    implements Serializable {
        private final int numWrites;
        private final long numBytes;

        public WriteSuccessSummary(int numWrites, long numBytes) {
            this.numWrites = numWrites;
            this.numBytes = numBytes;
        }

        public int getNumWrites() {
            return this.numWrites;
        }

        public long getNumBytes() {
            return this.numBytes;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WriteSuccessSummary)) {
                return false;
            }
            WriteSuccessSummary that = (WriteSuccessSummary)o;
            return this.numWrites == that.numWrites && this.numBytes == that.numBytes;
        }

        public int hashCode() {
            return Objects.hash(this.numWrites, this.numBytes);
        }

        public String toString() {
            return "WriteSummary{numWrites=" + this.numWrites + ", numBytes=" + this.numBytes + '}';
        }
    }

    public static final class BatchWriteWithDeadLetterQueue
    extends Transform<PCollection<com.google.firestore.v1.Write>, PCollection<WriteFailure>, BatchWriteWithDeadLetterQueue, Builder> {
        private BatchWriteWithDeadLetterQueue(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        public PCollection<WriteFailure> expand(PCollection<com.google.firestore.v1.Write> input) {
            return (PCollection)input.apply("batchWrite", (PTransform)ParDo.of((DoFn)new FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, CounterFactory.DEFAULT)));
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<com.google.firestore.v1.Write>, PCollection<WriteFailure>, BatchWriteWithDeadLetterQueue, Builder> {
            private Builder() {
            }

            private Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            @Override
            public BatchWriteWithDeadLetterQueue build() {
                return (BatchWriteWithDeadLetterQueue)((Object)this.genericBuild());
            }

            @Override
            BatchWriteWithDeadLetterQueue buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new BatchWriteWithDeadLetterQueue(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }
        }
    }

    public static final class BatchWriteWithSummary
    extends Transform<PCollection<com.google.firestore.v1.Write>, PCollection<WriteSuccessSummary>, BatchWriteWithSummary, Builder> {
        private BatchWriteWithSummary(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        public PCollection<WriteSuccessSummary> expand(PCollection<com.google.firestore.v1.Write> input) {
            return (PCollection)input.apply("batchWrite", (PTransform)ParDo.of((DoFn)new FirestoreV1WriteFn.BatchWriteFnWithSummary(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, CounterFactory.DEFAULT)));
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<com.google.firestore.v1.Write>, PCollection<WriteSuccessSummary>, BatchWriteWithSummary, Builder> {
            private Builder() {
            }

            private Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            public BatchWriteWithDeadLetterQueue.Builder withDeadLetterQueue() {
                return new BatchWriteWithDeadLetterQueue.Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
            }

            @Override
            public BatchWriteWithSummary build() {
                return (BatchWriteWithSummary)((Object)this.genericBuild());
            }

            @Override
            BatchWriteWithSummary buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new BatchWriteWithSummary(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }
        }
    }

    private static final class ListDocumentsResponseToDocument
    extends DoFn<ListDocumentsResponse, Document> {
        private ListDocumentsResponseToDocument() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            ((ListDocumentsResponse)c.element()).getDocumentsList().forEach(arg_0 -> ((DoFn.ProcessContext)c).output(arg_0));
        }
    }

    private static final class FlattenListCollectionIdsResponse
    extends DoFn<ListCollectionIdsResponse, String> {
        private FlattenListCollectionIdsResponse() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            ((ListCollectionIdsResponse)c.element()).getCollectionIdsList().forEach(arg_0 -> ((DoFn.ProcessContext)c).output(arg_0));
        }
    }

    public static final class PartitionQuery
    extends Transform<PCollection<PartitionQueryRequest>, PCollection<RunQueryRequest>, PartitionQuery, Builder> {
        private final boolean nameOnlyQuery;

        private PartitionQuery(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions, boolean nameOnlyQuery) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            this.nameOnlyQuery = nameOnlyQuery;
        }

        public PCollection<RunQueryRequest> expand(PCollection<PartitionQueryRequest> input) {
            PCollection queries = (PCollection)((PCollection)input.apply("PartitionQuery", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.PartitionQueryFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions)))).apply("expand queries", (PTransform)ParDo.of((DoFn)new PartitionQueryResponseToRunQueryRequest()));
            if (this.nameOnlyQuery) {
                queries = (PCollection)queries.apply("set name only query", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<RunQueryRequest, RunQueryRequest>(){

                    public RunQueryRequest apply(RunQueryRequest input) {
                        RunQueryRequest.Builder builder = input.toBuilder();
                        builder.getStructuredQueryBuilder().setSelect(StructuredQuery.Projection.newBuilder().addFields(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__").build()).build());
                        return builder.build();
                    }
                }));
            }
            return (PCollection)queries.apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions, this.nameOnlyQuery);
        }

        static final class PartitionQueryResponseToRunQueryRequest
        extends DoFn<FirestoreV1ReadFn.PartitionQueryPair, RunQueryRequest> {
            static final Comparator<Cursor> CURSOR_REFERENCE_VALUE_COMPARATOR;

            PartitionQueryResponseToRunQueryRequest() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                FirestoreV1ReadFn.PartitionQueryPair pair = (FirestoreV1ReadFn.PartitionQueryPair)c.element();
                PartitionQueryRequest partitionQueryRequest = pair.getRequest();
                String dbRoot = partitionQueryRequest.getParent();
                StructuredQuery structuredQuery = partitionQueryRequest.getStructuredQuery();
                PartitionQueryResponse partitionQueryResponse = pair.getResponse();
                ArrayList<Cursor> cursors = new ArrayList<Cursor>(partitionQueryResponse.getPartitionsList());
                cursors.sort(CURSOR_REFERENCE_VALUE_COMPARATOR);
                int size = cursors.size();
                if (size == 0) {
                    this.emit(c, dbRoot, structuredQuery.toBuilder());
                    return;
                }
                int lastIdx = size - 1;
                for (int i = 0; i < size; ++i) {
                    Cursor curr = (Cursor)cursors.get(i);
                    if (i == 0) {
                        this.emit(c, dbRoot, structuredQuery.toBuilder().setEndAt(curr));
                    }
                    if (0 < i && i <= lastIdx) {
                        Cursor prev = (Cursor)cursors.get(i - 1);
                        this.emit(c, dbRoot, structuredQuery.toBuilder().setStartAt(prev).setEndAt(curr));
                    }
                    if (i != lastIdx) continue;
                    this.emit(c, dbRoot, structuredQuery.toBuilder().setStartAt(curr));
                }
            }

            private void emit(DoFn.ProcessContext c, String dbRoot, StructuredQuery.Builder builder) {
                RunQueryRequest runQueryRequest = RunQueryRequest.newBuilder().setParent(dbRoot).setStructuredQuery(builder.build()).build();
                c.output((Object)runQueryRequest);
            }

            static {
                Function<Cursor, Optional> firstReferenceValue = c -> c.getValuesList().stream().filter(v -> {
                    String referenceValue = v.getReferenceValue();
                    return referenceValue != null && !referenceValue.isEmpty();
                }).findFirst();
                Function<String, String[]> stringToPath = s -> s.split("/");
                Comparator pathWiseCompare = (path1, path2) -> {
                    int minLength = Math.min(((String[])path1).length, ((String[])path2).length);
                    for (int i = 0; i < minLength; ++i) {
                        String pathSegment1 = path1[i];
                        String pathSegment2 = path2[i];
                        int compare = pathSegment1.compareTo(pathSegment2);
                        if (compare == 0) continue;
                        return compare;
                    }
                    if (((String[])path1).length == ((String[])path2).length) {
                        return 0;
                    }
                    if (minLength == ((String[])path1).length) {
                        return -1;
                    }
                    return 1;
                };
                CURSOR_REFERENCE_VALUE_COMPARATOR = Comparator.comparing(firstReferenceValue, (o1, o2) -> {
                    if (o1.isPresent() && o2.isPresent()) {
                        return pathWiseCompare.compare((String[])stringToPath.apply(((Value)o1.get()).getReferenceValue()), (String[])stringToPath.apply(((Value)o2.get()).getReferenceValue()));
                    }
                    if (o1.isPresent()) {
                        return -1;
                    }
                    return 1;
                });
            }
        }

        public static final class Builder
        extends Transform.Builder<PCollection<PartitionQueryRequest>, PCollection<RunQueryRequest>, PartitionQuery, Builder> {
            private boolean nameOnlyQuery = false;

            private Builder() {
            }

            public Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions, boolean nameOnlyQuery) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
                this.nameOnlyQuery = nameOnlyQuery;
            }

            @Override
            public PartitionQuery build() {
                return (PartitionQuery)((Object)this.genericBuild());
            }

            public Builder withNameOnlyQuery() {
                this.nameOnlyQuery = true;
                return this;
            }

            @Override
            PartitionQuery buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new PartitionQuery(clock, firestoreStatefulComponentFactory, rpcQosOptions, this.nameOnlyQuery);
            }
        }
    }

    public static final class BatchGetDocuments
    extends Transform<PCollection<BatchGetDocumentsRequest>, PCollection<BatchGetDocumentsResponse>, BatchGetDocuments, Builder> {
        private BatchGetDocuments(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        public PCollection<BatchGetDocumentsResponse> expand(PCollection<BatchGetDocumentsRequest> input) {
            return (PCollection)((PCollection)input.apply("batchGetDocuments", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.BatchGetDocumentsFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions)))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<BatchGetDocumentsRequest>, PCollection<BatchGetDocumentsResponse>, BatchGetDocuments, Builder> {
            private Builder() {
            }

            public Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            @Override
            public BatchGetDocuments build() {
                return (BatchGetDocuments)((Object)this.genericBuild());
            }

            @Override
            BatchGetDocuments buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new BatchGetDocuments(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }
        }
    }

    public static final class RunQuery
    extends Transform<PCollection<RunQueryRequest>, PCollection<RunQueryResponse>, RunQuery, Builder> {
        private RunQuery(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        public PCollection<RunQueryResponse> expand(PCollection<RunQueryRequest> input) {
            return (PCollection)((PCollection)input.apply("runQuery", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.RunQueryFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions)))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<RunQueryRequest>, PCollection<RunQueryResponse>, RunQuery, Builder> {
            private Builder() {
            }

            private Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            @Override
            public RunQuery build() {
                return (RunQuery)((Object)this.genericBuild());
            }

            @Override
            RunQuery buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new RunQuery(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }
        }
    }

    public static final class ListDocuments
    extends Transform<PCollection<ListDocumentsRequest>, PCollection<Document>, ListDocuments, Builder> {
        private ListDocuments(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        public PCollection<Document> expand(PCollection<ListDocumentsRequest> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("listDocuments", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.ListDocumentsFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions)))).apply((PTransform)ParDo.of((DoFn)new ListDocumentsResponseToDocument()))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<ListDocumentsRequest>, PCollection<Document>, ListDocuments, Builder> {
            private Builder() {
            }

            private Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            @Override
            public ListDocuments build() {
                return (ListDocuments)((Object)this.genericBuild());
            }

            @Override
            ListDocuments buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new ListDocuments(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }
        }
    }

    public static final class ListCollectionIds
    extends Transform<PCollection<ListCollectionIdsRequest>, PCollection<String>, ListCollectionIds, Builder> {
        private ListCollectionIds(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
            super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
        }

        public PCollection<String> expand(PCollection<ListCollectionIdsRequest> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("listCollectionIds", (PTransform)ParDo.of((DoFn)new FirestoreV1ReadFn.ListCollectionIdsFn(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions)))).apply((PTransform)ParDo.of((DoFn)new FlattenListCollectionIdsResponse()))).apply((PTransform)Reshuffle.viaRandomKey());
        }

        @Override
        public Builder toBuilder() {
            return new Builder(this.clock, this.firestoreStatefulComponentFactory, this.rpcQosOptions);
        }

        public static final class Builder
        extends Transform.Builder<PCollection<ListCollectionIdsRequest>, PCollection<String>, ListCollectionIds, Builder> {
            private Builder() {
            }

            private Builder(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                super(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }

            @Override
            public ListCollectionIds build() {
                return (ListCollectionIds)((Object)this.genericBuild());
            }

            @Override
            ListCollectionIds buildSafe(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
                return new ListCollectionIds(clock, firestoreStatefulComponentFactory, rpcQosOptions);
            }
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @Immutable
    public static final class Write {
        private static final Write INSTANCE = new Write();

        private Write() {
        }

        public BatchWriteWithSummary.Builder batchWrite() {
            return new BatchWriteWithSummary.Builder();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    @Immutable
    public static final class Read {
        private static final Read INSTANCE = new Read();

        private Read() {
        }

        public ListDocuments.Builder listDocuments() {
            return new ListDocuments.Builder();
        }

        public ListCollectionIds.Builder listCollectionIds() {
            return new ListCollectionIds.Builder();
        }

        public BatchGetDocuments.Builder batchGetDocuments() {
            return new BatchGetDocuments.Builder();
        }

        public RunQuery.Builder runQuery() {
            return new RunQuery.Builder();
        }

        public PartitionQuery.Builder partitionQuery() {
            return new PartitionQuery.Builder();
        }
    }
}

