/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BQSchemaAndRecordToHopFn
implements SerializableFunction<SchemaAndRecord, HopRow> {
    private String transformName;
    private String rowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private transient Counter initCounter;
    private transient Counter inputCounter;
    private transient Counter writtenCounter;
    private transient Counter errorCounter;
    private static final Logger LOG = LoggerFactory.getLogger(BQSchemaAndRecordToHopFn.class);
    private transient IRowMeta rowMeta;
    private transient SimpleDateFormat simpleDateTimeFormat;
    private transient SimpleDateFormat simpleDateFormat;

    public BQSchemaAndRecordToHopFn(String transformName, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public HopRow apply(SchemaAndRecord schemaAndRecord) {
        try {
            GenericRecord record = schemaAndRecord.getRecord();
            TableSchema tableSchema = schemaAndRecord.getTableSchema();
            if (this.rowMeta == null) {
                int i;
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                this.errorCounter = Metrics.counter((String)"error", (String)this.transformName);
                BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
                this.rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
                int[] valueTypes = new int[this.rowMeta.size()];
                List fields = tableSchema.getFields();
                for (i = 0; i < fields.size(); ++i) {
                    TableFieldSchema fieldSchema = (TableFieldSchema)fields.get(i);
                    String name = fieldSchema.getName();
                    int index = this.rowMeta.indexOfValue(name);
                    if (index < 0) continue;
                    String avroTypeString = fieldSchema.getType();
                    try {
                        AvroType avroType = AvroType.valueOf(avroTypeString);
                        valueTypes[index] = avroType.getHopType();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Unable to recognize data type '" + avroTypeString + "'", e);
                    }
                }
                for (i = 0; i < this.rowMeta.size(); ++i) {
                    if (valueTypes[i] != 0) continue;
                    IValueMeta valueMeta = this.rowMeta.getValueMeta(i);
                    throw new RuntimeException("Unable to find field '" + valueMeta.getName() + "'");
                }
                this.simpleDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                this.simpleDateTimeFormat.setLenient(true);
                this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.simpleDateFormat.setLenient(true);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            this.inputCounter.inc();
            Object[] row = RowDataUtil.allocateRowData((int)this.rowMeta.size());
            block13: for (int index = 0; index < this.rowMeta.size(); ++index) {
                IValueMeta valueMeta = this.rowMeta.getValueMeta(index);
                Object srcData = record.get(valueMeta.getName());
                if (srcData == null) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        row[index] = srcData.toString();
                        continue block13;
                    }
                    case 5: {
                        row[index] = (Long)srcData;
                        continue block13;
                    }
                    case 1: {
                        row[index] = (Double)srcData;
                        continue block13;
                    }
                    case 4: {
                        row[index] = (Boolean)srcData;
                        continue block13;
                    }
                    case 3: {
                        String datetimeString = ((Utf8)srcData).toString();
                        if (datetimeString.length() == 10) {
                            row[index] = this.simpleDateFormat.parse(datetimeString);
                            continue block13;
                        }
                        row[index] = this.simpleDateTimeFormat.parse(datetimeString);
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException("Conversion from Avro JSON to Hop is not yet supported for Hop data type '" + valueMeta.getTypeDesc() + "'");
                    }
                }
            }
            this.writtenCounter.inc();
            return new HopRow(row);
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error converting BQ Avro data into Hop rows : " + e.getMessage());
            throw new RuntimeException("Error converting BQ Avro data into Hop rows", e);
        }
    }

    public static enum AvroType {
        STRING(2),
        BYTES(2),
        INTEGER(5),
        INT64(5),
        FLOAT(1),
        FLOAT64(1),
        BOOLEAN(4),
        BOOL(4),
        TIMESTAMP(3),
        DATE(3),
        TIME(3),
        DATETIME(3);

        private int hopType;

        private AvroType(int hopType) {
            this.hopType = hopType;
        }

        public int getHopType() {
            return this.hopType;
        }
    }
}

