/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopToStringFn
extends DoFn<HopRow, String> {
    private String counterName;
    private String outputLocation;
    private String separator;
    private String enclosure;
    private String rowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private transient IRowMeta rowMeta;
    private transient Counter readCounter;
    private transient Counter outputCounter;
    private transient Counter errorCounter;
    private static final Logger LOG = LoggerFactory.getLogger(HopToStringFn.class);

    public HopToStringFn(String counterName, String outputLocation, String separator, String enclosure, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.counterName = counterName;
        this.outputLocation = outputLocation;
        this.separator = separator;
        this.enclosure = enclosure;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            Counter initCounter = Metrics.counter((String)"init", (String)this.counterName);
            this.readCounter = Metrics.counter((String)"read", (String)this.counterName);
            this.outputCounter = Metrics.counter((String)"output", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
            initCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Parse error on setup of Hop data to string lines : " + e.getMessage());
            throw new RuntimeException("Error on setup of converting Hop data to string lines", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            HopRow inputRow = (HopRow)processContext.element();
            this.readCounter.inc();
            StringBuffer line = new StringBuffer();
            for (int i = 0; i < this.rowMeta.size(); ++i) {
                if (i > 0) {
                    line.append(this.separator);
                }
                try {
                    String valueString = this.rowMeta.getString(inputRow.getRow(), i);
                    if (valueString == null) continue;
                    boolean enclose = false;
                    if (StringUtils.isNotEmpty((String)this.enclosure)) {
                        enclose = valueString.contains(this.enclosure);
                    }
                    if (enclose) {
                        line.append(this.enclosure);
                    }
                    line.append(valueString);
                    if (!enclose) continue;
                    line.append(this.enclosure);
                    continue;
                }
                catch (Exception e) {
                    throw new HopException("Error getting String from field " + this.rowMeta.getValueMeta(i) + " on index " + i + " in input: " + this.rowMeta.toString() + ", native value found: " + inputRow.getRow()[i], (Throwable)e);
                }
            }
            processContext.output((Object)line.toString());
            this.outputCounter.inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Parse error on " + processContext.element() + ", " + e.getMessage());
            throw new RuntimeException("Error converting Hop data to string lines", e);
        }
    }
}

