/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.response;

import cc.blynk.clickhouse.ClickHouseArray;
import cc.blynk.clickhouse.ClickHouseStatement;
import cc.blynk.clickhouse.domain.ClickHouseDataType;
import cc.blynk.clickhouse.except.ClickHouseExceptionSpecifier;
import cc.blynk.clickhouse.response.AbstractResultSet;
import cc.blynk.clickhouse.response.ByteFragment;
import cc.blynk.clickhouse.response.ByteFragmentUtils;
import cc.blynk.clickhouse.response.ClickHouseColumnInfo;
import cc.blynk.clickhouse.response.ClickHouseResultSetMetaData;
import cc.blynk.clickhouse.response.StreamSplitter;
import cc.blynk.clickhouse.settings.ClickHouseProperties;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

public class ClickHouseResultSet
extends AbstractResultSet {
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final TimeZone dateTimeTimeZone;
    private final TimeZone dateTimeZone;
    private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final StreamSplitter bis;
    private final String db;
    private final String table;
    private final ClickHouseColumnInfo[] columns;
    private int maxRows;
    protected ByteFragment[] values;
    private int lastReadColumn;
    protected ByteFragment nextLine;
    private ByteFragment totalLine;
    protected int rowNumber;
    private final ClickHouseStatement statement;
    private final ClickHouseProperties properties;
    private final boolean usesWithTotals;
    private boolean lastReached = false;

    public ClickHouseResultSet(InputStream is, int bufferSize, String db, String table, boolean usesWithTotals, ClickHouseStatement statement, TimeZone timeZone, ClickHouseProperties properties) throws IOException {
        this.db = db;
        this.table = table;
        this.statement = statement;
        this.properties = properties;
        this.usesWithTotals = usesWithTotals;
        this.dateTimeTimeZone = timeZone;
        this.dateTimeZone = properties.isUseServerTimeZoneForDates() ? timeZone : TimeZone.getDefault();
        this.dateTimeFormat.setTimeZone(this.dateTimeTimeZone);
        this.dateFormat.setTimeZone(this.dateTimeZone);
        this.bis = new StreamSplitter(is, 10, bufferSize);
        ByteFragment headerFragment = this.bis.next();
        if (headerFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column names");
        }
        String header = headerFragment.asString(true);
        if (header.startsWith("Code: ") && !header.contains("\t")) {
            is.close();
            throw new IOException("ClickHouse error: " + header);
        }
        String[] cols = ClickHouseResultSet.toStringArray(headerFragment);
        ByteFragment typesFragment = this.bis.next();
        if (typesFragment == null) {
            throw new IllegalArgumentException("ClickHouse response without column types");
        }
        String[] types = ClickHouseResultSet.toStringArray(typesFragment);
        this.columns = new ClickHouseColumnInfo[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            this.columns[i] = ClickHouseColumnInfo.parse(types[i], cols[i]);
        }
    }

    private static String[] toStringArray(ByteFragment headerFragment) {
        ByteFragment[] split = headerFragment.split((byte)9);
        String[] c = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            String name;
            c[i] = name = split[i].asString(true);
        }
        return c;
    }

    public boolean hasNext() throws SQLException {
        if (this.nextLine == null && !this.lastReached) {
            try {
                this.nextLine = this.bis.next();
                if (this.nextLine == null || this.maxRows != 0 && this.rowNumber >= this.maxRows || this.usesWithTotals && this.nextLine.length() == 0) {
                    if (this.usesWithTotals) {
                        if (this.onTheSeparatorRow()) {
                            this.totalLine = this.bis.next();
                            this.endOfStream();
                        }
                    } else {
                        this.endOfStream();
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return this.nextLine != null;
    }

    private void endOfStream() throws IOException {
        this.bis.close();
        this.lastReached = true;
        this.nextLine = null;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasNext()) {
            this.values = this.nextLine.split((byte)9);
            this.checkValues(this.columns, this.values, this.nextLine);
            this.nextLine = null;
            ++this.rowNumber;
            return true;
        }
        return false;
    }

    private void checkValues(ClickHouseColumnInfo[] columns, ByteFragment[] values, ByteFragment fragment) throws SQLException {
        if (columns.length != values.length) {
            throw ClickHouseExceptionSpecifier.specify(fragment.asString());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.bis.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.bis.isClosed();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void getTotals() throws SQLException {
        if (!this.usesWithTotals) {
            throw new IllegalStateException("Cannot get totals when totals are not being used.");
        }
        this.nextLine = this.totalLine;
        this.next();
    }

    List<ClickHouseColumnInfo> getColumns() {
        return Arrays.asList(this.columns);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ClickHouseResultSetMetaData(this);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastReadColumn == 0) {
            throw new IllegalStateException("You should get something before check nullability");
        }
        return this.getValue(this.lastReadColumn).isNull();
    }

    @Override
    public int getInt(String column) {
        return this.getInt(this.asColNum(column));
    }

    @Override
    public boolean getBoolean(String column) {
        return this.getBoolean(this.asColNum(column));
    }

    @Override
    public long getLong(String column) {
        return this.getLong(this.asColNum(column));
    }

    @Override
    public String getString(String column) {
        return this.getString(this.asColNum(column));
    }

    @Override
    public byte[] getBytes(String column) {
        return this.getBytes(this.asColNum(column));
    }

    private long getTimestampAsLong(String column) {
        return this.getTimestampAsLong(this.asColNum(column));
    }

    @Override
    public Timestamp getTimestamp(String column) throws SQLException {
        long value = this.getTimestampAsLong(column);
        return value == -1L ? null : new Timestamp(value);
    }

    @Override
    public Timestamp getTimestamp(String column, Calendar cal) throws SQLException {
        long value = this.getTimestampAsLong(this.asColNum(column), cal.getTimeZone());
        return value == -1L ? null : new Timestamp(value);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        long value = this.getTimestampAsLong(columnIndex, cal.getTimeZone());
        return value == -1L ? null : new Timestamp(value);
    }

    @Override
    public short getShort(String column) {
        return this.getShort(this.asColNum(column));
    }

    @Override
    public byte getByte(String column) {
        return this.getByte(this.asColNum(column));
    }

    @Override
    public long[] getLongArray(String column) {
        return this.getLongArray(this.asColNum(column));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        Object array;
        ClickHouseColumnInfo colInfo = this.columns[columnIndex - 1];
        if (colInfo.getClickHouseDataType() != ClickHouseDataType.Array) {
            throw new SQLException("Column not an array");
        }
        switch (colInfo.getArrayBaseType()) {
            case Date: {
                array = ByteFragmentUtils.parseArray(this.getValue(columnIndex), colInfo.getArrayBaseType().getJavaClass(), this.properties.isUseObjectsInArrays(), this.dateFormat);
                break;
            }
            case DateTime: {
                TimeZone timeZone = colInfo.getTimeZone() != null ? colInfo.getTimeZone() : this.dateTimeTimeZone;
                this.dateTimeFormat.setTimeZone(timeZone);
                array = ByteFragmentUtils.parseArray(this.getValue(columnIndex), colInfo.getArrayBaseType().getJavaClass(), this.properties.isUseObjectsInArrays(), this.dateTimeFormat);
                break;
            }
            default: {
                array = ByteFragmentUtils.parseArray(this.getValue(columnIndex), colInfo.getArrayBaseType().getJavaClass(), this.properties.isUseObjectsInArrays());
            }
        }
        return new ClickHouseArray(colInfo.getArrayBaseType(), array);
    }

    @Override
    public Array getArray(String column) throws SQLException {
        return this.getArray(this.asColNum(column));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.asColNum(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.asColNum(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.asColNum(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.asColNum(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.asColNum(columnLabel));
    }

    @Override
    public String getString(int colNum) {
        return ClickHouseResultSet.toString(this.getValue(colNum));
    }

    @Override
    public int getInt(int colNum) {
        return ByteFragmentUtils.parseInt(this.getValue(colNum));
    }

    @Override
    public boolean getBoolean(int colNum) {
        return ClickHouseResultSet.toBoolean(this.getValue(colNum));
    }

    @Override
    public long getLong(int colNum) {
        return ByteFragmentUtils.parseLong(this.getValue(colNum));
    }

    @Override
    public byte[] getBytes(int colNum) {
        return ClickHouseResultSet.toBytes(this.getValue(colNum));
    }

    private long getTimestampAsLong(int colNum) {
        ClickHouseColumnInfo info = this.columns[colNum - 1];
        TimeZone timeZone = info.getTimeZone() != null ? info.getTimeZone() : this.dateTimeTimeZone;
        return this.toTimestamp(this.getValue(colNum), timeZone);
    }

    private long getTimestampAsLong(int colNum, TimeZone tz) {
        return this.toTimestamp(this.getValue(colNum), tz);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        long value = this.getTimestampAsLong(columnIndex);
        return value == -1L ? null : new Timestamp(value);
    }

    @Override
    public short getShort(int colNum) {
        return ClickHouseResultSet.toShort(this.getValue(colNum));
    }

    @Override
    public byte getByte(int colNum) {
        return ClickHouseResultSet.toByte(this.getValue(colNum));
    }

    public long[] getLongArray(int colNum) {
        return ClickHouseResultSet.toLongArray(this.getValue(colNum));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return (float)this.getDouble(columnIndex);
    }

    private boolean onTheSeparatorRow() throws IOException {
        this.bis.mark();
        boolean onSeparatorRow = this.bis.next() != null && this.bis.next() == null;
        this.bis.reset();
        return onSeparatorRow;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        ByteFragment value = this.getValue(columnIndex);
        if (value.isNull() || value.asString().equals("0000-00-00")) {
            return null;
        }
        try {
            return new Date(this.dateFormat.parse(value.asString()).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getDate(columnIndex);
        }
        ByteFragment value = this.getValue(columnIndex);
        if (value.isNull() || value.asString().equals("0000-00-00")) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
            simpleDateFormat.setTimeZone(cal.getTimeZone());
            return new Date(simpleDateFormat.parse(value.asString()).getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.asColNum(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String string = this.getString(columnIndex);
        if (string == null) {
            return 0.0;
        }
        if (string.equals("nan")) {
            return Double.NaN;
        }
        if (string.equals("+inf") || string.equals("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Timestamp ts = this.getTimestamp(columnIndex);
        if (ts == null) {
            return null;
        }
        return new Time(ts.getTime());
    }

    private static byte toByte(ByteFragment value) {
        if (value.isNull()) {
            return 0;
        }
        return Byte.parseByte(value.asString());
    }

    private static short toShort(ByteFragment value) {
        if (value.isNull()) {
            return 0;
        }
        return Short.parseShort(value.asString());
    }

    private static boolean toBoolean(ByteFragment value) {
        if (value.isNull()) {
            return false;
        }
        return "1".equals(value.asString());
    }

    private static byte[] toBytes(ByteFragment value) {
        if (value.isNull()) {
            return null;
        }
        return value.unescape();
    }

    private static String toString(ByteFragment value) {
        return value.asString(true);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            if (this.getValue(columnIndex).isNull()) {
                return null;
            }
            ClickHouseDataType chType = this.columns[columnIndex - 1].getClickHouseDataType();
            int type = chType.getSqlType();
            switch (type) {
                case -5: {
                    if (!chType.isSigned()) {
                        String stringVal = this.getString(columnIndex);
                        return new BigInteger(stringVal);
                    }
                    return this.getLong(columnIndex);
                }
                case 4: {
                    if (!chType.isSigned()) {
                        return this.getLong(columnIndex);
                    }
                    return this.getInt(columnIndex);
                }
                case -6: 
                case 5: {
                    return this.getInt(columnIndex);
                }
                case 12: {
                    return this.getString(columnIndex);
                }
                case 6: {
                    return Float.valueOf(this.getFloat(columnIndex));
                }
                case 8: {
                    return this.getDouble(columnIndex);
                }
                case 91: {
                    return this.getDate(columnIndex);
                }
                case 93: {
                    return this.getTimestamp(columnIndex);
                }
                case 2004: {
                    return this.getString(columnIndex);
                }
                case 2003: {
                    return this.getArray(columnIndex);
                }
                case 3: {
                    return this.getBigDecimal(columnIndex);
                }
            }
            if (chType == ClickHouseDataType.UUID) {
                return this.getObject(columnIndex, UUID.class);
            }
            return this.getString(columnIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Parse exception: " + this.values[columnIndex - 1].toString(), e);
        }
    }

    static long[] toLongArray(ByteFragment value) {
        if (value.isNull()) {
            return null;
        }
        if (value.charAt(0) != 91 || value.charAt(value.length() - 1) != 93) {
            throw new IllegalArgumentException("not an array: " + value);
        }
        if (value.length() == 2) {
            return EMPTY_LONG_ARRAY;
        }
        ByteFragment trim = value.subseq(1, value.length() - 2);
        ByteFragment[] values = trim.split((byte)44);
        long[] result = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = ByteFragmentUtils.parseLong(values[i]);
        }
        return result;
    }

    private long toTimestamp(ByteFragment value, TimeZone timeZone) {
        if (value.isNull() || value.asString().equals("0000-00-00 00:00:00")) {
            return -1L;
        }
        try {
            this.dateTimeFormat.setTimeZone(timeZone);
            return this.dateTimeFormat.parse(value.asString()).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowNumber;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private int asColNum(String column) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!column.equals(this.columns[i].getColumnName())) continue;
            return i + 1;
        }
        throw new RuntimeException("no column " + column + " in columns list " + this.getColumnNames());
    }

    private ByteFragment getValue(int colNum) {
        this.lastReadColumn = colNum;
        return this.values[colNum - 1];
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type.equals(UUID.class)) {
            return (T)UUID.fromString(this.getString(columnIndex));
        }
        throw new SQLException("Not implemented for type=" + type.toString());
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.asColNum(columnLabel), type);
    }

    public ByteFragment[] getValues() {
        return this.values;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) {
        return this.getBigDecimal(this.asColNum(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        return new BigDecimal(string);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) {
        return this.getBigDecimal(this.asColNum(columnLabel), scale);
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this.hasNext();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        String string = this.getString(columnIndex);
        if (string == null) {
            return null;
        }
        BigDecimal result = new BigDecimal(string);
        return result.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    public String toString() {
        return "ClickHouseResultSet{sdf=" + this.dateTimeFormat + ", dateFormat=" + this.dateFormat + ", bis=" + this.bis + ", db='" + this.db + '\'' + ", table='" + this.table + '\'' + ", columns=" + this.getColumnNames() + ", maxRows=" + this.maxRows + ", values=" + Arrays.toString(this.values) + ", lastReadColumn=" + this.lastReadColumn + ", nextLine=" + this.nextLine + ", rowNumber=" + this.rowNumber + ", statement=" + this.statement + '}';
    }

    private String getColumnNames() {
        StringBuilder sb = new StringBuilder();
        for (ClickHouseColumnInfo info : this.columns) {
            sb.append(info.getColumnName()).append(' ');
        }
        return sb.substring(0, sb.length() - 1);
    }
}

