/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourcePool;

class PagedListBuffer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean clear_;
    private int numberOfPages_;
    private Resource[][] pages_;
    private long[] pageIndices_;
    private int pageSize_;
    private long[] pageTimestamps_;
    private ResourcePool pool_ = ResourcePool.GLOBAL_RESOURCE_POOL;

    public PagedListBuffer(int n, int n2) {
        this.numberOfPages_ = n;
        this.pageSize_ = n2;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PagedListBuffer pagedListBuffer = this;
        synchronized (pagedListBuffer) {
            if (this.pool_ != null) {
                for (int i = 0; i < this.numberOfPages_; ++i) {
                    for (int j = 0; j < this.pageSize_; ++j) {
                        if (this.pages_ == null || this.pages_[i] == null || this.pages_[i][j] == null) continue;
                        this.pool_.deregister(this.pages_[i][j]);
                    }
                }
            }
            this.initialize();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Paged list buffer " + this + " cleared.");
            }
        }
    }

    private int findPage(long l) {
        for (int i = 0; i < this.numberOfPages_; ++i) {
            if (this.pageIndices_[i] == -1L || this.pageIndices_[i] > l || l >= this.pageIndices_[i] + (long)this.pageSize_) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(long l) {
        PagedListBuffer pagedListBuffer = this;
        synchronized (pagedListBuffer) {
            int n = this.findPage(l);
            if (n != -1) {
                return this.pages_[n][(int)(l - this.pageIndices_[n])];
            }
            return null;
        }
    }

    private void initialize() {
        this.clear_ = true;
        this.pages_ = new Resource[this.numberOfPages_][];
        this.pageIndices_ = new long[this.numberOfPages_];
        this.pageTimestamps_ = new long[this.numberOfPages_];
        for (int i = 0; i < this.numberOfPages_; ++i) {
            this.pages_[i] = null;
            this.pageIndices_[i] = -1L;
            this.pageTimestamps_[i] = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResource(long l, Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        PagedListBuffer pagedListBuffer = this;
        synchronized (pagedListBuffer) {
            this.clear_ = false;
            int n = this.findPage(l);
            if (n >= 0) {
                this.pages_[n][(int)(l - this.pageIndices_[n])] = resource;
                this.pageTimestamps_[n] = System.currentTimeMillis();
                if (this.pool_ != null) {
                    this.pool_.register(resource);
                }
                return;
            }
            for (int i = 0; i < this.numberOfPages_; ++i) {
                if (this.pages_[i] != null) continue;
                n = i;
                break;
            }
            if (n < 0) {
                int n2;
                long l2 = System.currentTimeMillis();
                for (n2 = 0; n2 < this.numberOfPages_; ++n2) {
                    if (this.pageTimestamps_[n2] > l2) continue;
                    n = n2;
                    l2 = this.pageTimestamps_[n2];
                }
                if (this.pool_ != null) {
                    for (n2 = 0; n2 < this.pageSize_; ++n2) {
                        if (this.pages_[n][n2] == null) continue;
                        this.pool_.deregister(this.pages_[n][n2]);
                    }
                }
                for (n2 = 0; n2 < this.pageSize_; ++n2) {
                    this.pages_[n][n2] = null;
                }
                this.pages_[n] = null;
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Paged list buffer " + this + " swapped out page " + n + ".");
                }
            }
            this.pages_[n] = new Resource[this.pageSize_];
            this.pages_[n][0] = resource;
            this.pageIndices_[n] = l;
            this.pageTimestamps_[n] = System.currentTimeMillis();
            if (this.pool_ != null) {
                this.pool_.register(resource);
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Paged list buffer " + this + " created page " + n + ".");
            }
        }
    }
}

