/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.LateDataUtils;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.TimerInternalsFactory;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.core.construction.graph.UserStateReference;
import org.apache.beam.runners.flink.translation.functions.FlinkExecutableStageContextFactory;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.utils.FlinkPortableRunnerUtils;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.runners.flink.translation.wrappers.streaming.state.FlinkStateInternals;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandler;
import org.apache.beam.runners.fnexecution.control.BundleCheckpointHandlers;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandler;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandlers;
import org.apache.beam.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.control.OutputReceiverFactory;
import org.apache.beam.runners.fnexecution.control.ProcessBundleDescriptors;
import org.apache.beam.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.runners.fnexecution.control.TimerReceiverFactory;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.runners.fnexecution.translation.StreamingSideInputHandlerFactory;
import org.apache.beam.runners.fnexecution.wire.ByteStringCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class ExecutableStageDoFnOperator<InputT, OutputT>
extends DoFnOperator<InputT, OutputT> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutableStageDoFnOperator.class);
    private final RunnerApi.ExecutableStagePayload payload;
    private final JobInfo jobInfo;
    private final FlinkExecutableStageContextFactory contextFactory;
    private final Map<String, TupleTag<?>> outputMap;
    private final Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInputIds;
    private final ReentrantLock stateBackendLock;
    private final SerializablePipelineOptions pipelineOptions;
    private final boolean isStateful;
    private final Coder windowCoder;
    private final Coder<WindowedValue<InputT>> inputCoder;
    private transient ExecutableStageContext stageContext;
    private transient StateRequestHandler stateRequestHandler;
    private transient BundleProgressHandler progressHandler;
    private transient BundleFinalizationHandlers.InMemoryFinalizer finalizationHandler;
    private transient BundleCheckpointHandler checkpointHandler;
    private transient boolean hasSdfProcessFn;
    private transient StageBundleFactory stageBundleFactory;
    private transient ExecutableStage executableStage;
    private transient SdkHarnessDoFnRunner<InputT, OutputT> sdkHarnessRunner;
    private transient long minEventTimeTimerTimestampInLastBundle;
    private transient long minEventTimeTimerTimestampInCurrentBundle;
    private transient long inputWatermarkBeforeBundleStart;
    private transient boolean closed;

    public ExecutableStageDoFnOperator(String stepName, Coder<WindowedValue<InputT>> windowedInputCoder, Map<TupleTag<?>, Coder<?>> outputCoders, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, DoFnOperator.OutputManagerFactory<OutputT> outputManagerFactory, Map<Integer, PCollectionView<?>> sideInputTagMapping, Collection<PCollectionView<?>> sideInputs, Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>> sideInputIds, PipelineOptions options, RunnerApi.ExecutableStagePayload payload, JobInfo jobInfo, FlinkExecutableStageContextFactory contextFactory, Map<String, TupleTag<?>> outputMap, WindowingStrategy windowingStrategy, Coder keyCoder, KeySelector<WindowedValue<InputT>, ?> keySelector) {
        super(new NoOpDoFn(), stepName, windowedInputCoder, outputCoders, mainOutputTag, additionalOutputTags, outputManagerFactory, windowingStrategy, sideInputTagMapping, sideInputs, options, keyCoder, keySelector, DoFnSchemaInformation.create(), Collections.emptyMap());
        this.isStateful = payload.getUserStatesCount() > 0 || payload.getTimersCount() > 0;
        this.payload = payload;
        this.jobInfo = jobInfo;
        this.contextFactory = contextFactory;
        this.outputMap = outputMap;
        this.sideInputIds = sideInputIds;
        this.stateBackendLock = new ReentrantLock();
        this.windowCoder = windowingStrategy.getWindowFn().windowCoder();
        this.inputCoder = windowedInputCoder;
        this.pipelineOptions = new SerializablePipelineOptions(options);
        Preconditions.checkArgument((!windowedInputCoder.getCoderArguments().isEmpty() ? 1 : 0) != 0, (String)"Empty arguments for WindowedValue Coder %s", windowedInputCoder);
    }

    @Override
    protected Lock getLockToAcquireForStateAccessDuringBundles() {
        return this.stateBackendLock;
    }

    @Override
    public void open() throws Exception {
        this.executableStage = ExecutableStage.fromPayload((RunnerApi.ExecutableStagePayload)this.payload);
        this.hasSdfProcessFn = this.hasSDF(this.executableStage);
        ExecutableStageDoFnOperator.initializeUserState(this.executableStage, this.getKeyedStateBackend(), this.pipelineOptions);
        this.stageContext = this.contextFactory.get(this.jobInfo);
        this.stageBundleFactory = this.stageContext.getStageBundleFactory(this.executableStage);
        this.stateRequestHandler = this.getStateRequestHandler(this.executableStage);
        this.progressHandler = new BundleProgressHandler(){

            public void onProgress(BeamFnApi.ProcessBundleProgressResponse progress) {
                if (ExecutableStageDoFnOperator.this.flinkMetricContainer != null) {
                    ExecutableStageDoFnOperator.this.flinkMetricContainer.updateMetrics(ExecutableStageDoFnOperator.this.stepName, progress.getMonitoringInfosList());
                }
            }

            public void onCompleted(BeamFnApi.ProcessBundleResponse response) {
                if (ExecutableStageDoFnOperator.this.flinkMetricContainer != null) {
                    ExecutableStageDoFnOperator.this.flinkMetricContainer.updateMetrics(ExecutableStageDoFnOperator.this.stepName, response.getMonitoringInfosList());
                }
            }
        };
        this.finalizationHandler = BundleFinalizationHandlers.inMemoryFinalizer((InstructionRequestHandler)this.stageBundleFactory.getInstructionRequestHandler());
        this.checkpointHandler = this.getBundleCheckpointHandler(this.hasSdfProcessFn);
        this.minEventTimeTimerTimestampInCurrentBundle = Long.MAX_VALUE;
        this.minEventTimeTimerTimestampInLastBundle = Long.MAX_VALUE;
        super.setPreBundleCallback(this::preBundleStartCallback);
        super.setBundleFinishedCallback(this::finishBundleCallback);
        super.open();
    }

    @Override
    public final void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.finalizationHandler.finalizeAllOutstandingBundles();
        super.notifyCheckpointComplete(checkpointId);
    }

    private BundleCheckpointHandler getBundleCheckpointHandler(boolean hasSDF) {
        if (!hasSDF) {
            return response -> {
                throw new UnsupportedOperationException("Self-checkpoint is only supported on splittable DoFn.");
            };
        }
        return new BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler((TimerInternalsFactory)new SdfFlinkTimerInternalsFactory(), (StateInternalsFactory)new SdfFlinkStateInternalsFactory(), this.inputCoder, this.windowCoder);
    }

    private boolean hasSDF(ExecutableStage executableStage) {
        return executableStage.getTransforms().stream().anyMatch(pTransformNode -> pTransformNode.getTransform().getSpec().getUrn().equals("beam:transform:sdf_process_sized_element_and_restrictions:v1"));
    }

    private StateRequestHandler getStateRequestHandler(ExecutableStage executableStage) {
        StateRequestHandler userStateRequestHandler;
        StateRequestHandler sideInputStateHandler;
        if (executableStage.getSideInputs().size() > 0) {
            org.apache.flink.util.Preconditions.checkNotNull((Object)this.sideInputHandler);
            StateRequestHandlers.SideInputHandlerFactory sideInputHandlerFactory = (StateRequestHandlers.SideInputHandlerFactory)Preconditions.checkNotNull((Object)StreamingSideInputHandlerFactory.forStage((ExecutableStage)executableStage, this.sideInputIds, (SideInputHandler)this.sideInputHandler));
            try {
                sideInputStateHandler = StateRequestHandlers.forSideInputHandlerFactory((Map)ProcessBundleDescriptors.getSideInputs((ExecutableStage)executableStage), (StateRequestHandlers.SideInputHandlerFactory)sideInputHandlerFactory);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize SideInputHandler", e);
            }
        } else {
            sideInputStateHandler = StateRequestHandler.unsupported();
        }
        if (!executableStage.getUserStates().isEmpty()) {
            if (this.keyedStateInternals == null) {
                throw new IllegalStateException("Input must be keyed when user state is used");
            }
            userStateRequestHandler = StateRequestHandlers.forBagUserStateHandlerFactory((ProcessBundleDescriptors.ExecutableProcessBundleDescriptor)this.stageBundleFactory.getProcessBundleDescriptor(), new BagUserStateFactory(this.keyedStateInternals, (KeyedStateBackend<ByteBuffer>)this.getKeyedStateBackend(), this.stateBackendLock, this.keyCoder));
        } else {
            userStateRequestHandler = StateRequestHandler.unsupported();
        }
        EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler> handlerMap = new EnumMap<BeamFnApi.StateKey.TypeCase, StateRequestHandler>(BeamFnApi.StateKey.TypeCase.class);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.ITERABLE_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.MULTIMAP_KEYS_SIDE_INPUT, sideInputStateHandler);
        handlerMap.put(BeamFnApi.StateKey.TypeCase.BAG_USER_STATE, userStateRequestHandler);
        return StateRequestHandlers.delegateBasedUponType(handlerMap);
    }

    public void setKeyContextElement1(StreamRecord record) {
    }

    public void setCurrentKey(Object key) {
    }

    public ByteBuffer getCurrentKey() {
        Preconditions.checkState((boolean)this.stateBackendLock.isLocked(), (Object)"State backend must be locked when retrieving the current key.");
        return (ByteBuffer)this.getKeyedStateBackend().getCurrentKey();
    }

    void setTimer(Timer<?> timerElement, TimerInternals.TimerData timerData) {
        try {
            Preconditions.checkState((boolean)this.sdkHarnessRunner.isBundleInProgress(), (Object)"Bundle was expected to be in progress!!");
            LOG.debug("Setting timer: {} {}", timerElement, (Object)timerData);
            ByteBuffer encodedKey = (ByteBuffer)this.keySelector.getKey((Object)WindowedValue.valueInGlobalWindow((Object)KV.of((Object)timerElement.getUserKey(), null)));
            try (Locker locker = Locker.locked(this.stateBackendLock);){
                this.getKeyedStateBackend().setCurrentKey((Object)encodedKey);
                if (timerElement.getClearBit()) {
                    this.timerInternals.deleteTimer(timerData);
                } else {
                    this.timerInternals.setTimer(timerData);
                    if (!timerData.getTimerId().equals("__StatefulParDoGcTimerId")) {
                        this.minEventTimeTimerTimestampInCurrentBundle = Math.min(this.minEventTimeTimerTimestampInCurrentBundle, ExecutableStageDoFnOperator.adjustTimestampForFlink(timerData.getTimestamp().getMillis()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't set timer", e);
        }
    }

    @Override
    protected void fireTimerInternal(ByteBuffer key, TimerInternals.TimerData timer) {
        try (Locker locker = Locker.locked(this.stateBackendLock);){
            this.getKeyedStateBackend().setCurrentKey((Object)key);
            this.fireTimer(timer);
        }
    }

    @Override
    public void flushData() throws Exception {
        this.closed = true;
        this.processWatermark1(Watermark.MAX_WATERMARK);
        while (this.getCurrentOutputWatermark() < Watermark.MAX_WATERMARK.getTimestamp()) {
            this.invokeFinishBundle();
            if (!this.hasSdfProcessFn || this.numProcessingTimeTimers() <= 0) continue;
            this.timerInternals.processPendingProcessingTimeTimers();
        }
        super.flushData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() throws Exception {
        if (this.stageContext != null) {
            try (StageBundleFactory bundleFactoryCloser = this.stageBundleFactory;
                 ExecutableStageContext closable = this.stageContext;){
                super.cleanUp();
            }
            finally {
                this.stageContext = null;
            }
        }
    }

    @Override
    protected void addSideInputValue(StreamRecord<RawUnionValue> streamRecord) {
        WindowedValue value = (WindowedValue)((RawUnionValue)streamRecord.getValue()).getValue();
        PCollectionView sideInput = (PCollectionView)this.sideInputTagMapping.get(((RawUnionValue)streamRecord.getValue()).getUnionTag());
        this.sideInputHandler.addSideInputValue(sideInput, value.withValue((Object)((Iterable)((KV)value.getValue()).getValue())));
    }

    @Override
    protected DoFnRunner<InputT, OutputT> createWrappingDoFnRunner(DoFnRunner<InputT, OutputT> wrappedRunner, StepContext stepContext) {
        this.sdkHarnessRunner = new SdkHarnessDoFnRunner(wrappedRunner.getFn(), this.stageBundleFactory, this.stateRequestHandler, this.progressHandler, (BundleFinalizationHandler)this.finalizationHandler, this.checkpointHandler, this.outputManager, this.outputMap, (Coder<BoundedWindow>)this.windowCoder, this.inputCoder, this::setTimer, () -> FlinkKeyUtils.decodeKey(this.getCurrentKey(), this.keyCoder), this.keyedStateInternals);
        return this.ensureStateDoFnRunner(this.sdkHarnessRunner, this.payload, stepContext);
    }

    @Override
    public long applyInputWatermarkHold(long inputWatermark) {
        if (this.sdkHarnessRunner.isBundleInProgress()) {
            return this.inputWatermarkBeforeBundleStart;
        }
        return inputWatermark;
    }

    @Override
    public long applyOutputWatermarkHold(long currentOutputWatermark, long potentialOutputWatermark) {
        if (this.sdkHarnessRunner.isBundleInProgress()) {
            if (this.minEventTimeTimerTimestampInLastBundle < Long.MAX_VALUE) {
                return Math.min(this.minEventTimeTimerTimestampInLastBundle - 1L, potentialOutputWatermark);
            }
            return currentOutputWatermark;
        }
        return potentialOutputWatermark;
    }

    private void preBundleStartCallback() {
        this.inputWatermarkBeforeBundleStart = this.getEffectiveInputWatermark();
    }

    private void finishBundleCallback() {
        this.minEventTimeTimerTimestampInLastBundle = this.minEventTimeTimerTimestampInCurrentBundle;
        this.minEventTimeTimerTimestampInCurrentBundle = Long.MAX_VALUE;
        try {
            if (!this.closed && this.minEventTimeTimerTimestampInLastBundle < Long.MAX_VALUE && this.minEventTimeTimerTimestampInLastBundle <= this.getEffectiveInputWatermark()) {
                ProcessingTimeService processingTimeService = this.getProcessingTimeService();
                processingTimeService.registerTimer(processingTimeService.getCurrentProcessingTime(), ts -> this.processWatermark1(new Watermark(this.getEffectiveInputWatermark())));
            } else {
                this.processWatermark1(new Watermark(this.getEffectiveInputWatermark()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to progress watermark to " + this.getEffectiveInputWatermark(), e);
        }
    }

    private DoFnRunner<InputT, OutputT> ensureStateDoFnRunner(SdkHarnessDoFnRunner<InputT, OutputT> sdkHarnessRunner, RunnerApi.ExecutableStagePayload payload, StepContext stepContext) {
        if (!this.isStateful) {
            return sdkHarnessRunner;
        }
        Coder windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
        CleanupTimer cleanupTimer = new CleanupTimer(this.timerInternals, this.stateBackendLock, this.windowingStrategy, this.keyCoder, windowCoder, (KeyedStateBackend<ByteBuffer>)this.getKeyedStateBackend());
        List<String> userStates = this.executableStage.getUserStates().stream().map(UserStateReference::localName).collect(Collectors.toList());
        final KeyedStateBackend stateBackend = this.getKeyedStateBackend();
        final StateCleaner stateCleaner = new StateCleaner(userStates, windowCoder, () -> ((KeyedStateBackend)stateBackend).getCurrentKey(), (ThrowingFunction<Long, Boolean>)((ThrowingFunction)this.timerInternals::hasPendingEventTimeTimers), cleanupTimer);
        return new StatefulDoFnRunner<InputT, OutputT, BoundedWindow>(sdkHarnessRunner, this.getInputCoder(), stepContext, this.windowingStrategy, cleanupTimer, stateCleaner, FlinkPortableRunnerUtils.requiresTimeSortedInput(payload, true)){

            public void processElement(WindowedValue<InputT> input) {
                try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                    ByteBuffer key = FlinkKeyUtils.encodeKey(((KV)input.getValue()).getKey(), ExecutableStageDoFnOperator.this.keyCoder);
                    ExecutableStageDoFnOperator.this.getKeyedStateBackend().setCurrentKey((Object)key);
                    super.processElement(input);
                }
            }

            public void finishBundle() {
                super.finishBundle();
                if (!stateCleaner.cleanupQueue.isEmpty()) {
                    try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                        stateCleaner.cleanupState(ExecutableStageDoFnOperator.this.keyedStateInternals, arg_0 -> ((KeyedStateBackend)stateBackend).setCurrentKey(arg_0));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to cleanup state.", e);
                    }
                }
            }
        };
    }

    private static void initializeUserState(ExecutableStage executableStage, @Nullable KeyedStateBackend keyedStateBackend, SerializablePipelineOptions pipelineOptions) {
        executableStage.getUserStates().forEach(ref -> {
            try {
                keyedStateBackend.getOrCreateKeyedState((TypeSerializer)StringSerializer.INSTANCE, (StateDescriptor)new ListStateDescriptor(ref.localName(), new CoderTypeSerializer(ByteStringCoder.of(), pipelineOptions)));
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't initialize user states.", e);
            }
        });
    }

    private static class Locker
    implements AutoCloseable {
        private final Lock lock;

        public static Locker locked(Lock lock) {
            Locker locker = new Locker(lock);
            lock.lock();
            return locker;
        }

        Locker(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    private static class NoOpDoFn<InputT, OutputT>
    extends DoFn<InputT, OutputT> {
        private NoOpDoFn() {
        }

        @DoFn.ProcessElement
        public void doNothing(DoFn.ProcessContext context) {
        }
    }

    static class StateCleaner
    implements StatefulDoFnRunner.StateCleaner<BoundedWindow> {
        private final List<String> userStateNames;
        private final Coder windowCoder;
        private final ArrayDeque<KV<ByteBuffer, BoundedWindow>> cleanupQueue;
        private final Supplier<ByteBuffer> currentKeySupplier;
        private final ThrowingFunction<Long, Boolean> hasPendingEventTimeTimers;
        private final CleanupTimer cleanupTimer;

        StateCleaner(List<String> userStateNames, Coder windowCoder, Supplier<ByteBuffer> currentKeySupplier, ThrowingFunction<Long, Boolean> hasPendingEventTimeTimers, CleanupTimer cleanupTimer) {
            this.userStateNames = userStateNames;
            this.windowCoder = windowCoder;
            this.currentKeySupplier = currentKeySupplier;
            this.hasPendingEventTimeTimers = hasPendingEventTimeTimers;
            this.cleanupTimer = cleanupTimer;
            this.cleanupQueue = new ArrayDeque();
        }

        public void clearForWindow(BoundedWindow window) {
            this.cleanupQueue.add((KV<ByteBuffer, BoundedWindow>)KV.of((Object)this.currentKeySupplier.get(), (Object)window));
        }

        void cleanupState(StateInternals stateInternals, Consumer<ByteBuffer> keyContextConsumer) throws Exception {
            while (!this.cleanupQueue.isEmpty()) {
                KV kv = (KV)Preconditions.checkNotNull(this.cleanupQueue.remove());
                BoundedWindow window = (BoundedWindow)Preconditions.checkNotNull((Object)((BoundedWindow)kv.getValue()));
                keyContextConsumer.accept((ByteBuffer)kv.getKey());
                if (((Boolean)this.hasPendingEventTimeTimers.apply((Object)window.maxTimestamp().getMillis())).booleanValue()) {
                    this.cleanupTimer.setCleanupTimer(window);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("State cleanup for {} {}", (Object)Arrays.toString(((ByteBuffer)kv.getKey()).array()), (Object)window);
                }
                for (String userState : this.userStateNames) {
                    StateNamespace namespace = StateNamespaces.window((Coder)this.windowCoder, (BoundedWindow)window);
                    StateTag bagStateStateTag = StateTags.bag((String)userState, (Coder)VoidCoder.of());
                    BagState state = (BagState)stateInternals.state(namespace, bagStateStateTag);
                    state.clear();
                }
            }
        }
    }

    static class CleanupTimer<InputT>
    implements StatefulDoFnRunner.CleanupTimer<InputT> {
        private static final String GC_TIMER_ID = "__user-state-cleanup__";
        private final TimerInternals timerInternals;
        private final Lock stateBackendLock;
        private final WindowingStrategy windowingStrategy;
        private final Coder keyCoder;
        private final Coder windowCoder;
        private final KeyedStateBackend<ByteBuffer> keyedStateBackend;

        CleanupTimer(TimerInternals timerInternals, Lock stateBackendLock, WindowingStrategy windowingStrategy, Coder keyCoder, Coder windowCoder, KeyedStateBackend<ByteBuffer> keyedStateBackend) {
            this.timerInternals = timerInternals;
            this.stateBackendLock = stateBackendLock;
            this.windowingStrategy = windowingStrategy;
            this.keyCoder = keyCoder;
            this.windowCoder = windowCoder;
            this.keyedStateBackend = keyedStateBackend;
        }

        public void setForWindow(InputT input, BoundedWindow window) {
            Preconditions.checkNotNull(input, (Object)"Null input passed to CleanupTimer");
            if (window.equals(GlobalWindow.INSTANCE)) {
                return;
            }
            ByteBuffer key = FlinkKeyUtils.encodeKey(((KV)input).getKey(), this.keyCoder);
            try (Locker locker = Locker.locked(this.stateBackendLock);){
                this.keyedStateBackend.setCurrentKey((Object)key);
                this.setCleanupTimer(window);
            }
        }

        void setCleanupTimer(BoundedWindow window) {
            Instant gcTime = LateDataUtils.garbageCollectionTime((BoundedWindow)window, (WindowingStrategy)this.windowingStrategy).plus((ReadableDuration)Duration.millis((long)1L));
            this.timerInternals.setTimer(StateNamespaces.window((Coder)this.windowCoder, (BoundedWindow)window), GC_TIMER_ID, "", gcTime, window.maxTimestamp(), TimeDomain.EVENT_TIME);
        }

        public boolean isForWindow(String timerId, BoundedWindow window, Instant timestamp, TimeDomain timeDomain) {
            boolean isEventTimer = timeDomain.equals((Object)TimeDomain.EVENT_TIME);
            Instant gcTime = LateDataUtils.garbageCollectionTime((BoundedWindow)window, (WindowingStrategy)this.windowingStrategy).plus((ReadableDuration)Duration.millis((long)1L));
            return isEventTimer && GC_TIMER_ID.equals(timerId) && gcTime.equals((Object)timestamp);
        }
    }

    private static class SdkHarnessDoFnRunner<InputT, OutputT>
    implements DoFnRunner<InputT, OutputT> {
        private final DoFn<InputT, OutputT> doFn;
        private final LinkedBlockingQueue<KV<String, OutputT>> outputQueue;
        private final StageBundleFactory stageBundleFactory;
        private final StateRequestHandler stateRequestHandler;
        private final BundleProgressHandler progressHandler;
        private final BundleFinalizationHandler finalizationHandler;
        private final BundleCheckpointHandler checkpointHandler;
        private final DoFnOperator.BufferedOutputManager<OutputT> outputManager;
        private final Map<String, TupleTag<?>> outputMap;
        private final FlinkStateInternals<?> keyedStateInternals;
        private final Coder<BoundedWindow> windowCoder;
        private final Coder<WindowedValue<InputT>> residualCoder;
        private final BiConsumer<Timer<?>, TimerInternals.TimerData> timerRegistration;
        private final Supplier<Object> keyForTimer;
        private volatile RemoteBundle remoteBundle;
        private volatile FnDataReceiver<WindowedValue<?>> mainInputReceiver;

        public SdkHarnessDoFnRunner(DoFn<InputT, OutputT> doFn, StageBundleFactory stageBundleFactory, StateRequestHandler stateRequestHandler, BundleProgressHandler progressHandler, BundleFinalizationHandler finalizationHandler, BundleCheckpointHandler checkpointHandler, DoFnOperator.BufferedOutputManager<OutputT> outputManager, Map<String, TupleTag<?>> outputMap, Coder<BoundedWindow> windowCoder, Coder<WindowedValue<InputT>> residualCoder, BiConsumer<Timer<?>, TimerInternals.TimerData> timerRegistration, Supplier<Object> keyForTimer, FlinkStateInternals<?> keyedStateInternals) {
            this.doFn = doFn;
            this.stageBundleFactory = stageBundleFactory;
            this.stateRequestHandler = stateRequestHandler;
            this.progressHandler = progressHandler;
            this.finalizationHandler = finalizationHandler;
            this.checkpointHandler = checkpointHandler;
            this.outputManager = outputManager;
            this.outputMap = outputMap;
            this.timerRegistration = timerRegistration;
            this.keyForTimer = keyForTimer;
            this.windowCoder = windowCoder;
            this.residualCoder = residualCoder;
            this.outputQueue = new LinkedBlockingQueue();
            this.keyedStateInternals = keyedStateInternals;
        }

        public void startBundle() {
            OutputReceiverFactory receiverFactory = new OutputReceiverFactory(){

                public FnDataReceiver<OutputT> create(String pCollectionId) {
                    return receivedElement -> outputQueue.put(KV.of((Object)pCollectionId, (Object)receivedElement));
                }
            };
            TimerReceiverFactory timerReceiverFactory = new TimerReceiverFactory(this.stageBundleFactory, this.timerRegistration, this.windowCoder);
            try {
                this.remoteBundle = this.stageBundleFactory.getBundle(receiverFactory, timerReceiverFactory, this.stateRequestHandler, this.progressHandler, this.finalizationHandler, this.checkpointHandler);
                this.mainInputReceiver = (FnDataReceiver)Iterables.getOnlyElement(this.remoteBundle.getInputReceivers().values());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start remote bundle", e);
            }
        }

        public void processElement(WindowedValue<InputT> element) {
            try {
                LOG.debug("Processing value: {}", element);
                this.mainInputReceiver.accept(element);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to process element with SDK harness.", e);
            }
            this.emitResults();
        }

        public <KeyT> void onTimer(String timerId, String timerFamilyId, KeyT key, BoundedWindow window, Instant timestamp, Instant outputTimestamp, TimeDomain timeDomain) {
            Object timerKey = this.keyForTimer.get();
            Preconditions.checkNotNull((Object)timerKey, (Object)"Key for timer needs to be set before calling onTimer");
            Preconditions.checkNotNull((Object)this.remoteBundle, (Object)"Call to onTimer outside of a bundle");
            if (BundleCheckpointHandlers.StateAndTimerBundleCheckpointHandler.isSdfTimer((String)timerId)) {
                StateNamespace namespace = StateNamespaces.window(this.windowCoder, (BoundedWindow)window);
                WindowedValue stateValue = (WindowedValue)((ValueState)this.keyedStateInternals.state(namespace, StateTags.value((String)timerId, this.residualCoder))).read();
                this.processElement(stateValue);
            } else {
                KV transformAndTimerFamilyId = TimerReceiverFactory.decodeTimerDataTimerId((String)timerFamilyId);
                LOG.debug("timer callback: {} {} {} {} {}", new Object[]{transformAndTimerFamilyId.getKey(), transformAndTimerFamilyId.getValue(), window, timestamp, timeDomain});
                FnDataReceiver timerReceiver = (FnDataReceiver)Preconditions.checkNotNull((Object)((FnDataReceiver)this.remoteBundle.getTimerReceivers().get(transformAndTimerFamilyId)), (String)"No receiver found for timer %s %s", (Object)transformAndTimerFamilyId.getKey(), (Object)transformAndTimerFamilyId.getValue());
                Timer timerValue = Timer.of((Object)timerKey, (String)timerId, Collections.singletonList(window), (Instant)timestamp, (Instant)outputTimestamp, (PaneInfo)PaneInfo.NO_FIRING);
                try {
                    timerReceiver.accept((Object)timerValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to process timer %s", timerReceiver), e);
                }
            }
        }

        public void finishBundle() {
            try {
                this.remoteBundle.close();
                this.emitResults();
            }
            catch (Exception e) {
                if (e.getCause() instanceof StatusRuntimeException) {
                    throw new RuntimeException("SDK Harness connection lost.", e);
                }
                throw new RuntimeException("Failed to finish remote bundle", e);
            }
            finally {
                this.remoteBundle = null;
            }
        }

        public <KeyT> void onWindowExpiration(BoundedWindow window, Instant timestamp, KeyT key) {
        }

        boolean isBundleInProgress() {
            return this.remoteBundle != null;
        }

        private void emitResults() {
            KV<String, OutputT> result;
            while ((result = this.outputQueue.poll()) != null) {
                String outputPCollectionId = (String)Preconditions.checkNotNull((Object)((String)result.getKey()));
                TupleTag<?> tag = this.outputMap.get(outputPCollectionId);
                WindowedValue windowedValue = (WindowedValue)Preconditions.checkNotNull((Object)((WindowedValue)result.getValue()), (String)"Received a null value from the SDK harness for %s", (Object)outputPCollectionId);
                if (tag == null) {
                    throw new IllegalStateException(String.format("Received output for unknown PCollection %s", outputPCollectionId));
                }
                this.outputManager.output(tag, windowedValue);
            }
        }

        public DoFn<InputT, OutputT> getFn() {
            return this.doFn;
        }
    }

    class SdfFlinkStateInternals
    implements StateInternals {
        private final ByteBuffer key;

        SdfFlinkStateInternals(ByteBuffer key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T extends State> T state(StateNamespace namespace, StateTag<T> address, StateContext<?> c) {
            try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                ExecutableStageDoFnOperator.this.getKeyedStateBackend().setCurrentKey((Object)this.key);
                State state = ExecutableStageDoFnOperator.this.keyedStateInternals.state(namespace, address);
                return (T)state;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't set state", e);
            }
        }
    }

    class SdfFlinkStateInternalsFactory
    implements StateInternalsFactory<InputT> {
        SdfFlinkStateInternalsFactory() {
        }

        public StateInternals stateInternalsForKey(InputT key) {
            try {
                ByteBuffer encodedKey = (ByteBuffer)ExecutableStageDoFnOperator.this.keySelector.getKey((Object)WindowedValue.valueInGlobalWindow(key));
                return new SdfFlinkStateInternals(encodedKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get a state internals", e);
            }
        }
    }

    class SdfFlinkTimerInternals
    implements TimerInternals {
        private final ByteBuffer key;

        SdfFlinkTimerInternals(ByteBuffer key) {
            this.key = key;
        }

        public void setTimer(StateNamespace namespace, String timerId, String timerFamilyId, Instant target, Instant outputTimestamp, TimeDomain timeDomain) {
            this.setTimer(TimerInternals.TimerData.of((String)timerId, (String)timerFamilyId, (StateNamespace)namespace, (Instant)target, (Instant)outputTimestamp, (TimeDomain)timeDomain));
        }

        public void setTimer(TimerInternals.TimerData timerData) {
            try (Locker locker = Locker.locked(ExecutableStageDoFnOperator.this.stateBackendLock);){
                ExecutableStageDoFnOperator.this.getKeyedStateBackend().setCurrentKey((Object)this.key);
                ExecutableStageDoFnOperator.this.timerInternals.setTimer(timerData);
                ExecutableStageDoFnOperator.this.minEventTimeTimerTimestampInCurrentBundle = Math.min(ExecutableStageDoFnOperator.this.minEventTimeTimerTimestampInCurrentBundle, DoFnOperator.adjustTimestampForFlink(timerData.getOutputTimestamp().getMillis()));
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't set timer", e);
            }
        }

        public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId, TimeDomain timeDomain) {
            throw new UnsupportedOperationException("It is not expected to use SdfFlinkTimerInternals to delete a timer");
        }

        public void deleteTimer(StateNamespace namespace, String timerId, String timerFamilyId) {
            throw new UnsupportedOperationException("It is not expected to use SdfFlinkTimerInternals to delete a timer");
        }

        public void deleteTimer(TimerInternals.TimerData timerKey) {
            throw new UnsupportedOperationException("It is not expected to use SdfFlinkTimerInternals to delete a timer");
        }

        public Instant currentProcessingTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentProcessingTime();
        }

        public @Nullable Instant currentSynchronizedProcessingTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentSynchronizedProcessingTime();
        }

        public Instant currentInputWatermarkTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentInputWatermarkTime();
        }

        public @Nullable Instant currentOutputWatermarkTime() {
            return ExecutableStageDoFnOperator.this.timerInternals.currentOutputWatermarkTime();
        }
    }

    class SdfFlinkTimerInternalsFactory
    implements TimerInternalsFactory<InputT> {
        SdfFlinkTimerInternalsFactory() {
        }

        public TimerInternals timerInternalsForKey(InputT key) {
            try {
                ByteBuffer encodedKey = (ByteBuffer)ExecutableStageDoFnOperator.this.keySelector.getKey((Object)WindowedValue.valueInGlobalWindow(key));
                return new SdfFlinkTimerInternals(encodedKey);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get a timer internals", e);
            }
        }
    }

    static class BagUserStateFactory<V, W extends BoundedWindow>
    implements StateRequestHandlers.BagUserStateHandlerFactory<ByteString, V, W> {
        private final StateInternals stateInternals;
        private final KeyedStateBackend<ByteBuffer> keyedStateBackend;
        private final Lock stateBackendLock;
        private final @Nullable Coder runnerKeyCoder;
        private final @Nullable AbstractKeyedStateBackend<ByteBuffer> keyStateBackendWithKeyGroupInfo;

        BagUserStateFactory(StateInternals stateInternals, KeyedStateBackend<ByteBuffer> keyedStateBackend, Lock stateBackendLock, @Nullable Coder runnerKeyCoder) {
            this.stateInternals = stateInternals;
            this.keyedStateBackend = keyedStateBackend;
            this.stateBackendLock = stateBackendLock;
            this.keyStateBackendWithKeyGroupInfo = keyedStateBackend instanceof AbstractKeyedStateBackend ? (AbstractKeyedStateBackend)keyedStateBackend : null;
            this.runnerKeyCoder = runnerKeyCoder;
        }

        public StateRequestHandlers.BagUserStateHandler<ByteString, V, W> forUserState(final String pTransformId, final String userStateId, Coder<ByteString> keyCoder, final Coder<V> valueCoder, final Coder<W> windowCoder) {
            return new StateRequestHandlers.BagUserStateHandler<ByteString, V, W>(){

                public Iterable<V> get(ByteString key, W window) {
                    try (Locker locker = Locker.locked(stateBackendLock);){
                        this.prepareStateBackend(key);
                        StateNamespace namespace = StateNamespaces.window((Coder)windowCoder, window);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("State get for {} {} {} {}", new Object[]{pTransformId, userStateId, Arrays.toString(((ByteBuffer)keyedStateBackend.getCurrentKey()).array()), window});
                        }
                        BagState bagState = (BagState)stateInternals.state(namespace, StateTags.bag((String)userStateId, (Coder)valueCoder));
                        Iterable iterable = bagState.read();
                        return iterable;
                    }
                }

                public void append(ByteString key, W window, Iterator<V> values) {
                    try (Locker locker = Locker.locked(stateBackendLock);){
                        this.prepareStateBackend(key);
                        StateNamespace namespace = StateNamespaces.window((Coder)windowCoder, window);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("State append for {} {} {} {}", new Object[]{pTransformId, userStateId, Arrays.toString(((ByteBuffer)keyedStateBackend.getCurrentKey()).array()), window});
                        }
                        BagState bagState = (BagState)stateInternals.state(namespace, StateTags.bag((String)userStateId, (Coder)valueCoder));
                        while (values.hasNext()) {
                            bagState.add(values.next());
                        }
                    }
                }

                public void clear(ByteString key, W window) {
                    try (Locker locker = Locker.locked(stateBackendLock);){
                        this.prepareStateBackend(key);
                        StateNamespace namespace = StateNamespaces.window((Coder)windowCoder, window);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("State clear for {} {} {} {}", new Object[]{pTransformId, userStateId, Arrays.toString(((ByteBuffer)keyedStateBackend.getCurrentKey()).array()), window});
                        }
                        BagState bagState = (BagState)stateInternals.state(namespace, StateTags.bag((String)userStateId, (Coder)valueCoder));
                        bagState.clear();
                    }
                }

                private void prepareStateBackend(ByteString key) {
                    ByteBuffer encodedKey = FlinkKeyUtils.fromEncodedKey(key);
                    keyedStateBackend.setCurrentKey((Object)encodedKey);
                    if (keyStateBackendWithKeyGroupInfo != null) {
                        int currentKeyGroupIndex = keyStateBackendWithKeyGroupInfo.getCurrentKeyGroupIndex();
                        KeyGroupRange keyGroupRange = keyStateBackendWithKeyGroupInfo.getKeyGroupRange();
                        Preconditions.checkState((boolean)keyGroupRange.contains(currentKeyGroupIndex), (String)"The current key '%s' with key group index '%s' does not belong to the key group range '%s'. Runner keyCoder: %s. Ptransformid: %s Userstateid: %s", (Object[])new Object[]{Arrays.toString(key.toByteArray()), currentKeyGroupIndex, keyGroupRange, runnerKeyCoder, pTransformId, userStateId});
                    }
                }
            };
        }
    }
}

