/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.util.HashCode$;
import akka.util.ManifestInfo$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=u!B\u0001\u0003\u0011\u00039\u0011\u0001D'b]&4Wm\u001d;J]\u001a|'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0003\u0015\tA!Y6lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!\u0001D'b]&4Wm\u001d;J]\u001a|7#B\u0005\r%\u0005m\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00035M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001\u0003<feNLwN\\:\u0016\u00035\u0002BAL\u00195o9\u0011QbL\u0005\u0003a9\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\ri\u0015\r\u001d\u0006\u0003a9\u0001\"AL\u001b\n\u0005Y\u001a$AB*ue&tw\r\u0005\u00029s9\u0011\u0001\u0002\u0001\u0004\u0005u%\u00111HA\u0004WKJ\u001c\u0018n\u001c8\u0014\u0007ebA\bE\u0002>\u0005\u0012k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005)\u0019u.\u001c9be\u0006\u0014G.\u001a\t\u0003\u000bfj\u0011!\u0003\u0005\t\u000ff\u0012)\u0019!C\u0001\u0011\u00069a/\u001a:tS>tW#\u0001\u001b\t\u0011)K$\u0011!Q\u0001\nQ\n\u0001B^3sg&|g\u000e\t\u0005\u0006Oe\"\t\u0001\u0014\u000b\u0003\t6CQaR&A\u0002QB!bT\u001d\u0011\u0002\u0003\r\t\u0015!\u0003Q\u0003\rAH%\r\t\u0005\u001bE\u001b\u0016,\u0003\u0002S\u001d\t1A+\u001e9mKJ\u00022!\u0004+W\u0013\t)fBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000e/&\u0011\u0001L\u0004\u0002\u0004\u0013:$\bCA\u001f[\u0013\t1d\bC\u0004]s\t\u0007I\u0011B/\u0002\u000f9,XNY3sgV\t1\u000b\u0003\u0004`s\u0001\u0006IaU\u0001\t]Vl'-\u001a:tA!9\u0011-\u000fb\u0001\n\u0013A\u0015\u0001\u0002:fgRDaaY\u001d!\u0002\u0013!\u0014!\u0002:fgR\u0004\u0003\"B3:\t\u00032\u0017!C2p[B\f'/\u001a+p)\t1v\rC\u0003iI\u0002\u0007A)A\u0003pi\",'\u000fC\u0003ks\u0011\u00053.\u0001\u0004fcV\fGn\u001d\u000b\u0003Y>\u0004\"!D7\n\u00059t!a\u0002\"p_2,\u0017M\u001c\u0005\u0006a&\u0004\r!]\u0001\u0002_B\u0011QB]\u0005\u0003g:\u00111!\u00118z\u0011\u0015)\u0018\b\"\u0011w\u0003!A\u0017m\u001d5D_\u0012,G#\u0001,\t\u000baLD\u0011I=\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u000e\u0005\u0007wf\u0001\u000b\u0011B\u0017\u0002\u0013Y,'o]5p]N\u0004\u0003\"B?\u001a\t\u0003q\u0018\u0001E2iK\u000e\\7+Y7f-\u0016\u00148/[8o)\u0019aw0a\u0001\u0002\u0018!1\u0011\u0011\u0001?A\u0002Q\n1\u0002\u001d:pIV\u001cGOT1nK\"9\u0011Q\u0001?A\u0002\u0005\u001d\u0011\u0001\u00043fa\u0016tG-\u001a8dS\u0016\u001c\b#BA\u0005\u0003'!TBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013%lW.\u001e;bE2,'bAA\t\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0004'\u0016\f\bBBA\ry\u0002\u0007A.\u0001\u0006m_\u001e<\u0016M\u001d8j]\u001e\u00042aEA\u000f\u0013\r\ty\u0002\u0006\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u0005\u0007O%!\t!a\t\u0015\u0003\u001dA\u0011\"a\n\n\u0005\u0004%I!!\u000b\u0002\u0013%k\u0007\u000f\u001c+ji2,W#A-\t\u000f\u00055\u0012\u0002)A\u00053\u0006Q\u0011*\u001c9m)&$H.\u001a\u0011\t\u0013\u0005E\u0012B1A\u0005\n\u0005%\u0012aC%na24VM]:j_:Dq!!\u000e\nA\u0003%\u0011,\u0001\u0007J[Bdg+\u001a:tS>t\u0007\u0005C\u0005\u0002:%\u0011\r\u0011\"\u0003\u0002*\u0005Q\u0011*\u001c9m-\u0016tGm\u001c:\t\u000f\u0005u\u0012\u0002)A\u00053\u0006Y\u0011*\u001c9m-\u0016tGm\u001c:!\u0011%\t\t%\u0003b\u0001\n\u0013\tI#\u0001\u0006Ck:$G.\u001a(b[\u0016Dq!!\u0012\nA\u0003%\u0011,A\u0006Ck:$G.\u001a(b[\u0016\u0004\u0003\"CA%\u0013\t\u0007I\u0011BA\u0015\u00035\u0011UO\u001c3mKZ+'o]5p]\"9\u0011QJ\u0005!\u0002\u0013I\u0016A\u0004\"v]\u0012dWMV3sg&|g\u000e\t\u0005\n\u0003#J!\u0019!C\u0005\u0003S\tABQ;oI2,g+\u001a8e_JDq!!\u0016\nA\u0003%\u0011,A\u0007Ck:$G.\u001a,f]\u0012|'\u000f\t\u0005\n\u00033J!\u0019!C\u0005\u00037\nAb\u001b8po:4VM\u001c3peN,\"!!\u0018\u0011\u000b\u0005%\u0011qL-\n\t\u0005\u0005\u00141\u0002\u0002\u0004'\u0016$\b\u0002CA3\u0013\u0001\u0006I!!\u0018\u0002\u001b-twn\u001e8WK:$wN]:!\u0011\u001d\tI'\u0003C!\u0003W\n1aZ3u)\rA\u0012Q\u000e\u0005\b?\u0005\u001d\u0004\u0019AA8!\r\u0019\u0012\u0011O\u0005\u0004\u0003g\"\"aC!di>\u00148+_:uK6Dq!!\u001b\n\t\u0003\n9\bF\u0002\u0019\u0003sBqaHA;\u0001\u0004\tY\bE\u0002\u0014\u0003{J1!a \u0015\u0005i\u0019E.Y:tS\u000e\f5\r^8s'f\u001cH/Z7Qe>4\u0018\u000eZ3s\u0011\u001d\t\u0019)\u0003C!\u0003\u000b\u000ba\u0001\\8pWV\u0004H#\u0001\u001d\t\u000f\u0005%\u0015\u0002\"\u0011\u0002\f\u0006y1M]3bi\u0016,\u0005\u0010^3og&|g\u000eF\u0002\u0019\u0003\u001bCaaHAD\u0001\u0004\t\u0003")
public final class ManifestInfo
implements Extension {
    private final ExtendedActorSystem system;
    private final Map<String, Version> versions;

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.apply(actorSystem);
    }

    public static ManifestInfo createExtension(ExtendedActorSystem extendedActorSystem) {
        return ManifestInfo$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ManifestInfo$ lookup() {
        return ManifestInfo$.MODULE$.lookup();
    }

    public static ManifestInfo get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ManifestInfo$.MODULE$.get(classicActorSystemProvider);
    }

    public static ManifestInfo get(ActorSystem actorSystem) {
        return ManifestInfo$.MODULE$.get(actorSystem);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Map<String, Version> versions() {
        return this.versions;
    }

    public boolean checkSameVersion(String productName, scala.collection.immutable.Seq<String> dependencies, boolean logWarning) {
        boolean bl;
        Map filteredVersions = this.versions().filterKeys((Function1)dependencies.toSet());
        Set values2 = filteredVersions.values().toSet();
        if (values2.size() > 1) {
            if (logWarning) {
                String conflictingVersions = values2.mkString(", ");
                String fullInfo = ((TraversableOnce)filteredVersions.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, Version> x0$1) {
                        Tuple2<String, Version> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            Version v = (Version)tuple2._2();
                            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
                Version highestVersion = (Version)values2.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning(new StringBuilder().append((Object)"Detected possible incompatible versions on the classpath. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please note that a given ", " version MUST be the same across all modules of ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{productName, productName}))).append((Object)"that you are using, e.g. if you use [{}] all other modules that are released together MUST be of the ").append((Object)"same version. Make sure you're using a compatible set of libraries. ").append((Object)"Possibly conflicting versions [{}] in libraries [{}]").toString(), highestVersion, conflictingVersions, fullInfo);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree2$1(ObjectRef manifests$1) {
        try {
            Enumeration<URL> resources = this.system().dynamicAccess().classLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream ios;
                block5: {
                    ios = resources.nextElement().openStream();
                    try {
                        Manifest manifest = new Manifest(ios);
                        Attributes attributes = manifest.getMainAttributes();
                        String string = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplTitle()));
                        String string2 = string == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleName())) : string;
                        String title = string2;
                        String string3 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVersion()));
                        String string4 = string3 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVersion())) : string3;
                        String version = string4;
                        String string5 = attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$ImplVendor()));
                        String string6 = string5 == null ? attributes.getValue(new Attributes.Name(ManifestInfo$.MODULE$.akka$util$ManifestInfo$$BundleVendor())) : string5;
                        String vendor = string6;
                        if (title == null || version == null || vendor == null || !ManifestInfo$.MODULE$.akka$util$ManifestInfo$$knownVendors().apply((Object)vendor)) break block5;
                        manifests$1.elem = ((Map)manifests$1.elem).updated((Object)title, (Object)new Version(version));
                    }
                    catch (Throwable throwable) {
                        void var4_3;
                        var4_3.close();
                        throw throwable;
                        return;
                    }
                }
                ios.close();
            }
        }
        catch (IOException iOException) {
            Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromAnyClass()).warning("Could not read manifest information. {}", iOException);
        }
    }

    public ManifestInfo(ExtendedActorSystem system) {
        this.system = system;
        ObjectRef manifests = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        this.liftedTree2$1(manifests);
        this.versions = (Map)manifests.elem;
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final /* synthetic */ Tuple2 x$1;
        private final int[] numbers;
        private final String rest;

        public String version() {
            return this.version;
        }

        private int[] numbers() {
            return this.numbers;
        }

        private String rest() {
            return this.rest;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Version other) {
            void var2_2;
            int diff = 0;
            diff = this.numbers()[0] - other.numbers()[0];
            if (diff == 0 && (diff = this.numbers()[1] - other.numbers()[1]) == 0 && (diff = this.numbers()[2] - other.numbers()[2]) == 0) {
                diff = this.rest().compareTo(other.rest());
            }
            return (int)var2_2;
        }

        public boolean equals(Object o) {
            Version version;
            Object object = o;
            boolean bl = object instanceof Version ? this.compareTo(version = (Version)object) == 0 : false;
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = HashCode$.MODULE$.SEED();
            result = HashCode$.MODULE$.hash(result, this.numbers()[0]);
            result = HashCode$.MODULE$.hash(result, this.numbers()[1]);
            result = HashCode$.MODULE$.hash(result, this.numbers()[2]);
            result = HashCode$.MODULE$.hash(result, this.rest());
            return (int)var1_1;
        }

        public String toString() {
            return this.version();
        }

        private final void liftedTree1$1(int[] numbers$1, String[] segments$1, IntRef segmentPos$1, IntRef numbersPos$1) {
            try {
                numbers$1[numbersPos$1.elem] = new StringOps(Predef$.MODULE$.augmentString(segments$1[segmentPos$1.elem])).toInt();
                ++segmentPos$1.elem;
            }
            catch (NumberFormatException numberFormatException) {
                numbers$1[numbersPos$1.elem] = Integer.MAX_VALUE;
            }
        }

        public Version(String version) {
            this.version = version;
            int[] numbers = new int[3];
            String[] segments = version.split("[.-]");
            IntRef segmentPos = IntRef.create((int)0);
            IntRef numbersPos = IntRef.create((int)0);
            while (numbersPos.elem < 3) {
                if (segmentPos.elem < segments.length) {
                    this.liftedTree1$1(numbers, segments, segmentPos, numbersPos);
                }
                ++numbersPos.elem;
            }
            String rest = segmentPos.elem >= segments.length ? "" : String.join((CharSequence)"-", Arrays.asList(Arrays.copyOfRange((Object[])segments, segmentPos.elem, segments.length)));
            Tuple2 tuple2 = new Tuple2((Object)numbers, (Object)rest);
            if (tuple2 != null) {
                int[] numbers2 = (int[])tuple2._1();
                String rest2 = (String)tuple2._2();
                if (numbers2 != null) {
                    int[] nArray = numbers2;
                    if (rest2 != null) {
                        Tuple2 tuple22;
                        String string = rest2;
                        this.x$1 = tuple22 = new Tuple2((Object)nArray, (Object)string);
                        this.numbers = (int[])this.x$1._1();
                        this.rest = (String)this.x$1._2();
                        return;
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

