/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.userdefinedjavaclass;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClass;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UserDefinedJavaClassCodeSnippits {
    private static final Class<?> PKG = UserDefinedJavaClass.class;
    private static UserDefinedJavaClassCodeSnippits snippitsHelper = null;
    private final List<Snippit> snippits = new ArrayList<Snippit>();
    private final Map<String, Snippit> snippitsMap = new HashMap<String, Snippit>();
    private final LogChannel log = new LogChannel((Object)"UserDefinedJavaClassCodeSnippits");

    public static synchronized UserDefinedJavaClassCodeSnippits getSnippitsHelper() throws HopXmlException {
        if (snippitsHelper == null) {
            snippitsHelper = new UserDefinedJavaClassCodeSnippits();
            snippitsHelper.addSnippits("org/apache/hop/pipeline/transforms/userdefinedjavaclass/codeSnippits.xml");
        }
        return snippitsHelper;
    }

    private UserDefinedJavaClassCodeSnippits() {
    }

    public void addSnippits(String strFileName) throws HopXmlException {
        Document doc = XmlHandler.loadXmlFile((InputStream)UserDefinedJavaClassCodeSnippits.class.getClassLoader().getResourceAsStream(strFileName), null, (boolean)false, (boolean)false);
        this.buildSnippitList(doc);
    }

    public List<Snippit> getSnippits() {
        return Collections.unmodifiableList(this.snippits);
    }

    public String getDefaultCode() {
        return this.getCode("Implement processRow");
    }

    public String getCode(String snippitName) {
        Snippit snippit = this.snippitsMap.get(snippitName);
        return snippit == null ? "" : snippit.code;
    }

    public String getSample(String snippitName) {
        Snippit snippit = this.snippitsMap.get(snippitName);
        return snippit == null ? "" : snippit.sample;
    }

    private void buildSnippitList(Document doc) {
        List nodes = XmlHandler.getNodes((Node)XmlHandler.getSubNode((Node)doc, (String)"codeSnippits"), (String)"codeSnippit");
        for (Node node : nodes) {
            Snippit snippit = new Snippit(Category.valueOf(XmlHandler.getTagValue((Node)node, (String)"category")), XmlHandler.getTagValue((Node)node, (String)"name"), XmlHandler.getTagValue((Node)node, (String)"sample"), XmlHandler.getTagValue((Node)node, (String)"code"));
            this.snippits.add(snippit);
            Snippit oldSnippit = this.snippitsMap.put(snippit.name, snippit);
            if (oldSnippit == null) continue;
            this.log.logError("Multiple code snippits for name: " + snippit.name);
        }
    }

    public static class Snippit {
        public final Category category;
        public final String name;
        public final String sample;
        public final String code;

        private Snippit(Category category, String name, String sample, String code) {
            this.category = category;
            this.name = name;
            this.sample = sample;
            this.code = code;
        }
    }

    public static enum Category {
        COMMON(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassCodeSnippits.categories.COMMON", (String[])new String[0])),
        STATUS(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassCodeSnippits.categories.STATUS", (String[])new String[0])),
        LOGGING(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassCodeSnippits.categories.LOGGING", (String[])new String[0])),
        LISTENERS(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassCodeSnippits.categories.LISTENERS", (String[])new String[0])),
        ROW(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassCodeSnippits.categories.ROW", (String[])new String[0])),
        OTHER(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassCodeSnippits.categories.OTHER", (String[])new String[0]));

        private String description;

        private Category(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }
    }
}

