/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.http;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.HttpClientManager;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.http.HttpData;
import org.apache.hop.pipeline.transforms.http.HttpMeta;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;

public class Http
extends BaseTransform<HttpMeta, HttpData> {
    private static final Class<?> PKG = HttpMeta.class;
    public static final String CONST_HTTP_EXCEPTION_ERROR_FINDING_FIELD = "HTTP.Exception.ErrorFindingField";

    public Http(TransformMeta transformMeta, HttpMeta meta, HttpData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] execHttp(IRowMeta rowMeta, Object[] row) throws HopException {
        if (this.first) {
            this.first = false;
            ((HttpData)this.data).argnrs = new int[((HttpMeta)this.meta).getArgumentField().length];
            for (int i = 0; i < ((HttpMeta)this.meta).getArgumentField().length; ++i) {
                ((HttpData)this.data).argnrs[i] = rowMeta.indexOfValue(((HttpMeta)this.meta).getArgumentField()[i]);
                if (((HttpData)this.data).argnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.ErrorFindingField", (String[])new String[0]) + ((HttpMeta)this.meta).getArgumentField()[i] + "]");
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTP.Exception.CouldnotFindField", (String[])new String[]{((HttpMeta)this.meta).getArgumentField()[i]}));
            }
        }
        return this.callHttpService(rowMeta, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Object[] callHttpService(IRowMeta rowMeta, Object[] rowData) throws HopException {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        if (((HttpData)this.data).realConnectionTimeout > -1) {
            clientBuilder.setConnectionTimeout(((HttpData)this.data).realConnectionTimeout);
        }
        if (((HttpData)this.data).realSocketTimeout > -1) {
            clientBuilder.setSocketTimeout(((HttpData)this.data).realSocketTimeout);
        }
        if (StringUtils.isNotBlank((String)((HttpData)this.data).realHttpLogin)) {
            clientBuilder.setCredentials(((HttpData)this.data).realHttpLogin, ((HttpData)this.data).realHttpPassword);
        }
        if (StringUtils.isNotBlank((String)((HttpData)this.data).realProxyHost)) {
            clientBuilder.setProxy(((HttpData)this.data).realProxyHost, ((HttpData)this.data).realProxyPort);
        }
        if (((HttpMeta)this.meta).isIgnoreSsl()) {
            clientBuilder.ignoreSsl(true);
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        URI uri = null;
        try {
            URIBuilder uriBuilder = this.constructUrlBuilder(rowMeta, rowData);
            uri = uriBuilder.build();
            HttpGet method = new HttpGet(uri);
            if (((HttpData)this.data).useHeaderParameters) {
                for (int i = 0; i < ((HttpData)this.data).header_parameters_nrs.length; ++i) {
                    method.addHeader(((HttpData)this.data).headerParameters[i].getName(), ((HttpData)this.data).inputRowMeta.getString(rowData, ((HttpData)this.data).header_parameters_nrs[i]));
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPDialog.Log.HeaderValue", (String[])new String[]{((HttpData)this.data).headerParameters[i].getName(), ((HttpData)this.data).inputRowMeta.getString(rowData, ((HttpData)this.data).header_parameters_nrs[i])}));
                }
            }
            Object[] newRow = null;
            if (rowData != null) {
                newRow = (Object[])rowData.clone();
            }
            CloseableHttpResponse httpResponse = null;
            try {
                long startTime = System.currentTimeMillis();
                HttpHost target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                if (StringUtils.isNotBlank((String)((HttpData)this.data).realProxyHost)) {
                    target = new HttpHost(((HttpData)this.data).realProxyHost, ((HttpData)this.data).realProxyPort, "http");
                }
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(target, (AuthScheme)basicAuth);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache((AuthCache)authCache);
                httpResponse = httpClient.execute(target, (HttpRequest)method, (HttpContext)localContext);
                long responseTime = System.currentTimeMillis() - startTime;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseTime", (Object[])new Object[]{responseTime, uri}));
                }
                int statusCode = this.requestStatusCode((HttpResponse)httpResponse);
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTP.Log.ResponseStatusCode", (String[])new String[]{"" + statusCode}));
                }
                String body = switch (statusCode) {
                    case 401 -> throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTP.Exception.Authentication", (String[])new String[]{((HttpData)this.data).realUrl}));
                    case -1 -> throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTP.Exception.IllegalStatusCode", (String[])new String[]{((HttpData)this.data).realUrl}));
                    case 204 -> "";
                    default -> {
                        HttpEntity entity = httpResponse.getEntity();
                        yield entity != null ? (StringUtils.isEmpty((String)((HttpMeta)this.meta).getEncoding()) ? EntityUtils.toString((HttpEntity)entity) : EntityUtils.toString((HttpEntity)entity, (String)((HttpMeta)this.meta).getEncoding())) : "";
                    }
                };
                Header[] headers = this.searchForHeaders(httpResponse);
                JSONObject json = new JSONObject();
                for (Header header : headers) {
                    ArrayList<String> list;
                    Object previousValue = json.get((Object)header.getName());
                    if (previousValue == null) {
                        json.put((Object)header.getName(), (Object)header.getValue());
                        continue;
                    }
                    if (previousValue instanceof List) {
                        list = (ArrayList<String>)previousValue;
                        list.add(header.getValue());
                        continue;
                    }
                    list = new ArrayList<String>();
                    list.add((String)previousValue);
                    list.add(header.getValue());
                    json.put((Object)header.getName(), list);
                }
                String headerString = json.toJSONString();
                int returnFieldsOffset = rowMeta.size();
                if (!Utils.isEmpty((CharSequence)((HttpMeta)this.meta).getFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)((HttpMeta)this.meta).getResultCodeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)statusCode);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)((HttpMeta)this.meta).getResponseTimeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)responseTime);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)((HttpMeta)this.meta).getResponseHeaderFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
                }
            }
            finally {
                if (httpResponse != null) {
                    httpResponse.close();
                }
                method.releaseConnection();
            }
            return newRow;
        }
        catch (UnknownHostException uhe) {
            throw new HopException(BaseMessages.getString(PKG, (String)"HTTP.Error.UnknownHostException", (String[])new String[]{uhe.getMessage()}));
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"HTTP.Log.UnableGetResult", (Object[])new Object[]{uri}), (Throwable)e);
        }
    }

    private URIBuilder constructUrlBuilder(IRowMeta outputRowMeta, Object[] row) throws HopException {
        URIBuilder uriBuilder;
        try {
            String baseUrl = ((HttpData)this.data).realUrl;
            if (((HttpMeta)this.meta).isUrlInField()) {
                baseUrl = outputRowMeta.getString(row, ((HttpData)this.data).indexOfUrlField);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.Log.Connecting", (String[])new String[]{baseUrl}));
            }
            uriBuilder = new URIBuilder(baseUrl);
            List queryParams = uriBuilder.getQueryParams();
            for (int i = 0; i < ((HttpData)this.data).argnrs.length; ++i) {
                String key = ((HttpMeta)this.meta).getArgumentParameter()[i];
                String value = outputRowMeta.getString(row, ((HttpData)this.data).argnrs[i]);
                if (key.isEmpty() || value.isEmpty()) continue;
                uriBuilder.addParameter(key, value);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"HTTP.Log.UnableCreateUrl", (String[])new String[0]), (Throwable)e);
        }
        return uriBuilder;
    }

    protected int requestStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected Header[] searchForHeaders(CloseableHttpResponse response) {
        return response.getAllHeaders();
    }

    public boolean processRow() throws HopException {
        block14: {
            boolean firstWithoutPreviousTransforms;
            Object[] r = this.getRow();
            boolean bl = firstWithoutPreviousTransforms = this.first && ((HttpData)this.data).withoutPreviousTransforms;
            if (r == null && !firstWithoutPreviousTransforms) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrHeaders;
                ((HttpData)this.data).inputRowMeta = ((HttpData)this.data).withoutPreviousTransforms ? new RowMeta() : this.getInputRowMeta();
                ((HttpData)this.data).outputRowMeta = ((HttpData)this.data).inputRowMeta.clone();
                ((HttpMeta)this.meta).getFields(((HttpData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (((HttpMeta)this.meta).isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)((HttpMeta)this.meta).getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"HTTP.Log.NoField", (String[])new String[0]));
                    }
                    if (((HttpData)this.data).indexOfUrlField < 0) {
                        String realUrlFieldName = this.resolve(((HttpMeta)this.meta).getUrlField());
                        ((HttpData)this.data).indexOfUrlField = ((HttpData)this.data).inputRowMeta.indexOfValue(realUrlFieldName);
                        if (((HttpData)this.data).indexOfUrlField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"HTTP.Log.ErrorFindingField", (String[])new String[]{realUrlFieldName}));
                            throw new HopException(BaseMessages.getString(PKG, (String)CONST_HTTP_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{realUrlFieldName}));
                        }
                    }
                } else {
                    ((HttpData)this.data).realUrl = this.resolve(((HttpMeta)this.meta).getUrl());
                }
                if ((nrHeaders = ((HttpMeta)this.meta).getHeaderField().length) > 0) {
                    ((HttpData)this.data).useHeaderParameters = true;
                }
                ((HttpData)this.data).header_parameters_nrs = new int[nrHeaders];
                ((HttpData)this.data).headerParameters = new NameValuePair[nrHeaders];
                for (int i = 0; i < nrHeaders; ++i) {
                    int fieldIndex = ((HttpData)this.data).inputRowMeta.indexOfValue(((HttpMeta)this.meta).getHeaderField()[i]);
                    if (fieldIndex < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)CONST_HTTP_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[0]) + ((HttpMeta)this.meta).getHeaderField()[i] + "]");
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)CONST_HTTP_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{((HttpMeta)this.meta).getHeaderField()[i]}));
                    }
                    ((HttpData)this.data).header_parameters_nrs[i] = fieldIndex;
                    ((HttpData)this.data).headerParameters[i] = new BasicNameValuePair(this.resolve(((HttpMeta)this.meta).getHeaderParameter()[i]), ((HttpData)this.data).outputRowMeta.getString(r, ((HttpData)this.data).header_parameters_nrs[i]));
                }
            }
            try {
                Object[] outputRowData = this.execHttp(((HttpData)this.data).inputRowMeta, r);
                this.putRow(((HttpData)this.data).outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTP.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"HTTP.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block14;
                this.putError(((HttpData)this.data).inputRowMeta, r, 1L, errorMessage, null, "HTTP001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((HttpData)this.data).realProxyHost = this.resolve(((HttpMeta)this.meta).getProxyHost());
            ((HttpData)this.data).realProxyPort = Const.toInt((String)this.resolve(((HttpMeta)this.meta).getProxyPort()), (int)8080);
            ((HttpData)this.data).realHttpLogin = this.resolve(((HttpMeta)this.meta).getHttpLogin());
            ((HttpData)this.data).realHttpPassword = Utils.resolvePassword((IVariables)this.variables, (String)((HttpMeta)this.meta).getHttpPassword());
            ((HttpData)this.data).realSocketTimeout = Const.toInt((String)this.resolve(((HttpMeta)this.meta).getSocketTimeout()), (int)-1);
            ((HttpData)this.data).realConnectionTimeout = Const.toInt((String)this.resolve(((HttpMeta)this.meta).getConnectionTimeout()), (int)-1);
            ((HttpData)this.data).withoutPreviousTransforms = this.getPipelineMeta().getPrevTransforms(this.getTransformMeta()).length == 0;
            return true;
        }
        return false;
    }
}

