/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class LocalResources {
    public static @UnknownKeyFor @NonNull @Initialized ResourceId fromFile(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        return LocalResourceId.fromPath(file.toPath(), isDirectory);
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceId fromPath(@UnknownKeyFor @NonNull @Initialized Path path, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        return LocalResourceId.fromPath(path, isDirectory);
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceId fromString(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        return LocalResourceId.fromPath(Paths.get(filename, new String[0]), isDirectory);
    }

    public static @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized ResourceId> fromString(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> resourceProvider, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        return ValueProvider.NestedValueProvider.of(resourceProvider, input -> LocalResources.fromString(input, isDirectory));
    }

    private LocalResources() {
    }
}

