/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.metrics.MetricsPusher;
import org.apache.beam.runners.core.metrics.NoOpMetricsSink;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineResult;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.metrics.SparkBeamMetricSource;
import org.apache.beam.runners.spark.structuredstreaming.translation.EvaluationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkSessionFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.PipelineTranslatorBatch;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.util.construction.graph.ProjectionPushdownOptimizer;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.spark.SparkEnv$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.sql.SparkSession;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkStructuredStreamingRunner
extends PipelineRunner<SparkStructuredStreamingPipelineResult> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkStructuredStreamingRunner.class);
    private final @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options;

    public static @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingRunner create() {
        SparkStructuredStreamingPipelineOptions options = (SparkStructuredStreamingPipelineOptions)PipelineOptionsFactory.as(SparkStructuredStreamingPipelineOptions.class);
        options.setRunner(SparkStructuredStreamingRunner.class);
        return new SparkStructuredStreamingRunner(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingRunner create(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        return new SparkStructuredStreamingRunner(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new SparkStructuredStreamingRunner((SparkStructuredStreamingPipelineOptions)PipelineOptionsValidator.validate(SparkStructuredStreamingPipelineOptions.class, (PipelineOptions)options));
    }

    private SparkStructuredStreamingRunner(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        MetricsEnvironment.setMetricsSupported((boolean)true);
        MetricsAccumulator.clear();
        LOG.info("*** SparkStructuredStreamingRunner is based on spark structured streaming framework and is no more \n based on RDD/DStream API. See\n https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html\n It is still experimental, its coverage of the Beam model is partial. ***");
        PipelineTranslator.detectStreamingMode(pipeline, this.options);
        Preconditions.checkArgument((!this.options.isStreaming() ? 1 : 0) != 0, (Object)"Streaming is not supported.");
        SparkSession sparkSession = SparkSessionFactory.getOrCreateSession(this.options);
        MetricsAccumulator metrics = MetricsAccumulator.getInstance(sparkSession);
        Future<?> submissionFuture = SparkStructuredStreamingRunner.runAsync(() -> this.translatePipeline(sparkSession, pipeline).evaluate());
        SparkStructuredStreamingPipelineResult result = new SparkStructuredStreamingPipelineResult(submissionFuture, metrics, SparkStructuredStreamingRunner.sparkStopFn(sparkSession, this.options.getUseActiveSparkSession()));
        if (this.options.getEnableSparkMetricSinks().booleanValue()) {
            this.registerMetricsSource(this.options.getAppName(), metrics);
        }
        this.startMetricsPusher(result, metrics);
        if (this.options.getTestMode()) {
            result.waitUntilFinish();
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized EvaluationContext translatePipeline(@UnknownKeyFor @NonNull @Initialized SparkSession sparkSession, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"beam_fn_api")) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary((Pipeline)pipeline);
        }
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)this.options, (String)"disable_projection_pushdown")) {
            ProjectionPushdownOptimizer.optimize((Pipeline)pipeline);
        }
        PipelineTranslator.replaceTransforms(pipeline, this.options);
        PipelineTranslatorBatch pipelineTranslator = new PipelineTranslatorBatch();
        return pipelineTranslator.translate(pipeline, sparkSession, this.options);
    }

    private void registerMetricsSource(@UnknownKeyFor @NonNull @Initialized String appName, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics) {
        MetricsSystem metricsSystem = SparkEnv$.MODULE$.get().metricsSystem();
        SparkBeamMetricSource metricsSource = new SparkBeamMetricSource(appName + ".Beam", metrics);
        metricsSystem.removeSource((Source)metricsSource);
        metricsSystem.registerSource((Source)metricsSource);
    }

    private void startMetricsPusher(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineResult result, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics) {
        MetricsOptions metricsOpts = (MetricsOptions)this.options.as(MetricsOptions.class);
        Class metricsSink = metricsOpts.getMetricsSink();
        if (metricsSink != null && !metricsSink.equals(NoOpMetricsSink.class)) {
            new MetricsPusher(metrics.value(), metricsOpts, (PipelineResult)result).start();
        }
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @KeyForBottom @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?> runAsync(@UnknownKeyFor @NonNull @Initialized Runnable task) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("SparkStructuredStreamingRunner-thread").build();
        ExecutorService execService = Executors.newSingleThreadExecutor(factory);
        Future<?> future = execService.submit(task);
        execService.shutdown();
        return future;
    }

    @Nullable
    private static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Runnable sparkStopFn(@UnknownKeyFor @NonNull @Initialized SparkSession session, @UnknownKeyFor @NonNull @Initialized boolean isProvided) {
        return !isProvided ? () -> session.stop() : null;
    }
}

