/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class MutationExceededMaxSizeException
extends InvalidRequestException {
    public static final int PARTITION_MESSAGE_LIMIT = 1024;
    public final long mutationSize;

    MutationExceededMaxSizeException(IMutation mutation, int serializationVersion, long totalSize) {
        super(MutationExceededMaxSizeException.prepareMessage(mutation, serializationVersion, totalSize));
        this.mutationSize = totalSize;
    }

    private static String prepareMessage(IMutation mutation, int version, long totalSize) {
        List<String> topPartitions = mutation.getPartitionUpdates().stream().sorted((upd1, upd2) -> Long.compare(PartitionUpdate.serializer.serializedSize((PartitionUpdate)upd2, version), PartitionUpdate.serializer.serializedSize((PartitionUpdate)upd1, version))).map(upd -> String.format("%s.%s", upd.metadata().name, upd.metadata().partitionKeyType.getString(upd.partitionKey().getKey()))).collect(Collectors.toList());
        String topKeys = MutationExceededMaxSizeException.makeTopKeysString(topPartitions, 1024);
        return String.format("Rejected an oversized mutation (%d/%d) for keyspace: %s. Top keys are: %s", totalSize, IMutation.MAX_MUTATION_SIZE, mutation.getKeyspaceName(), topKeys);
    }

    @VisibleForTesting
    static String makeTopKeysString(List<String> keys, int maxLength) {
        ListIterator<String> iterator = keys.listIterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (stringBuilder.length() == 0) {
                stringBuilder.append(key);
                iterator.remove();
                continue;
            }
            if (stringBuilder.length() + key.length() + 2 > maxLength) break;
            stringBuilder.append(", ").append(key);
            iterator.remove();
        }
        if (keys.size() > 0) {
            stringBuilder.append(" and ").append(keys.size()).append(" more.");
        }
        return stringBuilder.toString();
    }
}

