/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.common.base.Preconditions;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

@BetaApi(value="Channel priming is not currently stable and might change in the future")
class BigtableChannelPrimer
implements ChannelPrimer {
    private static Logger LOG = Logger.getLogger(BigtableChannelPrimer.class.toString());
    private final EnhancedBigtableStubSettings settingsTemplate;

    static BigtableChannelPrimer create(Credentials credentials, String projectId, String instanceId, String appProfileId) {
        EnhancedBigtableStubSettings.Builder builder = (EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).setAppProfileId(appProfileId).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).setRefreshingChannel(false).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build());
        return new BigtableChannelPrimer(builder.build());
    }

    private BigtableChannelPrimer(EnhancedBigtableStubSettings settingsTemplate) {
        Preconditions.checkNotNull((Object)((Object)settingsTemplate), (Object)"settingsTemplate can't be null");
        this.settingsTemplate = settingsTemplate;
    }

    public void primeChannel(ManagedChannel managedChannel) {
        try {
            this.primeChannelUnsafe(managedChannel);
        }
        catch (IOException | RuntimeException e) {
            LOG.warning(String.format("Unexpected error while trying to prime a channel: %s", e.getMessage()));
        }
    }

    private void primeChannelUnsafe(ManagedChannel managedChannel) throws IOException {
        this.sendPrimeRequests(managedChannel);
    }

    private void sendPrimeRequests(ManagedChannel managedChannel) throws IOException {
        EnhancedBigtableStubSettings primingSettings = ((EnhancedBigtableStubSettings.Builder)this.settingsTemplate.toBuilder().setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)managedChannel)))).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create(primingSettings);){
            PingAndWarmRequest request = PingAndWarmRequest.newBuilder().setName(NameUtil.formatInstanceName(primingSettings.getProjectId(), primingSettings.getInstanceId())).setAppProfileId(primingSettings.getAppProfileId()).build();
            try {
                stub.pingAndWarmCallable().call((Object)request);
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    e = e.getCause();
                }
                LOG.warning(String.format("Failed to prime channel: %s", e));
            }
        }
    }
}

