/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sasinput.types;

import com.epam.parso.Column;
import com.epam.parso.ColumnFormat;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.InputStream;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transforms.sasinput.SasUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SasExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler
implements IExplorerFileTypeHandler {
    public SasExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    public void renderFile(Composite composite) {
        Text wText = new Text(composite, 770);
        PropsUi.setLook((Widget)wText, (int)1);
        wText.setEditable(false);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment(0, 0);
        fdText.bottom = new FormAttachment(100, 0);
        wText.setLayoutData((Object)fdText);
        StringBuilder message = new StringBuilder();
        message.append(this.explorerFile.getFilename()).append(Const.CR);
        message.append(Const.CR);
        try {
            try (InputStream inputStream = HopVfs.getInputStream((String)this.explorerFile.getFilename(), (IVariables)this.getVariables());){
                SasFileReaderImpl sasFileReader = new SasFileReaderImpl(inputStream);
                List columns = sasFileReader.getColumns();
                for (int c = 0; c < columns.size(); ++c) {
                    Column column = (Column)columns.get(c);
                    ColumnFormat format = column.getFormat();
                    int length = format.getWidth() == 0 ? -1 : format.getWidth();
                    int precision = format.getPrecision() == 0 ? -1 : format.getWidth();
                    message.append("Column ").append(c + 1).append(Const.CR);
                    message.append("   Name      : ").append(Const.NVL((String)column.getName(), (String)"")).append(Const.CR);
                    message.append("   Type      : ").append(SasUtil.getHopDataTypeDesc(column.getType())).append(Const.CR);
                    message.append("   Length    : ").append(length < 0 ? "" : Integer.toString(length)).append(Const.CR);
                    message.append("   Precision : ").append(precision < 0 ? "" : Integer.toString(precision)).append(Const.CR);
                }
            }
            catch (Exception e) {
                throw new HopException("Error reading from file: " + this.explorerFile.getFilename());
            }
        }
        catch (Exception e) {
            message.append(Const.CR).append(Const.getSimpleStackTrace((Throwable)e));
        }
        wText.setText(message.toString());
    }
}

