/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sqlfileoutput;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutputData;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutputMeta;

public class SQLFileOutput
extends BaseTransform<SQLFileOutputMeta, SQLFileOutputData> {
    private static final Class<?> PKG = SQLFileOutputMeta.class;
    String schemaTable;
    String schemaName;
    String tableName;

    public SQLFileOutput(TransformMeta transformMeta, SQLFileOutputMeta meta, SQLFileOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block19: {
            Object[] r = this.getRow();
            if (r == null) {
                this.closeFile();
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((SQLFileOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((SQLFileOutputMeta)this.meta).getFields(((SQLFileOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((SQLFileOutputData)this.data).insertRowMeta = this.getInputRowMeta().clone();
                if (((SQLFileOutputMeta)this.meta).getFile().isDoNotOpenNewFileInit() && !this.openNewFile()) {
                    this.logError("Couldn't open file [" + this.buildFilename() + "]");
                    this.setErrors(1L);
                    return false;
                }
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (r != null && this.getLinesOutput() > 0L && ((SQLFileOutputMeta)this.meta).getFile().getSplitEvery() > 0 && (this.getLinesOutput() + 1L) % (long)((SQLFileOutputMeta)this.meta).getFile().getSplitEvery() == 0L) {
                this.closeFile();
                if (r != null && !this.openNewFile()) {
                    this.logError("Unable to open new file (split #" + ((SQLFileOutputData)this.data).splitnr + "...");
                    this.setErrors(1L);
                    this.setOutputDone();
                    return false;
                }
            }
            try {
                if (this.getLinesOutput() == 0L) {
                    if (((SQLFileOutputMeta)this.meta).isCreateTable()) {
                        String crTable = ((SQLFileOutputData)this.data).db.getDDLCreationTable(this.schemaTable, ((SQLFileOutputData)this.data).insertRowMeta);
                        if (this.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"SQLFileOutputLog.OutputSQL", (String[])new String[]{crTable}));
                        }
                        ((SQLFileOutputData)this.data).writer.write(crTable + Const.CR + Const.CR);
                    }
                    if (((SQLFileOutputMeta)this.meta).isTruncateTable()) {
                        String truncatetable = ((SQLFileOutputData)this.data).db.getDDLTruncateTable(this.schemaName, this.tableName + ";" + Const.CR + Const.CR);
                        ((SQLFileOutputData)this.data).writer.write(truncatetable);
                    }
                }
            }
            catch (Exception e) {
                throw new HopTransformException(e.getMessage());
            }
            try {
                String sql = ((SQLFileOutputData)this.data).db.getSqlOutput(this.schemaName, this.tableName, ((SQLFileOutputData)this.data).insertRowMeta, r, ((SQLFileOutputMeta)this.meta).getDateFormat()) + ";";
                if (((SQLFileOutputMeta)this.meta).isStartNewLine()) {
                    sql = sql + Const.CR;
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"SQLFileOutputLog.OutputSQL", (String[])new String[]{sql}));
                }
                try {
                    ((SQLFileOutputData)this.data).writer.write(sql.toCharArray());
                }
                catch (Exception e) {
                    throw new HopTransformException(e.getMessage());
                }
                this.putRow(((SQLFileOutputData)this.data).outputRowMeta, r);
                this.incrementLinesOutput();
                if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
                    this.logBasic("linenr " + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(((SQLFileOutputData)this.data).outputRowMeta, r, 1L, errorMessage, null, "SFO001");
                r = null;
            }
        }
        return true;
    }

    public String buildFilename() {
        return ((SQLFileOutputMeta)this.meta).buildFilename((IVariables)this, this.resolve(((SQLFileOutputMeta)this.meta).getFile().getFileName()), this.getCopy(), ((SQLFileOutputData)this.data).splitnr);
    }

    public boolean openNewFile() {
        boolean retval = false;
        ((SQLFileOutputData)this.data).writer = null;
        try {
            OutputStream fos;
            String filename = this.buildFilename();
            if (((SQLFileOutputMeta)this.meta).isAddToResult()) {
                ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filename, (IVariables)this.variables), this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment("This file was created with a text file output transform");
                this.addResultFile(resultFile);
            }
            if (this.isDetailed()) {
                this.logDetailed("Opening output stream in nocompress mode");
            }
            OutputStream outputStream = fos = HopVfs.getOutputStream((String)filename, (boolean)((SQLFileOutputMeta)this.meta).getFile().isFileAppended(), (IVariables)this.variables);
            if (this.isDetailed()) {
                this.logDetailed("Opening output stream in default encoding");
            }
            ((SQLFileOutputData)this.data).writer = new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
            if (!Utils.isEmpty((CharSequence)((SQLFileOutputMeta)this.meta).getEncoding())) {
                if (this.isBasic()) {
                    this.logDetailed("Opening output stream in encoding: " + ((SQLFileOutputMeta)this.meta).getEncoding());
                }
                ((SQLFileOutputData)this.data).writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream, 5000), this.resolve(((SQLFileOutputMeta)this.meta).getEncoding()));
            } else {
                if (this.isBasic()) {
                    this.logDetailed("Opening output stream in default encoding");
                }
                ((SQLFileOutputData)this.data).writer = new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
            }
            if (this.isDetailed()) {
                this.logDetailed("Opened new file with name [" + filename + "]");
            }
            ++((SQLFileOutputData)this.data).splitnr;
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file : " + e.toString());
        }
        return retval;
    }

    private boolean closeFile() {
        boolean retval = false;
        try {
            if (((SQLFileOutputData)this.data).writer != null) {
                if (this.isDebug()) {
                    this.logDebug("Closing output stream");
                }
                ((SQLFileOutputData)this.data).writer.close();
                if (this.isDebug()) {
                    this.logDebug("Closed output stream");
                }
                ((SQLFileOutputData)this.data).writer = null;
            }
            if (((SQLFileOutputData)this.data).fos != null) {
                if (this.isDebug()) {
                    this.logDebug("Closing normal file ..");
                }
                ((SQLFileOutputData)this.data).fos.close();
                ((SQLFileOutputData)this.data).fos = null;
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (super.init()) {
            try {
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((SQLFileOutputMeta)this.meta).getConnection(), this.variables);
                if (databaseMeta == null) {
                    throw new HopTransformException("The connection is not defined (empty)");
                }
                if (databaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"SQLFileOutput.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((SQLFileOutputData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
                this.logBasic("Connected to database [" + ((SQLFileOutputMeta)this.meta).getConnection() + "]");
                if (((SQLFileOutputMeta)this.meta).getFile().isCreateParentFolder()) {
                    FileObject parentfolder = null;
                    try {
                        String filename = this.resolve(((SQLFileOutputMeta)this.meta).getFile().getFileName());
                        parentfolder = HopVfs.getFileObject((String)filename, (IVariables)this.variables).getParent();
                        if (!parentfolder.exists()) {
                            this.logBasic("Folder parent", new Object[]{"Folder parent " + String.valueOf(parentfolder.getName()) + " does not exist !"});
                            parentfolder.createFolder();
                            this.logBasic("Folder parent", new Object[]{"Folder parent was created."});
                        }
                    }
                    catch (Exception e) {
                        this.logError("Couldn't created parent folder " + String.valueOf(parentfolder.getName()));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    finally {
                        if (parentfolder != null) {
                            try {
                                parentfolder.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!((SQLFileOutputMeta)this.meta).getFile().isDoNotOpenNewFileInit() && !this.openNewFile()) {
                    this.logError("Couldn't open file [" + this.buildFilename() + "]");
                    this.setErrors(1L);
                    this.stopAll();
                }
                this.tableName = this.resolve(((SQLFileOutputMeta)this.meta).getTableName());
                this.schemaName = this.resolve(((SQLFileOutputMeta)this.meta).getSchemaName());
                if (Utils.isEmpty((CharSequence)this.tableName)) {
                    throw new HopTransformException("The tablename is not defined (empty)");
                }
                this.schemaTable = ((SQLFileOutputData)this.data).db.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, this.schemaName, this.tableName);
            }
            catch (Exception e) {
                this.logError("An error occurred intialising this transform: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
            return true;
        }
        return false;
    }
}

