/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pipelineexecutor;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.ISubPipelineAwareMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutor;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorData;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorParameters;
import org.apache.hop.pipeline.transforms.pipelineexecutor.PipelineExecutorResultRows;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

@Transform(id="PipelineExecutor", image="ui/images/pipelineexecutor.svg", name="i18n::PipelineExecutor.Name", description="i18n::PipelineExecutor.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/pipeline-executor.html", keywords={"i18n::PipelineExecutorMeta.keyword"}, actionTransformTypes={ActionTransformType.HOP_FILE, ActionTransformType.HOP_PIPELINE})
public class PipelineExecutorMeta
extends TransformWithMappingMeta<PipelineExecutor, PipelineExecutorData>
implements ISubPipelineAwareMeta {
    private static final Class<?> PKG = PipelineExecutorMeta.class;
    @HopMetadataProperty(key="run_configuration")
    private String runConfigurationName;
    @HopMetadataProperty(key="filenameInField")
    private boolean filenameInField;
    @HopMetadataProperty(key="filenameField")
    private String filenameField;
    @HopMetadataProperty(key="group_size")
    private String groupSize;
    @HopMetadataProperty(key="group_field")
    private String groupField;
    @HopMetadataProperty(key="group_time")
    private String groupTime;
    @HopMetadataProperty(key="variable_mapping", groupKey="parameters")
    private List<PipelineExecutorParameters> parameters;
    @HopMetadataProperty(key="inherit_all_vars")
    private boolean inheritingAllVariables;
    @HopMetadataProperty(key="execution_result_target_transform")
    private String executionResultTargetTransform;
    private TransformMeta executionResultTargetTransformMeta;
    @HopMetadataProperty(key="execution_time_field")
    private String executionTimeField;
    @HopMetadataProperty(key="execution_result_field")
    private String executionResultField;
    @HopMetadataProperty(key="execution_errors_field")
    private String executionNrErrorsField;
    @HopMetadataProperty(key="execution_lines_read_field")
    private String executionLinesReadField;
    @HopMetadataProperty(key="execution_lines_written_field")
    private String executionLinesWrittenField;
    @HopMetadataProperty(key="execution_lines_input_field")
    private String executionLinesInputField;
    @HopMetadataProperty(key="execution_lines_output_field")
    private String executionLinesOutputField;
    @HopMetadataProperty(key="execution_lines_rejected_field")
    private String executionLinesRejectedField;
    @HopMetadataProperty(key="execution_lines_updated_field")
    private String executionLinesUpdatedField;
    @HopMetadataProperty(key="execution_lines_deleted_field")
    private String executionLinesDeletedField;
    @HopMetadataProperty(key="execution_files_retrieved_field")
    private String executionFilesRetrievedField;
    @HopMetadataProperty(key="execution_exit_status_field")
    private String executionExitStatusField;
    @HopMetadataProperty(key="execution_log_text_field")
    private String executionLogTextField;
    @HopMetadataProperty(key="execution_log_channelid_field")
    private String executionLogChannelIdField;
    @HopMetadataProperty(key="result_rows_target_transform")
    private String outputRowsSourceTransform;
    private TransformMeta outputRowsSourceTransformMeta;
    @HopMetadataProperty(key="result_rows_field", inlineListTags={"name", "type", "length", "precision"})
    private List<PipelineExecutorResultRows> resultRows;
    @HopMetadataProperty(key="result_files_target_transform")
    private String resultFilesTargetTransform;
    private TransformMeta resultFilesTargetTransformMeta;
    @HopMetadataProperty(key="result_files_file_name_field")
    private String resultFilesFileNameField;
    @HopMetadataProperty(key="executors_output_transform")
    private String executorsOutputTransform;
    private TransformMeta executorsOutputTransformMeta;
    private IHopMetadataProvider metadataProvider;

    @Deprecated(since="2.13")
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        try {
            String value = XmlHandler.getTagValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"parameters"), (String)"inherit_all_vars");
            if (value != null) {
                this.setInheritingAllVariables("Y".equalsIgnoreCase(value));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.Exception.ErrorLoadingPipelineExecutorDetailsFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.parameters = new ArrayList<PipelineExecutorParameters>();
        this.resultRows = new ArrayList<PipelineExecutorResultRows>();
        this.filenameInField = false;
        this.groupSize = "1";
        this.groupField = "";
        this.groupTime = "";
        this.executionTimeField = "ExecutionTime";
        this.executionResultField = "ExecutionResult";
        this.executionNrErrorsField = "ExecutionNrErrors";
        this.executionLinesReadField = "ExecutionLinesRead";
        this.executionLinesWrittenField = "ExecutionLinesWritten";
        this.executionLinesInputField = "ExecutionLinesInput";
        this.executionLinesOutputField = "ExecutionLinesOutput";
        this.executionLinesRejectedField = "ExecutionLinesRejected";
        this.executionLinesUpdatedField = "ExecutionLinesUpdated";
        this.executionLinesDeletedField = "ExecutionLinesDeleted";
        this.executionFilesRetrievedField = "ExecutionFilesRetrieved";
        this.executionExitStatusField = "ExecutionExitStatus";
        this.executionLogTextField = "ExecutionLogText";
        this.executionLogChannelIdField = "ExecutionLogChannelId";
        this.resultFilesFileNameField = "FileName";
    }

    void prepareExecutionResultsFields(IRowMeta row, TransformMeta nextTransform) throws HopTransformException {
        if (nextTransform != null && this.executionResultTargetTransformMeta != null) {
            this.addFieldToRow(row, this.executionTimeField, 5, 15, 0);
            this.addFieldToRow(row, this.executionResultField, 4);
            this.addFieldToRow(row, this.executionNrErrorsField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesReadField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesWrittenField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesInputField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesOutputField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesRejectedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesUpdatedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionLinesDeletedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionFilesRetrievedField, 5, 9, 0);
            this.addFieldToRow(row, this.executionExitStatusField, 5, 3, 0);
            this.addFieldToRow(row, this.executionLogTextField, 2);
            this.addFieldToRow(row, this.executionLogChannelIdField, 2, 50, 0);
        }
    }

    protected void addFieldToRow(IRowMeta row, String fieldName, int type) throws HopTransformException {
        this.addFieldToRow(row, fieldName, type, -1, -1);
    }

    protected void addFieldToRow(IRowMeta row, String fieldName, int type, int length, int precision) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)fieldName)) {
            try {
                IValueMeta value = ValueMetaFactory.createValueMeta((String)fieldName, (int)type, (int)length, (int)precision);
                value.setOrigin(this.getParentTransformMeta().getName());
                row.addValueMeta(value);
            }
            catch (HopPluginException e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ValueMetaInterfaceCreation", (String[])new String[]{fieldName}), (Throwable)e);
            }
        }
    }

    void prepareExecutionResultsFileFields(IRowMeta row, TransformMeta nextTransform) throws HopTransformException {
        if (nextTransform != null && this.resultFilesTargetTransformMeta != null && nextTransform.equals((Object)this.resultFilesTargetTransformMeta)) {
            this.addFieldToRow(row, this.resultFilesFileNameField, 2);
        }
    }

    void prepareResultsRowsFields(IRowMeta row) throws HopTransformException {
        for (PipelineExecutorResultRows pipelineExecutorResultRows : this.resultRows) {
            this.addFieldToRow(row, pipelineExecutorResultRows.getName(), ValueMetaFactory.getIdForValueMeta((String)pipelineExecutorResultRows.getType()), pipelineExecutorResultRows.getLength(), pipelineExecutorResultRows.getPrecision());
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (nextTransform != null) {
            if (nextTransform.equals((Object)this.executionResultTargetTransformMeta)) {
                inputRowMeta.clear();
                this.prepareExecutionResultsFields(inputRowMeta, nextTransform);
            } else if (nextTransform.equals((Object)this.resultFilesTargetTransformMeta)) {
                inputRowMeta.clear();
                this.prepareExecutionResultsFileFields(inputRowMeta, nextTransform);
            } else if (nextTransform.equals((Object)this.outputRowsSourceTransformMeta)) {
                inputRowMeta.clear();
                this.prepareResultsRowsFields(inputRowMeta);
            }
        }
    }

    public String[] getInfoTransforms() {
        String[] infoTransforms = this.getTransformIOMeta().getInfoTransformNames();
        return infoTransforms.length == 0 ? null : infoTransforms;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.TransformReceivingFieldsFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = variables.resolve(this.filename);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        if (StringUtils.isNotEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        references.add(reference);
        return references;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, true, false, true, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.executionResultTargetTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ResultStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.outputRowsSourceTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ResultRowsStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.resultFilesTargetTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ResultFilesStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.executorsOutputTransformMeta, BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ExecutorOutputStream.Description", (String[])new String[0]), StreamIcon.OUTPUT, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void handleStreamSelection(IStream stream) {
        List targets = this.getTransformIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        TransformMeta transform = ((IStream)targets.get(index)).getTransformMeta();
        switch (index) {
            case 0: {
                this.setExecutionResultTargetTransformMeta(transform);
                break;
            }
            case 1: {
                this.setOutputRowsSourceTransformMeta(transform);
                break;
            }
            case 2: {
                this.setResultFilesTargetTransformMeta(transform);
                break;
            }
            case 3: {
                this.setExecutorsOutputTransformMeta(transform);
                break;
            }
        }
    }

    public void resetTransformIoMeta() {
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.executionResultTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.executionResultTargetTransform);
        this.outputRowsSourceTransformMeta = TransformMeta.findTransform(transforms, (String)this.outputRowsSourceTransform);
        this.resultFilesTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.resultFilesTargetTransform);
        this.executorsOutputTransformMeta = TransformMeta.findTransform(transforms, (String)this.executorsOutputTransform);
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"PipelineExecutorMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isPipelineDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isPipelineDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return PipelineExecutorMeta.loadMappingMeta((TransformWithMappingMeta)this, (IHopMetadataProvider)metadataProvider, (IVariables)variables);
    }

    public boolean cleanAfterHopFromRemove() {
        this.setExecutionResultTargetTransformMeta(null);
        this.setOutputRowsSourceTransformMeta(null);
        this.setResultFilesTargetTransformMeta(null);
        this.setExecutorsOutputTransformMeta(null);
        return true;
    }

    public boolean cleanAfterHopFromRemove(TransformMeta toTransform) {
        if (null == toTransform || null == toTransform.getName()) {
            return false;
        }
        boolean hasChanged = false;
        String toTransformName = toTransform.getName();
        if (this.getExecutionResultTargetTransformMeta() != null && toTransformName.equals(this.getExecutionResultTargetTransformMeta().getName())) {
            this.setExecutionResultTargetTransformMeta(null);
            hasChanged = true;
        } else if (this.getOutputRowsSourceTransformMeta() != null && toTransformName.equals(this.getOutputRowsSourceTransformMeta().getName())) {
            this.setOutputRowsSourceTransformMeta(null);
            hasChanged = true;
        } else if (this.getResultFilesTargetTransformMeta() != null && toTransformName.equals(this.getResultFilesTargetTransformMeta().getName())) {
            this.setResultFilesTargetTransformMeta(null);
            hasChanged = true;
        } else if (this.getExecutorsOutputTransformMeta() != null && toTransformName.equals(this.getExecutorsOutputTransformMeta().getName())) {
            this.setExecutorsOutputTransformMeta(null);
            hasChanged = true;
        }
        return hasChanged;
    }

    @Generated
    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    @Generated
    public boolean isFilenameInField() {
        return this.filenameInField;
    }

    @Generated
    public String getFilenameField() {
        return this.filenameField;
    }

    @Generated
    public String getGroupSize() {
        return this.groupSize;
    }

    @Generated
    public String getGroupField() {
        return this.groupField;
    }

    @Generated
    public String getGroupTime() {
        return this.groupTime;
    }

    @Generated
    public List<PipelineExecutorParameters> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean isInheritingAllVariables() {
        return this.inheritingAllVariables;
    }

    @Generated
    public String getExecutionResultTargetTransform() {
        return this.executionResultTargetTransform;
    }

    @Generated
    public TransformMeta getExecutionResultTargetTransformMeta() {
        return this.executionResultTargetTransformMeta;
    }

    @Generated
    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    @Generated
    public String getExecutionResultField() {
        return this.executionResultField;
    }

    @Generated
    public String getExecutionNrErrorsField() {
        return this.executionNrErrorsField;
    }

    @Generated
    public String getExecutionLinesReadField() {
        return this.executionLinesReadField;
    }

    @Generated
    public String getExecutionLinesWrittenField() {
        return this.executionLinesWrittenField;
    }

    @Generated
    public String getExecutionLinesInputField() {
        return this.executionLinesInputField;
    }

    @Generated
    public String getExecutionLinesOutputField() {
        return this.executionLinesOutputField;
    }

    @Generated
    public String getExecutionLinesRejectedField() {
        return this.executionLinesRejectedField;
    }

    @Generated
    public String getExecutionLinesUpdatedField() {
        return this.executionLinesUpdatedField;
    }

    @Generated
    public String getExecutionLinesDeletedField() {
        return this.executionLinesDeletedField;
    }

    @Generated
    public String getExecutionFilesRetrievedField() {
        return this.executionFilesRetrievedField;
    }

    @Generated
    public String getExecutionExitStatusField() {
        return this.executionExitStatusField;
    }

    @Generated
    public String getExecutionLogTextField() {
        return this.executionLogTextField;
    }

    @Generated
    public String getExecutionLogChannelIdField() {
        return this.executionLogChannelIdField;
    }

    @Generated
    public String getOutputRowsSourceTransform() {
        return this.outputRowsSourceTransform;
    }

    @Generated
    public TransformMeta getOutputRowsSourceTransformMeta() {
        return this.outputRowsSourceTransformMeta;
    }

    @Generated
    public List<PipelineExecutorResultRows> getResultRows() {
        return this.resultRows;
    }

    @Generated
    public String getResultFilesTargetTransform() {
        return this.resultFilesTargetTransform;
    }

    @Generated
    public TransformMeta getResultFilesTargetTransformMeta() {
        return this.resultFilesTargetTransformMeta;
    }

    @Generated
    public String getResultFilesFileNameField() {
        return this.resultFilesFileNameField;
    }

    @Generated
    public String getExecutorsOutputTransform() {
        return this.executorsOutputTransform;
    }

    @Generated
    public TransformMeta getExecutorsOutputTransformMeta() {
        return this.executorsOutputTransformMeta;
    }

    @Generated
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    @Generated
    public void setFilenameInField(boolean filenameInField) {
        this.filenameInField = filenameInField;
    }

    @Generated
    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    @Generated
    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    @Generated
    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    @Generated
    public void setGroupTime(String groupTime) {
        this.groupTime = groupTime;
    }

    @Generated
    public void setParameters(List<PipelineExecutorParameters> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setInheritingAllVariables(boolean inheritingAllVariables) {
        this.inheritingAllVariables = inheritingAllVariables;
    }

    @Generated
    public void setExecutionResultTargetTransform(String executionResultTargetTransform) {
        this.executionResultTargetTransform = executionResultTargetTransform;
    }

    @Generated
    public void setExecutionResultTargetTransformMeta(TransformMeta executionResultTargetTransformMeta) {
        this.executionResultTargetTransformMeta = executionResultTargetTransformMeta;
    }

    @Generated
    public void setExecutionTimeField(String executionTimeField) {
        this.executionTimeField = executionTimeField;
    }

    @Generated
    public void setExecutionResultField(String executionResultField) {
        this.executionResultField = executionResultField;
    }

    @Generated
    public void setExecutionNrErrorsField(String executionNrErrorsField) {
        this.executionNrErrorsField = executionNrErrorsField;
    }

    @Generated
    public void setExecutionLinesReadField(String executionLinesReadField) {
        this.executionLinesReadField = executionLinesReadField;
    }

    @Generated
    public void setExecutionLinesWrittenField(String executionLinesWrittenField) {
        this.executionLinesWrittenField = executionLinesWrittenField;
    }

    @Generated
    public void setExecutionLinesInputField(String executionLinesInputField) {
        this.executionLinesInputField = executionLinesInputField;
    }

    @Generated
    public void setExecutionLinesOutputField(String executionLinesOutputField) {
        this.executionLinesOutputField = executionLinesOutputField;
    }

    @Generated
    public void setExecutionLinesRejectedField(String executionLinesRejectedField) {
        this.executionLinesRejectedField = executionLinesRejectedField;
    }

    @Generated
    public void setExecutionLinesUpdatedField(String executionLinesUpdatedField) {
        this.executionLinesUpdatedField = executionLinesUpdatedField;
    }

    @Generated
    public void setExecutionLinesDeletedField(String executionLinesDeletedField) {
        this.executionLinesDeletedField = executionLinesDeletedField;
    }

    @Generated
    public void setExecutionFilesRetrievedField(String executionFilesRetrievedField) {
        this.executionFilesRetrievedField = executionFilesRetrievedField;
    }

    @Generated
    public void setExecutionExitStatusField(String executionExitStatusField) {
        this.executionExitStatusField = executionExitStatusField;
    }

    @Generated
    public void setExecutionLogTextField(String executionLogTextField) {
        this.executionLogTextField = executionLogTextField;
    }

    @Generated
    public void setExecutionLogChannelIdField(String executionLogChannelIdField) {
        this.executionLogChannelIdField = executionLogChannelIdField;
    }

    @Generated
    public void setOutputRowsSourceTransform(String outputRowsSourceTransform) {
        this.outputRowsSourceTransform = outputRowsSourceTransform;
    }

    @Generated
    public void setOutputRowsSourceTransformMeta(TransformMeta outputRowsSourceTransformMeta) {
        this.outputRowsSourceTransformMeta = outputRowsSourceTransformMeta;
    }

    @Generated
    public void setResultRows(List<PipelineExecutorResultRows> resultRows) {
        this.resultRows = resultRows;
    }

    @Generated
    public void setResultFilesTargetTransform(String resultFilesTargetTransform) {
        this.resultFilesTargetTransform = resultFilesTargetTransform;
    }

    @Generated
    public void setResultFilesTargetTransformMeta(TransformMeta resultFilesTargetTransformMeta) {
        this.resultFilesTargetTransformMeta = resultFilesTargetTransformMeta;
    }

    @Generated
    public void setResultFilesFileNameField(String resultFilesFileNameField) {
        this.resultFilesFileNameField = resultFilesFileNameField;
    }

    @Generated
    public void setExecutorsOutputTransform(String executorsOutputTransform) {
        this.executorsOutputTransform = executorsOutputTransform;
    }

    @Generated
    public void setExecutorsOutputTransformMeta(TransformMeta executorsOutputTransformMeta) {
        this.executorsOutputTransformMeta = executorsOutputTransformMeta;
    }

    @Generated
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

