/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mergerows;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.mergerows.MergeRowsData;
import org.apache.hop.pipeline.transforms.mergerows.MergeRowsMeta;

public class MergeRows
extends BaseTransform<MergeRowsMeta, MergeRowsData> {
    private static final Class<?> PKG = MergeRowsMeta.class;
    private static final String VALUE_IDENTICAL = "identical";
    private static final String VALUE_CHANGED = "changed";
    private static final String VALUE_NEW = "new";
    private static final String VALUE_DELETED = "deleted";

    public MergeRows(TransformMeta transformMeta, MergeRowsMeta meta, MergeRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        int outputIndex;
        Object[] outputRow;
        if (this.first) {
            int i;
            this.first = false;
            List infoStreams = ((MergeRowsMeta)this.meta).getTransformIOMeta().getInfoStreams();
            ((MergeRowsData)this.data).oneRowSet = this.findInputRowSet(((IStream)infoStreams.get(0)).getTransformName());
            ((MergeRowsData)this.data).twoRowSet = this.findInputRowSet(((IStream)infoStreams.get(1)).getTransformName());
            ((MergeRowsData)this.data).one = this.getRowFrom(((MergeRowsData)this.data).oneRowSet);
            ((MergeRowsData)this.data).two = this.getRowFrom(((MergeRowsData)this.data).twoRowSet);
            try {
                MergeRows.checkInputLayoutValid(((MergeRowsData)this.data).oneRowSet.getRowMeta(), ((MergeRowsData)this.data).twoRowSet.getRowMeta());
            }
            catch (HopRowException e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MergeRows.Exception.InvalidLayoutDetected", (String[])new String[0]), (Throwable)e);
            }
            if (((MergeRowsData)this.data).one != null) {
                ((MergeRowsData)this.data).keyNrs = new int[((MergeRowsMeta)this.meta).getKeyFields().length];
                for (i = 0; i < ((MergeRowsData)this.data).keyNrs.length; ++i) {
                    ((MergeRowsData)this.data).keyNrs[i] = ((MergeRowsData)this.data).oneRowSet.getRowMeta().indexOfValue(((MergeRowsMeta)this.meta).getKeyFields()[i]);
                    if (((MergeRowsData)this.data).keyNrs[i] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MergeRows.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{((MergeRowsMeta)this.meta).getKeyFields()[i]});
                    this.logError(message);
                    throw new HopTransformException(message);
                }
            }
            if (((MergeRowsData)this.data).two != null) {
                ((MergeRowsData)this.data).valueNrs = new int[((MergeRowsMeta)this.meta).getValueFields().length];
                for (i = 0; i < ((MergeRowsData)this.data).valueNrs.length; ++i) {
                    ((MergeRowsData)this.data).valueNrs[i] = ((MergeRowsData)this.data).twoRowSet.getRowMeta().indexOfValue(((MergeRowsMeta)this.meta).getValueFields()[i]);
                    if (((MergeRowsData)this.data).valueNrs[i] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MergeRows.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{((MergeRowsMeta)this.meta).getValueFields()[i]});
                    this.logError(message);
                    throw new HopTransformException(message);
                }
            }
        }
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeRows.Log.DataInfo", (String[])new String[]{Arrays.toString(((MergeRowsData)this.data).one)}) + Arrays.toString(((MergeRowsData)this.data).two));
        }
        if (((MergeRowsData)this.data).one == null && ((MergeRowsData)this.data).two == null) {
            this.setOutputDone();
            return false;
        }
        if (((MergeRowsData)this.data).outputRowMeta == null) {
            ((MergeRowsData)this.data).outputRowMeta = new RowMeta();
            if (((MergeRowsData)this.data).one != null) {
                ((MergeRowsMeta)this.meta).getFields(((MergeRowsData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((MergeRowsData)this.data).oneRowSet.getRowMeta()}, null, (IVariables)this, this.metadataProvider);
            } else {
                ((MergeRowsMeta)this.meta).getFields(((MergeRowsData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((MergeRowsData)this.data).twoRowSet.getRowMeta()}, null, (IVariables)this, this.metadataProvider);
            }
        }
        String flagField = null;
        if (((MergeRowsData)this.data).one == null && ((MergeRowsData)this.data).two != null) {
            outputRow = ((MergeRowsData)this.data).two;
            outputIndex = ((MergeRowsData)this.data).twoRowSet.getRowMeta().size();
            flagField = VALUE_NEW;
            ((MergeRowsData)this.data).two = this.getRowFrom(((MergeRowsData)this.data).twoRowSet);
        } else if (((MergeRowsData)this.data).one != null && ((MergeRowsData)this.data).two == null) {
            outputRow = ((MergeRowsData)this.data).one;
            outputIndex = ((MergeRowsData)this.data).oneRowSet.getRowMeta().size();
            flagField = VALUE_DELETED;
            ((MergeRowsData)this.data).one = this.getRowFrom(((MergeRowsData)this.data).oneRowSet);
        } else {
            int compare = ((MergeRowsData)this.data).oneRowSet.getRowMeta().compare(((MergeRowsData)this.data).one, ((MergeRowsData)this.data).two, ((MergeRowsData)this.data).keyNrs);
            if (compare == 0) {
                int compareValues = ((MergeRowsData)this.data).oneRowSet.getRowMeta().compare(((MergeRowsData)this.data).one, ((MergeRowsData)this.data).two, ((MergeRowsData)this.data).valueNrs);
                if (compareValues == 0) {
                    outputRow = ((MergeRowsData)this.data).two;
                    outputIndex = ((MergeRowsData)this.data).twoRowSet.getRowMeta().size();
                    flagField = VALUE_IDENTICAL;
                } else {
                    outputRow = ((MergeRowsData)this.data).two;
                    outputIndex = ((MergeRowsData)this.data).twoRowSet.getRowMeta().size();
                    flagField = VALUE_CHANGED;
                }
                ((MergeRowsData)this.data).one = this.getRowFrom(((MergeRowsData)this.data).oneRowSet);
                ((MergeRowsData)this.data).two = this.getRowFrom(((MergeRowsData)this.data).twoRowSet);
            } else if (compare < 0) {
                outputRow = ((MergeRowsData)this.data).one;
                outputIndex = ((MergeRowsData)this.data).oneRowSet.getRowMeta().size();
                flagField = VALUE_DELETED;
                ((MergeRowsData)this.data).one = this.getRowFrom(((MergeRowsData)this.data).oneRowSet);
            } else {
                outputRow = ((MergeRowsData)this.data).two;
                outputIndex = ((MergeRowsData)this.data).twoRowSet.getRowMeta().size();
                flagField = VALUE_NEW;
                ((MergeRowsData)this.data).two = this.getRowFrom(((MergeRowsData)this.data).twoRowSet);
            }
        }
        this.putRow(((MergeRowsData)this.data).outputRowMeta, RowDataUtil.addValueData((Object[])outputRow, (int)outputIndex, (Object)flagField));
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MergeRows.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            List infoStreams = ((MergeRowsMeta)this.meta).getTransformIOMeta().getInfoStreams();
            if (((IStream)infoStreams.get(0)).getTransformMeta() != null ^ ((IStream)infoStreams.get(1)).getTransformMeta() != null) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeRows.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
            } else {
                return true;
            }
        }
        return false;
    }

    static void checkInputLayoutValid(IRowMeta referenceRowMeta, IRowMeta compareRowMeta) throws HopRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseTransform.safeModeChecking((IRowMeta)referenceRowMeta, (IRowMeta)compareRowMeta);
        }
    }
}

