/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQueryHelper;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaRetrievalException;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryQuerySourceDef
implements BigQuerySourceDef {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryQuerySourceDef.class);
    private final BigQueryServices bqServices;
    private final ValueProvider<String> query;
    private final Boolean flattenResults;
    private final Boolean useLegacySql;
    private final BigQueryIO.TypedRead.QueryPriority priority;
    private final String location;
    private final String tempDatasetId;
    private final String kmsKey;
    private transient AtomicReference<@Nullable JobStatistics> dryRunJobStats;

    static BigQueryQuerySourceDef create(BigQueryServices bqServices, ValueProvider<String> query, Boolean flattenResults, Boolean useLegacySql, BigQueryIO.TypedRead.QueryPriority priority, String location, String tempDatasetId, String kmsKey) {
        return new BigQueryQuerySourceDef(bqServices, query, flattenResults, useLegacySql, priority, location, tempDatasetId, kmsKey);
    }

    private BigQueryQuerySourceDef(BigQueryServices bqServices, ValueProvider<String> query, Boolean flattenResults, Boolean useLegacySql, BigQueryIO.TypedRead.QueryPriority priority, String location, String tempDatasetId, String kmsKey) {
        this.query = (ValueProvider)Preconditions.checkNotNull(query, (Object)"query");
        this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
        this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
        this.bqServices = bqServices;
        this.priority = priority;
        this.location = location;
        this.tempDatasetId = tempDatasetId;
        this.kmsKey = kmsKey;
        this.dryRunJobStats = new AtomicReference();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dryRunJobStats = new AtomicReference();
    }

    long getEstimatedSizeBytes(BigQueryOptions bqOptions) throws Exception {
        return BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, bqOptions, this.dryRunJobStats, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.location).getQuery().getTotalBytesProcessed();
    }

    TableReference getTableReference(BigQueryOptions bqOptions, String stepUuid) throws IOException, InterruptedException {
        return BigQueryQueryHelper.executeQuery(this.bqServices, bqOptions, this.dryRunJobStats, stepUuid, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.priority, this.location, this.tempDatasetId, this.kmsKey);
    }

    void cleanupTempResource(BigQueryOptions bqOptions, String stepUuid) throws Exception {
        Optional<String> queryTempDatasetOpt = Optional.ofNullable(this.tempDatasetId);
        TableReference tableToRemove = BigQueryResourceNaming.createTempTableReference(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject(), BigQueryResourceNaming.createJobIdPrefix(bqOptions.getJobName(), stepUuid, BigQueryResourceNaming.JobType.QUERY), queryTempDatasetOpt);
        try (BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);){
            boolean datasetCreatedByBeam;
            LOG.info("Deleting temporary table with query results {}", (Object)tableToRemove);
            tableService.deleteTable(tableToRemove);
            boolean bl = datasetCreatedByBeam = !queryTempDatasetOpt.isPresent();
            if (datasetCreatedByBeam) {
                LOG.info("Deleting temporary dataset with query results {}", (Object)tableToRemove.getDatasetId());
                tableService.deleteDataset(tableToRemove.getProjectId(), tableToRemove.getDatasetId());
            }
        }
    }

    @Override
    public <T> BigQuerySourceBase<T> toSource(String stepUuid, Coder<T> coder, SerializableFunction<TableSchema, AvroSource.DatumReaderFactory<T>> readerFactory, boolean useAvroLogicalTypes) {
        return BigQueryQuerySource.create(stepUuid, this, this.bqServices, coder, readerFactory, useAvroLogicalTypes);
    }

    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    public Schema getBeamSchema(BigQueryOptions bqOptions) {
        try {
            JobStatistics stats = BigQueryQueryHelper.dryRunQueryIfNeeded(this.bqServices, bqOptions, this.dryRunJobStats, (String)this.query.get(), this.flattenResults, this.useLegacySql, this.location);
            TableSchema tableSchema = stats.getQuery().getSchema();
            return BigQueryUtils.fromTableSchema(tableSchema);
        }
        catch (IOException | InterruptedException | NullPointerException e) {
            throw new BigQuerySchemaRetrievalException("Exception while trying to retrieve schema of query", e);
        }
    }

    ValueProvider<String> getQuery() {
        return this.query;
    }
}

