/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.core.GraphUsage;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoConnectionUtils;
import org.apache.hop.neo4j.transforms.BaseNeoTransform;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputData;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputMeta;
import org.apache.hop.neo4j.transforms.output.OperationType;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.neo4j.driver.Result;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;

public class Neo4JOutput
extends BaseNeoTransform<Neo4JOutputMeta, Neo4JOutputData> {
    public Neo4JOutput(TransformMeta s, Neo4JOutputMeta meta, Neo4JOutputData data, int c, PipelineMeta t, Pipeline dis) {
        super(s, meta, data, c, t, dis);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((Neo4JOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((Neo4JOutputMeta)this.meta).getFields(((Neo4JOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((Neo4JOutputData)this.data).fieldNames = ((Neo4JOutputData)this.data).outputRowMeta.getFieldNames();
            ((Neo4JOutputData)this.data).fromNodePropIndexes = new int[((Neo4JOutputMeta)this.meta).getFromNodeProps().length];
            ((Neo4JOutputData)this.data).fromNodePropTypes = new GraphPropertyType[((Neo4JOutputMeta)this.meta).getFromNodeProps().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getFromNodeProps().length; ++i) {
                ((Neo4JOutputData)this.data).fromNodePropIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getFromNodeProps()[i]);
                if (((Neo4JOutputData)this.data).fromNodePropIndexes[i] < 0) {
                    throw new HopException("From node: Unable to find field '" + ((Neo4JOutputMeta)this.meta).getFromNodeProps()[i] + "' for property name '" + ((Neo4JOutputMeta)this.meta).getFromNodePropNames()[i] + "'");
                }
                ((Neo4JOutputData)this.data).fromNodePropTypes[i] = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getFromNodePropTypes()[i]);
            }
            ((Neo4JOutputData)this.data).fromNodeLabelIndexes = new int[((Neo4JOutputMeta)this.meta).getFromNodeLabels().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getFromNodeLabels().length; ++i) {
                ((Neo4JOutputData)this.data).fromNodeLabelIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getFromNodeLabels()[i]);
                if (((Neo4JOutputData)this.data).fromNodeLabelIndexes[i] >= 0 || !StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getFromNodeLabelValues()[i])) continue;
                throw new HopException("From node : please provide either a static label value or a field name to determine the label");
            }
            ((Neo4JOutputData)this.data).toNodePropIndexes = new int[((Neo4JOutputMeta)this.meta).getToNodeProps().length];
            ((Neo4JOutputData)this.data).toNodePropTypes = new GraphPropertyType[((Neo4JOutputMeta)this.meta).getToNodeProps().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getToNodeProps().length; ++i) {
                ((Neo4JOutputData)this.data).toNodePropIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getToNodeProps()[i]);
                ((Neo4JOutputData)this.data).toNodePropTypes[i] = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getToNodePropTypes()[i]);
            }
            ((Neo4JOutputData)this.data).toNodeLabelIndexes = new int[((Neo4JOutputMeta)this.meta).getToNodeLabels().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getToNodeLabels().length; ++i) {
                ((Neo4JOutputData)this.data).toNodeLabelIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getToNodeLabels()[i]);
                if (((Neo4JOutputData)this.data).toNodeLabelIndexes[i] >= 0 || !StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getToNodeLabelValues()[i])) continue;
                throw new HopException("To node : please provide either a static label value or a field name to determine the label");
            }
            ((Neo4JOutputData)this.data).relPropIndexes = new int[((Neo4JOutputMeta)this.meta).getRelProps().length];
            ((Neo4JOutputData)this.data).relPropTypes = new GraphPropertyType[((Neo4JOutputMeta)this.meta).getRelProps().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getRelProps().length; ++i) {
                ((Neo4JOutputData)this.data).relPropIndexes[i] = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getRelProps()[i]);
                ((Neo4JOutputData)this.data).relPropTypes[i] = GraphPropertyType.parseCode(((Neo4JOutputMeta)this.meta).getRelPropTypes()[i]);
            }
            ((Neo4JOutputData)this.data).relationshipIndex = ((Neo4JOutputData)this.data).outputRowMeta.indexOfValue(((Neo4JOutputMeta)this.meta).getRelationship());
            ((Neo4JOutputData)this.data).fromLabelValues = new String[((Neo4JOutputMeta)this.meta).getFromNodeLabelValues().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getFromNodeLabelValues().length; ++i) {
                ((Neo4JOutputData)this.data).fromLabelValues[i] = this.resolve(((Neo4JOutputMeta)this.meta).getFromNodeLabelValues()[i]);
            }
            ((Neo4JOutputData)this.data).toLabelValues = new String[((Neo4JOutputMeta)this.meta).getToNodeLabelValues().length];
            for (i = 0; i < ((Neo4JOutputMeta)this.meta).getToNodeLabelValues().length; ++i) {
                ((Neo4JOutputData)this.data).toLabelValues[i] = this.resolve(((Neo4JOutputMeta)this.meta).getToNodeLabelValues()[i]);
            }
            ((Neo4JOutputData)this.data).relationshipLabelValue = this.resolve(((Neo4JOutputMeta)this.meta).getRelationshipValue());
            ((Neo4JOutputData)this.data).unwindList = new ArrayList<Map<String, Object>>();
            ((Neo4JOutputData)this.data).dynamicFromLabels = this.determineDynamicLabels(((Neo4JOutputMeta)this.meta).getFromNodeLabels());
            ((Neo4JOutputData)this.data).dynamicToLabels = this.determineDynamicLabels(((Neo4JOutputMeta)this.meta).getToNodeLabels());
            ((Neo4JOutputData)this.data).dynamicRelLabel = StringUtils.isNotEmpty((String)((Neo4JOutputMeta)this.meta).getRelationship());
            ((Neo4JOutputData)this.data).previousFromLabelsClause = null;
            ((Neo4JOutputData)this.data).previousToLabelsClause = null;
            ((Neo4JOutputData)this.data).previousRelationshipLabel = null;
            ((Neo4JOutputData)this.data).fromOperationType = OperationType.MERGE;
            ((Neo4JOutputData)this.data).toOperationType = OperationType.MERGE;
            ((Neo4JOutputData)this.data).relOperationType = OperationType.MERGE;
            if (((Neo4JOutputMeta)this.meta).isUsingCreate()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.CREATE;
                ((Neo4JOutputData)this.data).toOperationType = OperationType.CREATE;
                ((Neo4JOutputData)this.data).relOperationType = OperationType.CREATE;
            }
            if (((Neo4JOutputMeta)this.meta).isOnlyCreatingRelationships()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.MATCH;
                ((Neo4JOutputData)this.data).toOperationType = OperationType.MATCH;
                ((Neo4JOutputData)this.data).relOperationType = OperationType.CREATE;
            }
            if (((Neo4JOutputMeta)this.meta).isReadOnlyFromNode()) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.MATCH;
            }
            if (((Neo4JOutputMeta)this.meta).isReadOnlyToNode()) {
                ((Neo4JOutputData)this.data).toOperationType = OperationType.MATCH;
            }
            if (((Neo4JOutputMeta)this.meta).getFromNodeLabels().length == 0 && ((Neo4JOutputMeta)this.meta).getFromNodeLabelValues().length == 0) {
                ((Neo4JOutputData)this.data).fromOperationType = OperationType.NONE;
            }
            if (((Neo4JOutputMeta)this.meta).getToNodeLabels().length == 0 && ((Neo4JOutputMeta)this.meta).getToNodeLabelValues().length == 0) {
                ((Neo4JOutputData)this.data).toOperationType = OperationType.NONE;
            }
            if (StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getRelationship()) && StringUtils.isEmpty((String)((Neo4JOutputMeta)this.meta).getRelationshipValue())) {
                ((Neo4JOutputData)this.data).relOperationType = OperationType.NONE;
            }
            if (((Neo4JOutputMeta)this.meta).isReturningGraph()) {
                this.log.logBasic("Writing to output graph field, not to Neo4j");
            } else {
                ((Neo4JOutputData)this.data).driver = ((Neo4JOutputData)this.data).neoConnection.getDriver(this.log, (IVariables)this);
                ((Neo4JOutputData)this.data).session = ((Neo4JOutputData)this.data).neoConnection.getSession(this.log, ((Neo4JOutputData)this.data).driver, (IVariables)this);
                if (((Neo4JOutputMeta)this.meta).isCreatingIndexes()) {
                    try {
                        this.createNodePropertyIndexes((Neo4JOutputMeta)this.meta, (Neo4JOutputData)this.data, this.getInputRowMeta(), row);
                    }
                    catch (HopException e) {
                        this.log.logError("Unable to create indexes", (Throwable)e);
                        return false;
                    }
                }
            }
            this.validateConfiguration();
        }
        if (((Neo4JOutputMeta)this.meta).isReturningGraph()) {
            this.outputGraphValue(this.getInputRowMeta(), row);
        } else {
            boolean changedLabel = this.calculateLabelsAndDetectChanges(row);
            if (changedLabel || (long)((Neo4JOutputData)this.data).unwindList.size() >= ((Neo4JOutputData)this.data).batchSize) {
                this.emptyUnwindList();
            }
            HashMap<String, Object> propsMap = new HashMap<String, Object>();
            if (((Neo4JOutputData)this.data).fromOperationType != OperationType.NONE) {
                this.addPropertiesToMap(propsMap, ((Neo4JOutputData)this.data).fromNodePropIndexes, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).fromNodePropTypes);
            }
            if (((Neo4JOutputData)this.data).toOperationType != OperationType.NONE) {
                this.addPropertiesToMap(propsMap, ((Neo4JOutputData)this.data).toNodePropIndexes, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).toNodePropTypes);
            }
            if (((Neo4JOutputData)this.data).relOperationType != OperationType.NONE) {
                this.addPropertiesToMap(propsMap, ((Neo4JOutputData)this.data).relPropIndexes, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).relPropTypes);
            }
            ((Neo4JOutputData)this.data).unwindList.add(propsMap);
            this.putRow(((Neo4JOutputData)this.data).outputRowMeta, row);
            ((Neo4JOutputData)this.data).previousFromLabelsClause = ((Neo4JOutputData)this.data).fromLabelsClause;
            ((Neo4JOutputData)this.data).previousToLabelsClause = ((Neo4JOutputData)this.data).toLabelsClause;
            ((Neo4JOutputData)this.data).previousRelationshipLabel = ((Neo4JOutputData)this.data).relationshipLabel;
        }
        return true;
    }

    private void validateConfiguration() throws HopException {
        boolean hasRelationship;
        boolean hasFromNode = ((Neo4JOutputMeta)this.meta).getFromNodeLabels().length > 0;
        boolean hasToNode = ((Neo4JOutputMeta)this.meta).getFromNodeLabels().length > 0;
        boolean bl = hasRelationship = StringUtils.isNotEmpty((String)((Neo4JOutputMeta)this.meta).getRelationship()) || StringUtils.isNotEmpty((String)((Neo4JOutputMeta)this.meta).getRelationshipValue());
        if (hasRelationship) {
            if (!hasFromNode || !hasToNode) {
                throw new HopException("Please specify both nodes to be able to update relationships");
            }
            boolean noFromKey = true;
            for (boolean key : ((Neo4JOutputMeta)this.meta).getFromNodePropPrimary()) {
                if (!key) continue;
                noFromKey = false;
                break;
            }
            if (noFromKey) {
                throw new HopException("Please specify at least one or more primary key properties in the 'from' node");
            }
            boolean noToKey = true;
            for (boolean key : ((Neo4JOutputMeta)this.meta).getToNodePropPrimary()) {
                if (!key) continue;
                noToKey = false;
                break;
            }
            if (noToKey) {
                throw new HopException("Please specify at least one or more primary key properties in the 'to' node");
            }
        }
    }

    private void addPropertiesToMap(Map<String, Object> rowMap, int[] nodePropIndexes, IRowMeta rowMeta, Object[] row, GraphPropertyType[] propertyTypes) throws HopValueException {
        for (int i = 0; i < nodePropIndexes.length; ++i) {
            IValueMeta valueMeta = rowMeta.getValueMeta(nodePropIndexes[i]);
            Object valueData = row[nodePropIndexes[i]];
            GraphPropertyType propertyType = propertyTypes[i];
            Object neoValue = propertyType.convertFromHop(valueMeta, valueData);
            String propName = "p" + nodePropIndexes[i];
            rowMap.put(propName, neoValue);
        }
    }

    private void emptyUnwindList() throws HopException {
        try {
            Map<String, List<Map<String, Object>>> properties = Collections.singletonMap("props", ((Neo4JOutputData)this.data).unwindList);
            StringBuilder cypher = new StringBuilder();
            cypher.append("UNWIND $props as pr ").append(Const.CR);
            String fromLabelClause = ((Neo4JOutputData)this.data).previousFromLabelsClause;
            String fromMatchClause = this.getMatchClause(((Neo4JOutputMeta)this.meta).getFromNodePropNames(), ((Neo4JOutputMeta)this.meta).getFromNodePropPrimary(), ((Neo4JOutputData)this.data).fromNodePropIndexes);
            switch (((Neo4JOutputData)this.data).fromOperationType) {
                case NONE: {
                    break;
                }
                case CREATE: {
                    cypher.append("CREATE( ").append(fromLabelClause).append(" ").append(fromMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("f", ((Neo4JOutputMeta)this.meta).getFromNodePropNames(), ((Neo4JOutputMeta)this.meta).getFromNodePropPrimary(), ((Neo4JOutputData)this.data).fromNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).fromLabels, GraphUsage.NODE_CREATE);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE( ").append(fromLabelClause).append(" ").append(fromMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("f", ((Neo4JOutputMeta)this.meta).getFromNodePropNames(), ((Neo4JOutputMeta)this.meta).getFromNodePropPrimary(), ((Neo4JOutputData)this.data).fromNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).fromLabels, GraphUsage.NODE_UPDATE);
                    break;
                }
                case MATCH: {
                    cypher.append("MATCH( ").append(fromLabelClause).append(" ").append(fromMatchClause).append(") ").append(Const.CR);
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_READ);
                    break;
                }
                default: {
                    throw new HopException("Unsupported operation type for the 'from' node: " + String.valueOf((Object)((Neo4JOutputData)this.data).fromOperationType));
                }
            }
            String toLabelsClause = ((Neo4JOutputData)this.data).previousToLabelsClause;
            String toMatchClause = this.getMatchClause(((Neo4JOutputMeta)this.meta).getToNodePropNames(), ((Neo4JOutputMeta)this.meta).getToNodePropPrimary(), ((Neo4JOutputData)this.data).toNodePropIndexes);
            switch (((Neo4JOutputData)this.data).toOperationType) {
                case NONE: {
                    break;
                }
                case CREATE: {
                    cypher.append("CREATE( ").append(toLabelsClause).append(" ").append(toMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("t", ((Neo4JOutputMeta)this.meta).getToNodePropNames(), ((Neo4JOutputMeta)this.meta).getToNodePropPrimary(), ((Neo4JOutputData)this.data).toNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_CREATE);
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE( ").append(toLabelsClause).append(" ").append(toMatchClause).append(") ").append(Const.CR);
                    String setClause = this.getSetClause("t", ((Neo4JOutputMeta)this.meta).getToNodePropNames(), ((Neo4JOutputMeta)this.meta).getToNodePropPrimary(), ((Neo4JOutputData)this.data).toNodePropIndexes);
                    if (StringUtils.isNotEmpty((String)setClause)) {
                        cypher.append(setClause).append(Const.CR);
                    }
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_UPDATE);
                    break;
                }
                case MATCH: {
                    cypher.append("MATCH( ").append(toLabelsClause).append(" ").append(toMatchClause).append(") ").append(Const.CR);
                    this.updateUsageMap(((Neo4JOutputData)this.data).toLabels, GraphUsage.NODE_READ);
                    break;
                }
                default: {
                    throw new HopException("Unsupported operation type for the 'to' node: " + String.valueOf((Object)((Neo4JOutputData)this.data).toOperationType));
                }
            }
            String relationshipSetClause = this.getSetClause("r", ((Neo4JOutputMeta)this.meta).getRelPropNames(), new boolean[((Neo4JOutputMeta)this.meta).getRelPropNames().length], ((Neo4JOutputData)this.data).relPropIndexes);
            switch (((Neo4JOutputData)this.data).relOperationType) {
                case NONE: {
                    break;
                }
                case MERGE: {
                    cypher.append("MERGE (f)-[").append("r:").append(((Neo4JOutputData)this.data).relationshipLabel).append("]->(t) ").append(Const.CR).append(relationshipSetClause).append(Const.CR);
                    this.updateUsageMap(List.of(((Neo4JOutputData)this.data).relationshipLabel), GraphUsage.RELATIONSHIP_UPDATE);
                    break;
                }
                case CREATE: {
                    cypher.append("CREATE (f)-[").append("r:").append(((Neo4JOutputData)this.data).relationshipLabel).append("]->(t) ").append(Const.CR).append(this.getSetClause("r", ((Neo4JOutputMeta)this.meta).getRelPropNames(), new boolean[((Neo4JOutputMeta)this.meta).getRelPropNames().length], ((Neo4JOutputData)this.data).relPropIndexes)).append(Const.CR);
                    this.updateUsageMap(List.of(((Neo4JOutputData)this.data).relationshipLabel), GraphUsage.RELATIONSHIP_CREATE);
                }
            }
            ((Neo4JOutputData)this.data).cypher = cypher.toString();
            if (this.isDebug()) {
                this.logDebug("Running Cypher: " + ((Neo4JOutputData)this.data).cypher);
                this.logDebug("properties list size : " + ((Neo4JOutputData)this.data).unwindList.size());
            }
            Result result = (Result)((Neo4JOutputData)this.data).session.writeTransaction(tx -> tx.run(((Neo4JOutputData)this.data).cypher, properties));
            this.processSummary(result);
            this.setLinesOutput(this.getLinesOutput() + (long)((Neo4JOutputData)this.data).unwindList.size());
            ((Neo4JOutputData)this.data).unwindList.clear();
        }
        catch (Exception e) {
            throw new HopException("Error writing unwind statement to Neo4j", (Throwable)e);
        }
    }

    private String getMatchClause(String[] propertyNames, boolean[] propertyPrimary, int[] nodePropIndexes) {
        StringBuilder clause = new StringBuilder();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyPrimary[i]) continue;
            if (clause.length() > 0) {
                clause.append(", ");
            }
            clause.append(propertyNames[i]).append(": pr.p").append(nodePropIndexes[i]);
        }
        if (clause.length() == 0) {
            return "";
        }
        return "{ " + String.valueOf(clause) + " }";
    }

    private String getSetClause(String alias, String[] propertyNames, boolean[] propertyPrimary, int[] nodePropIndexes) {
        StringBuilder clause = new StringBuilder();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (propertyPrimary[i]) continue;
            if (clause.length() > 0) {
                clause.append(", ");
            }
            clause.append(alias).append(".").append(propertyNames[i]).append("= pr.p").append(nodePropIndexes[i]);
        }
        if (clause.length() == 0) {
            return "";
        }
        return "SET " + String.valueOf(clause);
    }

    private boolean calculateLabelsAndDetectChanges(Object[] row) throws HopException {
        boolean changedLabel = false;
        if (((Neo4JOutputData)this.data).fromOperationType != OperationType.NONE) {
            if (((Neo4JOutputData)this.data).fromLabelsClause == null || ((Neo4JOutputData)this.data).dynamicFromLabels) {
                List<String> fLabels = this.getNodeLabels(((Neo4JOutputMeta)this.meta).getFromNodeLabels(), ((Neo4JOutputData)this.data).fromLabelValues, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).fromNodeLabelIndexes);
                ((Neo4JOutputData)this.data).fromLabelsClause = this.getLabels("f", fLabels);
            }
            if (((Neo4JOutputData)this.data).dynamicFromLabels && ((Neo4JOutputData)this.data).previousFromLabelsClause != null && ((Neo4JOutputData)this.data).fromLabelsClause != null && !((Neo4JOutputData)this.data).fromLabelsClause.equals(((Neo4JOutputData)this.data).previousFromLabelsClause)) {
                changedLabel = true;
            }
        }
        if (((Neo4JOutputData)this.data).toOperationType != OperationType.NONE) {
            if (((Neo4JOutputData)this.data).toLabelsClause == null || ((Neo4JOutputData)this.data).dynamicToLabels) {
                List<String> tLabels = this.getNodeLabels(((Neo4JOutputMeta)this.meta).getToNodeLabels(), ((Neo4JOutputData)this.data).toLabelValues, this.getInputRowMeta(), row, ((Neo4JOutputData)this.data).toNodeLabelIndexes);
                ((Neo4JOutputData)this.data).toLabelsClause = this.getLabels("t", tLabels);
            }
            if (((Neo4JOutputData)this.data).dynamicToLabels && ((Neo4JOutputData)this.data).previousToLabelsClause != null && ((Neo4JOutputData)this.data).toLabelsClause != null && !((Neo4JOutputData)this.data).toLabelsClause.equals(((Neo4JOutputData)this.data).previousToLabelsClause)) {
                changedLabel = true;
            }
        }
        if (((Neo4JOutputData)this.data).relOperationType != OperationType.NONE) {
            if (((Neo4JOutputData)this.data).dynamicRelLabel) {
                ((Neo4JOutputData)this.data).relationshipLabel = this.getInputRowMeta().getString(row, ((Neo4JOutputData)this.data).relationshipIndex);
            }
            if (StringUtils.isEmpty((String)((Neo4JOutputData)this.data).relationshipLabel) && StringUtils.isNotEmpty((String)((Neo4JOutputData)this.data).relationshipLabelValue)) {
                ((Neo4JOutputData)this.data).relationshipLabel = ((Neo4JOutputData)this.data).relationshipLabelValue;
            }
            if (((Neo4JOutputData)this.data).dynamicRelLabel && ((Neo4JOutputData)this.data).previousRelationshipLabel != null && ((Neo4JOutputData)this.data).relationshipLabel != null && !((Neo4JOutputData)this.data).relationshipLabel.equals(((Neo4JOutputData)this.data).previousRelationshipLabel)) {
                changedLabel = true;
            }
        }
        return changedLabel;
    }

    private boolean determineDynamicLabels(String[] nodeLabelFields) {
        for (String nodeLabelField : nodeLabelFields) {
            if (!StringUtils.isNotEmpty((String)nodeLabelField)) continue;
            return true;
        }
        return false;
    }

    private void outputGraphValue(IRowMeta rowMeta, Object[] row) throws HopException {
        try {
            GraphData graphData = new GraphData();
            graphData.setSourcePipelineName(this.getPipelineMeta().getName());
            graphData.setSourceTransformName(this.getTransformMeta().getName());
            GraphNodeData sourceNodeData = null;
            GraphNodeData targetNodeData = null;
            if (((Neo4JOutputMeta)this.meta).getFromNodeProps().length > 0) {
                sourceNodeData = this.createGraphNodeData(rowMeta, row, ((Neo4JOutputMeta)this.meta).getFromNodeLabels(), ((Neo4JOutputData)this.data).fromLabelValues, ((Neo4JOutputData)this.data).fromNodeLabelIndexes, ((Neo4JOutputData)this.data).fromNodePropIndexes, ((Neo4JOutputMeta)this.meta).getFromNodePropNames(), ((Neo4JOutputMeta)this.meta).getFromNodePropPrimary(), "from");
                if (!((Neo4JOutputMeta)this.meta).isOnlyCreatingRelationships()) {
                    graphData.getNodes().add(sourceNodeData);
                }
            }
            if (((Neo4JOutputMeta)this.meta).getToNodeProps().length > 0) {
                targetNodeData = this.createGraphNodeData(rowMeta, row, ((Neo4JOutputMeta)this.meta).getToNodeLabels(), ((Neo4JOutputData)this.data).toLabelValues, ((Neo4JOutputData)this.data).toNodeLabelIndexes, ((Neo4JOutputData)this.data).toNodePropIndexes, ((Neo4JOutputMeta)this.meta).getToNodePropNames(), ((Neo4JOutputMeta)this.meta).getToNodePropPrimary(), "to");
                if (!((Neo4JOutputMeta)this.meta).isOnlyCreatingRelationships()) {
                    graphData.getNodes().add(targetNodeData);
                }
            }
            String relationshipLabel = null;
            if (((Neo4JOutputData)this.data).relationshipIndex >= 0) {
                relationshipLabel = this.getInputRowMeta().getString(row, ((Neo4JOutputData)this.data).relationshipIndex);
            }
            if (StringUtil.isEmpty(relationshipLabel) && StringUtils.isNotEmpty((String)((Neo4JOutputData)this.data).relationshipLabelValue)) {
                relationshipLabel = ((Neo4JOutputData)this.data).relationshipLabelValue;
            }
            if (sourceNodeData != null && targetNodeData != null && StringUtils.isNotEmpty((String)relationshipLabel)) {
                GraphRelationshipData relationshipData = new GraphRelationshipData();
                relationshipData.setSourceNodeId(sourceNodeData.getId());
                relationshipData.setTargetNodeId(targetNodeData.getId());
                relationshipData.setLabel(relationshipLabel);
                relationshipData.setId(sourceNodeData.getId() + " -> " + targetNodeData.getId());
                relationshipData.setPropertySetId("relationship");
                for (int i = 0; i < ((Neo4JOutputData)this.data).relPropIndexes.length; ++i) {
                    IValueMeta valueMeta = rowMeta.getValueMeta(((Neo4JOutputData)this.data).relPropIndexes[i]);
                    Object valueData = row[((Neo4JOutputData)this.data).relPropIndexes[i]];
                    String propertyName = ((Neo4JOutputMeta)this.meta).getRelPropNames()[i];
                    GraphPropertyDataType propertyType = GraphPropertyDataType.getTypeFromHop(valueMeta);
                    Object propertyNeoValue = propertyType.convertFromHop(valueMeta, valueData);
                    boolean propertyPrimary = false;
                    relationshipData.getProperties().add(new GraphPropertyData(propertyName, propertyNeoValue, propertyType, propertyPrimary));
                }
                graphData.getRelationships().add(relationshipData);
            }
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])row, (int)((Neo4JOutputData)this.data).outputRowMeta.size());
            outputRowData[rowMeta.size()] = graphData;
            this.putRow(((Neo4JOutputData)this.data).outputRowMeta, outputRowData);
        }
        catch (Exception e) {
            throw new HopException("Unable to calculate graph output value", (Throwable)e);
        }
    }

    private GraphNodeData createGraphNodeData(IRowMeta rowMeta, Object[] row, String[] nodeLabels, String[] nodeLabelValues, int[] nodeLabelIndexes, int[] nodePropIndexes, String[] nodePropNames, boolean[] nodePropPrimary, String propertySetId) throws HopException {
        GraphNodeData nodeData = new GraphNodeData();
        nodeData.setPropertySetId(propertySetId);
        List<String> labels = this.getNodeLabels(nodeLabels, nodeLabelValues, rowMeta, row, nodeLabelIndexes);
        for (String label : labels) {
            nodeData.getLabels().add(label);
        }
        StringBuilder nodeId = new StringBuilder();
        for (int i = 0; i < nodePropIndexes.length; ++i) {
            IValueMeta valueMeta = rowMeta.getValueMeta(nodePropIndexes[i]);
            Object valueData = row[nodePropIndexes[i]];
            String propertyName = nodePropNames[i];
            GraphPropertyDataType propertyType = GraphPropertyDataType.getTypeFromHop(valueMeta);
            Object propertyNeoValue = propertyType.convertFromHop(valueMeta, valueData);
            boolean propertyPrimary = nodePropPrimary[i];
            nodeData.getProperties().add(new GraphPropertyData(propertyName, propertyNeoValue, propertyType, propertyPrimary));
            if (!nodePropPrimary[i]) continue;
            if (nodeId.length() > 0) {
                nodeId.append("-");
            }
            nodeId.append(valueMeta.getString(valueData));
        }
        if (nodeId.length() > 0) {
            nodeData.setId(nodeId.toString());
        }
        return nodeData;
    }

    @Override
    public boolean init() {
        if (!((Neo4JOutputMeta)this.meta).isReturningGraph()) {
            if (StringUtils.isEmpty((String)this.resolve(((Neo4JOutputMeta)this.meta).getConnection()))) {
                this.log.logError("You need to specify a Neo4j connection to use in this transform");
                return false;
            }
            try {
                ((Neo4JOutputData)this.data).neoConnection = (NeoConnection)this.metadataProvider.getSerializer(NeoConnection.class).load(this.resolve(((Neo4JOutputMeta)this.meta).getConnection()));
                if (((Neo4JOutputData)this.data).neoConnection == null) {
                    this.log.logError("Connection '" + this.resolve(((Neo4JOutputMeta)this.meta).getConnection()) + "' could not be found in the metastore : " + this.metadataProvider.getDescription());
                    return false;
                }
                ((Neo4JOutputData)this.data).version4 = ((Neo4JOutputData)this.data).neoConnection.isVersion4();
            }
            catch (HopException e) {
                this.log.logError("Could not gencsv Neo4j connection '" + this.resolve(((Neo4JOutputMeta)this.meta).getConnection()) + "' from the metastore", (Throwable)e);
                return false;
            }
            ((Neo4JOutputData)this.data).batchSize = Const.toLong((String)this.resolve(((Neo4JOutputMeta)this.meta).getBatchSize()), (long)1L);
        }
        return super.init();
    }

    @Override
    public void dispose() {
        if (!this.isStopped()) {
            try {
                this.wrapUpTransaction();
            }
            catch (HopException e) {
                this.logError("Error wrapping up transaction", e);
                this.setErrors(1L);
                this.stopAll();
            }
        }
        if (((Neo4JOutputData)this.data).session != null) {
            ((Neo4JOutputData)this.data).session.close();
        }
        if (((Neo4JOutputData)this.data).driver != null) {
            ((Neo4JOutputData)this.data).driver.close();
        }
        super.dispose();
    }

    private String getLabels(String nodeAlias, List<String> nodeLabels) {
        if (nodeLabels.isEmpty()) {
            return null;
        }
        StringBuilder labels = new StringBuilder(nodeAlias);
        for (String nodeLabel : nodeLabels) {
            labels.append(":");
            labels.append(this.escapeLabel(nodeLabel));
        }
        return labels.toString();
    }

    private void processSummary(Result result) throws HopException {
        boolean error = false;
        ResultSummary summary = result.consume();
        for (Notification notification : summary.notifications()) {
            this.log.logError(notification.title() + " (" + notification.severity() + ")");
            this.log.logError(notification.code() + " : " + notification.description() + ", position " + String.valueOf(notification.position()));
            error = true;
        }
        if (error) {
            throw new HopException("Error found while executing cypher statement(s)");
        }
    }

    public List<String> getNodeLabels(String[] labelFields, String[] labelValues, IRowMeta rowMeta, Object[] rowData, int[] labelIndexes) throws HopValueException {
        ArrayList<String> labels = new ArrayList<String>();
        for (int a = 0; a < labelFields.length; ++a) {
            String label = null;
            if (StringUtils.isNotEmpty((String)labelFields[a])) {
                label = rowMeta.getString(rowData, labelIndexes[a]);
            }
            if (StringUtils.isEmpty(label) && StringUtils.isNotEmpty((String)labelValues[a])) {
                label = labelValues[a];
            }
            if (!StringUtils.isNotEmpty(label)) continue;
            labels.add(label);
        }
        return labels;
    }

    public String escapeLabel(String str) {
        if (((String)str).contains(" ") || ((String)str).contains(".")) {
            str = "`" + (String)str + "`";
        }
        return str;
    }

    private void createNodePropertyIndexes(Neo4JOutputMeta meta, Neo4JOutputData data, IRowMeta rowMeta, Object[] rowData) throws HopException {
        if (this.getCopy() != 0) {
            return;
        }
        this.createIndexForNode(data, meta.getFromNodeLabels(), meta.getFromNodeLabelValues(), meta.getFromNodeProps(), meta.getFromNodePropNames(), meta.getFromNodePropPrimary(), rowMeta, rowData);
        this.createIndexForNode(data, meta.getToNodeLabels(), meta.getToNodeLabelValues(), meta.getToNodeProps(), meta.getToNodePropNames(), meta.getToNodePropPrimary(), rowMeta, rowData);
    }

    private void createIndexForNode(Neo4JOutputData data, String[] nodeLabelFields, String[] nodeLabelValues, String[] nodeProps, String[] nodePropNames, boolean[] nodePropPrimary, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        Set labels = Arrays.stream(nodeLabelValues).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        for (String nodeLabelField : nodeLabelFields) {
            String label;
            if (!StringUtils.isNotEmpty((String)nodeLabelField) || !StringUtils.isNotEmpty((String)(label = rowMeta.getString(rowData, nodeLabelField, null)))) continue;
            labels.add(label);
        }
        for (String label : labels) {
            ArrayList<String> primaryProperties = new ArrayList<String>();
            for (int f = 0; f < nodeProps.length; ++f) {
                if (!nodePropPrimary[f]) continue;
                if (StringUtils.isNotEmpty((String)nodePropNames[f])) {
                    primaryProperties.add(nodePropNames[f]);
                    continue;
                }
                primaryProperties.add(nodeProps[f]);
            }
            if (label == null || primaryProperties.size() <= 0) continue;
            NeoConnectionUtils.createNodeIndex(this.log, data.session, Collections.singletonList(label), primaryProperties);
        }
    }

    public void batchComplete() throws HopException {
        this.wrapUpTransaction();
    }

    private void wrapUpTransaction() throws HopException {
        if (!this.isStopped() && ((Neo4JOutputData)this.data).unwindList != null && ((Neo4JOutputData)this.data).unwindList.size() > 0) {
            this.emptyUnwindList();
        }
        ((Neo4JOutputData)this.data).unwindList = new ArrayList<Map<String, Object>>();
    }

    protected void updateUsageMap(List<String> labels, GraphUsage usage) {
        if (labels == null) {
            return;
        }
        Map transformsMap = ((Neo4JOutputData)this.data).usageMap.computeIfAbsent(usage.name(), k -> new HashMap());
        Set labelSet = transformsMap.computeIfAbsent(this.getTransformName(), k -> new HashSet());
        for (String label : labels) {
            if (!StringUtils.isNotEmpty((String)label)) continue;
            labelSet.add(label);
        }
    }
}

