/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.Arrays;
import org.apache.beam.sdk.io.kafka.ConsumerSpEL;
import org.apache.beam.sdk.io.kafka.KafkaTimestampType;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.kafka.common.header.Headers;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class KafkaRecord<K, V> {
    private final String topic;
    private final int partition;
    private final long offset;
    private final @Nullable Headers headers;
    private final KV<K, V> kv;
    private final long timestamp;
    private final KafkaTimestampType timestampType;

    public KafkaRecord(String topic, int partition, long offset, long timestamp, KafkaTimestampType timestampType, @Nullable Headers headers, K key, V value) {
        this(topic, partition, offset, timestamp, timestampType, headers, KV.of(key, value));
    }

    public KafkaRecord(String topic, int partition, long offset, long timestamp, KafkaTimestampType timestampType, @Nullable Headers headers, KV<K, V> kv) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
        this.timestampType = timestampType;
        this.headers = headers;
        this.kv = kv;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    @Pure
    public @Nullable Headers getHeaders() {
        if (!ConsumerSpEL.hasHeaders()) {
            throw new RuntimeException("The version kafka-clients does not support record headers, please use version 0.11.0.0 or newer");
        }
        return this.headers;
    }

    public KV<K, V> getKV() {
        return this.kv;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public KafkaTimestampType getTimestampType() {
        return this.timestampType;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.topic, this.partition, this.offset, this.timestamp, this.headers, this.kv});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof KafkaRecord) {
            KafkaRecord other = (KafkaRecord)obj;
            return this.topic.equals(other.topic) && this.partition == other.partition && this.offset == other.offset && this.timestamp == other.timestamp && Objects.equal((Object)this.headers, (Object)other.headers) && this.kv.equals(other.kv);
        }
        return false;
    }
}

