/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@InternalApi(value="For internal usage only")
public class ResourceLimiterStats {
    private static Map<String, ResourceLimiterStats> stats = new HashMap<String, ResourceLimiterStats>();
    private final MetricRegistry registry = new MetricRegistry();
    private final Timer rpcTimer = this.registry.timer("MutationStats.mutation.timer");
    private final Timer throttlingTimer = this.registry.timer("MutationStats.throttling.timer");
    private final AtomicLong cumulativeThrottlingTimeNanos = new AtomicLong();

    public static synchronized ResourceLimiterStats getInstance(BigtableInstanceName instanceName) {
        String key = instanceName.getInstanceName();
        ResourceLimiterStats instance = stats.get(key);
        if (instance == null) {
            instance = new ResourceLimiterStats();
            stats.put(key, instance);
        }
        return instance;
    }

    @VisibleForTesting
    static void reset() {
        stats.clear();
    }

    void markRpcComplete(long rpcDurationInNanos) {
        this.rpcTimer.update(rpcDurationInNanos, TimeUnit.NANOSECONDS);
    }

    void markThrottling(long throttlingDurationInNanos) {
        this.throttlingTimer.update(throttlingDurationInNanos, TimeUnit.NANOSECONDS);
        this.cumulativeThrottlingTimeNanos.addAndGet(throttlingDurationInNanos);
    }

    public Timer getMutationTimer() {
        return this.rpcTimer;
    }

    public Timer getThrottlingTimer() {
        return this.throttlingTimer;
    }

    public long getCumulativeThrottlingTimeNanos() {
        return this.cumulativeThrottlingTimeNanos.get();
    }
}

