/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkSessionFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationContext {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationContext.class);
    private final Map<PValue, Dataset<?>> datasets;
    private final Set<Dataset<?>> leaves;
    private final SerializablePipelineOptions serializablePipelineOptions;
    private final SparkSession sparkSession;
    private final Map<PCollectionView<?>, Dataset<?>> broadcastDataSets;
    private final Map<Coder<?>, ExpressionEncoder<?>> encoders;

    public TranslationContext(SparkStructuredStreamingPipelineOptions options) {
        this.sparkSession = SparkSessionFactory.getOrCreateSession(options);
        this.serializablePipelineOptions = new SerializablePipelineOptions((PipelineOptions)options);
        this.datasets = new HashMap();
        this.leaves = new HashSet();
        this.broadcastDataSets = new HashMap();
        this.encoders = new HashMap();
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public SerializablePipelineOptions getSerializableOptions() {
        return this.serializablePipelineOptions;
    }

    public <T> Encoder<T> encoderOf(Coder<T> coder, Function<Coder<T>, Encoder<T>> loadFn) {
        return this.encoders.computeIfAbsent(coder, loadFn);
    }

    public <T> Dataset<WindowedValue<T>> getDataset(PCollection<T> pCollection) {
        Dataset dataset = (Dataset)Preconditions.checkStateNotNull(this.datasets.get(pCollection));
        this.leaves.remove(dataset);
        return dataset;
    }

    public <T> void putDataset(PCollection<T> pCollection, Dataset<WindowedValue<T>> dataset) {
        if (!this.datasets.containsKey(pCollection)) {
            this.datasets.put((PValue)pCollection, dataset);
            this.leaves.add(dataset);
        }
    }

    public <ViewT, ElemT> void setSideInputDataset(PCollectionView<ViewT> value, Dataset<WindowedValue<ElemT>> set) {
        if (!this.broadcastDataSets.containsKey(value)) {
            this.broadcastDataSets.put(value, set);
        }
    }

    public <T> Dataset<T> getSideInputDataSet(PCollectionView<?> value) {
        return (Dataset)Preconditions.checkStateNotNull(this.broadcastDataSets.get(value));
    }

    public void startPipeline() {
        this.encoders.clear();
        SparkStructuredStreamingPipelineOptions options = (SparkStructuredStreamingPipelineOptions)this.serializablePipelineOptions.get().as(SparkStructuredStreamingPipelineOptions.class);
        int datasetIndex = 0;
        for (Dataset<?> dataset : this.leaves) {
            if (options.getTestMode()) {
                LOG.debug("**** dataset {} catalyst execution plans ****", (Object)(++datasetIndex));
                dataset.explain(true);
            }
            dataset.foreach((ForeachFunction & Serializable)t -> {});
        }
    }

    public static <T> void printDatasetContent(Dataset<WindowedValue<T>> dataset) {
        List windowedValues = dataset.collectAsList();
        for (WindowedValue windowedValue : windowedValues) {
            System.out.println(windowedValue);
        }
    }
}

