/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.i18n;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.i18n.BundlesStore;
import org.apache.hop.ui.i18n.KeyOccurrence;

public class MessagesSourceCrawler {
    private String rootFolder;
    private List<String> sourceDirectories = new ArrayList<String>();
    private BundlesStore bundlesStore;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;
    private List<String> filesToAvoid = new ArrayList<String>();
    private Pattern packagePattern;
    private Pattern importPattern;
    private Pattern stringPkgPattern;
    private List<Pattern> classPkgPatterns;
    private Pattern scanPhrasePattern;
    private Pattern doubleQuotePattern;
    private Pattern i18nStringPattern;
    private ILogChannel log;

    public MessagesSourceCrawler() {
        this.sourcePackageOccurrences = new HashMap<String, Map<String, List<KeyOccurrence>>>();
        this.packagePattern = Pattern.compile("^package [a-z\\.0-9A-Z]*;$", 40);
        this.importPattern = Pattern.compile("^import [a-z\\._0-9A-Z]*;$", 40);
        this.stringPkgPattern = Pattern.compile("private static String PKG.*=.*$", 40);
        this.classPkgPatterns = Arrays.asList(Pattern.compile("private static Class.*\\sPKG\\s*=.*\\.class;", 40), Pattern.compile("private static final Class.*\\sPKG\\s*=.*\\.class;", 40), Pattern.compile("public static Class.*\\sPKG\\s*=.*\\.class;", 40), Pattern.compile("public static final Class.*\\sPKG\\s*=.*\\.class;", 40));
        this.scanPhrasePattern = Pattern.compile("BaseMessages\\s*.getString\\(\\s*PKG,.*\\);", 40);
        this.doubleQuotePattern = Pattern.compile("\"", 8);
        this.i18nStringPattern = Pattern.compile("\"i18n:[a-z\\.0-9]*:[a-zA-Z0-9\\.]*\"", 40);
    }

    public MessagesSourceCrawler(ILogChannel log, String rootFolder, BundlesStore bundlesStore) throws HopException {
        this();
        this.log = log;
        this.rootFolder = rootFolder;
        this.bundlesStore = bundlesStore;
        this.filesToAvoid = new ArrayList<String>();
        try {
            Files.walk(Paths.get(rootFolder, new String[0]), new FileVisitOption[0]).filter(path -> Files.isDirectory(path, new LinkOption[0]) && path.endsWith("src/main/java") && !path.toString().contains("archive") && !path.toString().contains("/impl/")).forEach(path -> this.sourceDirectories.add(path.toAbsolutePath().toFile().getPath()));
        }
        catch (IOException e) {
            throw new HopException("Error scanning root folder '" + rootFolder + "' for Java source files (*.java)", (Throwable)e);
        }
    }

    public void addKeyOccurrence(KeyOccurrence occ) {
        String sourceFolder = occ.getSourceFolder();
        if (sourceFolder == null) {
            throw new RuntimeException("No source folder found for key: " + occ.getKey() + " in package " + occ.getMessagesPackage());
        }
        String messagesPackage = occ.getMessagesPackage();
        Map packageOccurrences = this.sourcePackageOccurrences.computeIfAbsent(sourceFolder, k -> new HashMap());
        ArrayList<KeyOccurrence> occurrences = (ArrayList<KeyOccurrence>)packageOccurrences.get(messagesPackage);
        if (occurrences == null) {
            occurrences = new ArrayList<KeyOccurrence>();
            occurrences.add(occ);
            packageOccurrences.put(messagesPackage, occurrences);
        } else {
            int index = Collections.binarySearch(occurrences, occ);
            if (index < 0) {
                occurrences.add(-index - 1, occ);
            }
        }
    }

    public void crawl() throws Exception {
        for (String sourceDirectory : this.sourceDirectories) {
            FileObject[] javaFiles;
            FileObject folder = HopVfs.getFileObject((String)sourceDirectory);
            for (FileObject javaFile : javaFiles = folder.findFiles(new FileSelector(){

                public boolean traverseDescendents(FileSelectInfo info) {
                    return true;
                }

                public boolean includeFile(FileSelectInfo info) {
                    return info.getFile().getName().getExtension().equals("java");
                }
            })) {
                boolean skip = false;
                for (String filename : this.filesToAvoid) {
                    if (!javaFile.getName().getBaseName().equals(filename)) continue;
                    skip = true;
                }
                if (skip) continue;
                this.lookForOccurrencesInFile(sourceDirectory, javaFile);
            }
        }
    }

    public void lookForOccurrencesInFile(String sourceFolder, FileObject javaFile) throws IOException {
        String specificMessagesClassPackage;
        String messagesPackage;
        String filename = HopVfs.getFilename((FileObject)javaFile);
        Path path = new File(filename).toPath();
        String javaCode = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        Map<String, String> importsMap = this.findImportOccurrences(javaCode);
        String classPackage = messagesPackage = this.findPackage(javaCode);
        String specificMessagesStringPackage = this.findSpecificStringPackage(javaCode);
        if (specificMessagesStringPackage != null) {
            messagesPackage = specificMessagesStringPackage;
        }
        if ((specificMessagesClassPackage = this.findSpecificClassPackage(javaCode, importsMap, classPackage)) != null) {
            messagesPackage = specificMessagesClassPackage;
        }
        Matcher scanPhraseMatcher = this.scanPhrasePattern.matcher(javaCode);
        int startIndex = 0;
        while (scanPhraseMatcher.find(startIndex)) {
            String expression = javaCode.substring(scanPhraseMatcher.start());
            if (scanPhraseMatcher.start() > 0 && !Character.isJavaIdentifierPart(javaCode.charAt(scanPhraseMatcher.start() - 1))) {
                this.addKeyOccurrence(sourceFolder, javaFile, messagesPackage, expression, scanPhraseMatcher.start());
            }
            startIndex = scanPhraseMatcher.start() + 1;
        }
        Matcher i18StringMatcher = this.i18nStringPattern.matcher(javaCode);
        startIndex = 0;
        while (i18StringMatcher.find(startIndex)) {
            String expression = javaCode.substring(i18StringMatcher.start() + 1, i18StringMatcher.end() - 1);
            String[] i18n = expression.split(":");
            if (i18n.length == 3) {
                String i18nPackage = i18n[1];
                if (StringUtils.isEmpty((String)i18nPackage)) {
                    i18nPackage = classPackage;
                }
                String i18nKey = i18n[2];
                if (StringUtils.isNotEmpty((String)i18n[1])) {
                    i18nPackage = i18n[1];
                }
                String actualSourceFolder = HopVfs.getFilename((FileObject)javaFile).replaceAll("\\/src\\/main\\/java.*\\.java", "");
                KeyOccurrence keyOccurrence = new KeyOccurrence(javaFile, actualSourceFolder, i18nPackage, i18StringMatcher.start(), i18nKey, "", expression);
                this.addKeyOccurrence(keyOccurrence);
            }
            startIndex = i18StringMatcher.start() + 1;
        }
    }

    private String findSpecificClassPackage(String javaCode, Map<String, String> importedClasses, String classPackage) {
        for (Pattern classPkgPattern : this.classPkgPatterns) {
            Matcher matcher = classPkgPattern.matcher(javaCode);
            if (!matcher.find()) continue;
            String matchedString = javaCode.substring(matcher.start(), matcher.end());
            int fromIndex = matchedString.indexOf(61) + 1;
            int toIndex = matchedString.indexOf(".class", fromIndex);
            if (fromIndex <= 0 || toIndex <= 0) continue;
            String expression = Const.trim((String)matchedString.substring(fromIndex, toIndex));
            if (expression.contains(".")) {
                int lastDotIndex = expression.lastIndexOf(46);
                return expression.substring(0, lastDotIndex);
            }
            String packageName = importedClasses.get(expression);
            if (packageName == null) {
                return classPackage;
            }
            return packageName;
        }
        return null;
    }

    private String findSpecificStringPackage(String javaCode) {
        Matcher matcher = this.stringPkgPattern.matcher(javaCode);
        if (matcher.find()) {
            String expression = javaCode.substring(matcher.start(), matcher.end());
            int beginIndex = expression.indexOf(34) + 1;
            int endIndex = expression.indexOf(34, beginIndex);
            return expression.substring(beginIndex, endIndex);
        }
        return null;
    }

    private String findPackage(String javaCode) {
        Matcher matcher = this.packagePattern.matcher(javaCode);
        if (matcher.find()) {
            String expression = javaCode.substring(matcher.start(), matcher.end());
            int beginIndex = expression.indexOf("org.apache.hop.");
            int endIndex = expression.indexOf(59);
            if (beginIndex >= 0 && endIndex >= 0) {
                return expression.substring(beginIndex, endIndex);
            }
        }
        return null;
    }

    private Map<String, String> findImportOccurrences(String javaCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = this.importPattern.matcher(javaCode);
        while (matcher.find()) {
            String expression = javaCode.substring(matcher.start(), matcher.end() - 1);
            int lastDotIndex = expression.lastIndexOf(46);
            if (lastDotIndex <= 0) continue;
            String packageName = expression.substring("import ".length(), lastDotIndex);
            String className = expression.substring(lastDotIndex + 1);
            if ("*".equals(className)) continue;
            map.put(className, packageName);
        }
        return map;
    }

    private void addKeyOccurrence(String sourceFolder, FileObject fileObject, String messagesPackage, String expression, int fileIndex) {
        String shortExpression = expression;
        if (expression.length() > 100) {
            shortExpression = expression.substring(0, 100);
        }
        Matcher doubleQuoteMatcher = this.doubleQuotePattern.matcher(expression);
        int startKeyIndex = -1;
        int endKeyIndex = -1;
        String arguments = "";
        if (doubleQuoteMatcher.find()) {
            String key;
            startKeyIndex = doubleQuoteMatcher.start() + 1;
            if (doubleQuoteMatcher.find(startKeyIndex)) {
                endKeyIndex = doubleQuoteMatcher.start();
            }
            if (endKeyIndex >= 0) {
                int bracketIndex;
                key = expression.substring(startKeyIndex, endKeyIndex);
                int nrOpen = 1;
                for (bracketIndex = endKeyIndex; bracketIndex < expression.length() && nrOpen != 0; ++bracketIndex) {
                    char c = expression.charAt(bracketIndex);
                    if (c == '(') {
                        ++nrOpen;
                    }
                    if (c != ')') continue;
                    --nrOpen;
                }
                arguments = bracketIndex + 1 < expression.length() ? expression.substring(endKeyIndex + 1, bracketIndex - 1) : expression.substring(endKeyIndex + 1);
            } else {
                key = expression.substring(startKeyIndex);
            }
            if (key.contains("\t") || key.contains(" ")) {
                System.out.println("Suspect key found: [" + key + "] in file [" + String.valueOf(fileObject) + "]");
            }
            String moduleSourceFolder = sourceFolder.replaceAll("\\/src\\/main\\/java.*", "");
            if (key.startsWith("System.")) {
                String i18nPackage = BaseMessages.class.getPackage().getName();
                KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, moduleSourceFolder, i18nPackage, fileIndex, key, arguments, shortExpression);
                KeyOccurrence lookup = this.getKeyOccurrence(key, i18nPackage);
                if (lookup == null) {
                    this.addKeyOccurrence(keyOccurrence);
                } else {
                    lookup.setSourceLine(lookup.getSourceLine() + Const.CR + keyOccurrence.getSourceLine());
                    lookup.incrementOccurrences();
                }
            } else if (messagesPackage == null) {
                this.log.logError("Could not calculate messages package in file: " + String.valueOf(fileObject));
            } else {
                KeyOccurrence keyOccurrence = new KeyOccurrence(fileObject, moduleSourceFolder, messagesPackage, fileIndex, key, arguments, shortExpression);
                this.addKeyOccurrence(keyOccurrence);
            }
        }
    }

    public List<String> getMessagesPackagesList(String sourceFolder) {
        Map<String, List<KeyOccurrence>> packageOccurrences = this.sourcePackageOccurrences.get(sourceFolder);
        ArrayList<String> list = new ArrayList<String>(packageOccurrences.keySet());
        Collections.sort(list);
        return list;
    }

    public List<KeyOccurrence> getOccurrencesForPackage(String messagesPackage) {
        ArrayList<KeyOccurrence> list = new ArrayList<KeyOccurrence>();
        for (String sourceFolder : this.sourcePackageOccurrences.keySet()) {
            Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
            List<KeyOccurrence> occurrences = po.get(messagesPackage);
            if (occurrences == null) continue;
            list.addAll(occurrences);
        }
        return list;
    }

    public KeyOccurrence getKeyOccurrence(String key, String selectedMessagesPackage) {
        for (String sourceFolder : this.sourcePackageOccurrences.keySet()) {
            List<KeyOccurrence> occurrences;
            Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
            if (po == null || (occurrences = po.get(selectedMessagesPackage)) == null) continue;
            for (KeyOccurrence keyOccurrence : occurrences) {
                if (!keyOccurrence.getKey().equals(key) || !keyOccurrence.getMessagesPackage().equals(selectedMessagesPackage)) continue;
                return keyOccurrence;
            }
        }
        return null;
    }

    public List<KeyOccurrence> getKeyOccurrences(String sourceFolder) {
        HashMap<CallSite, KeyOccurrence> map = new HashMap<CallSite, KeyOccurrence>();
        Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(sourceFolder);
        if (po != null) {
            for (List<KeyOccurrence> keyOccurrences : po.values()) {
                for (KeyOccurrence keyOccurrence : keyOccurrences) {
                    String key = keyOccurrence.getMessagesPackage() + " - " + keyOccurrence.getKey();
                    map.put((CallSite)((Object)key), keyOccurrence);
                }
            }
        }
        return new ArrayList<KeyOccurrence>(map.values());
    }

    public List<String> getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(List<String> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    public BundlesStore getBundlesStore() {
        return this.bundlesStore;
    }

    public void setBundlesStore(BundlesStore bundlesStore) {
        this.bundlesStore = bundlesStore;
    }

    public Map<String, Map<String, List<KeyOccurrence>>> getSourcePackageOccurrences() {
        return this.sourcePackageOccurrences;
    }

    public void setSourcePackageOccurrences(Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.sourcePackageOccurrences = sourcePackageOccurrences;
    }

    public List<String> getFilesToAvoid() {
        return this.filesToAvoid;
    }

    public void setFilesToAvoid(List<String> filesToAvoid) {
        this.filesToAvoid = filesToAvoid;
    }

    public Pattern getPackagePattern() {
        return this.packagePattern;
    }

    public void setPackagePattern(Pattern packagePattern) {
        this.packagePattern = packagePattern;
    }

    public Pattern getImportPattern() {
        return this.importPattern;
    }

    public void setImportPattern(Pattern importPattern) {
        this.importPattern = importPattern;
    }

    public Pattern getStringPkgPattern() {
        return this.stringPkgPattern;
    }

    public void setStringPkgPattern(Pattern stringPkgPattern) {
        this.stringPkgPattern = stringPkgPattern;
    }

    public List<Pattern> getClassPkgPatterns() {
        return this.classPkgPatterns;
    }

    public void setClassPkgPatterns(List<Pattern> classPkgPatterns) {
        this.classPkgPatterns = classPkgPatterns;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }
}

