/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;

public class ValueMetaDeserializer
extends JsonDeserializer<IValueMeta> {
    public IValueMeta deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode root = (ObjectNode)objectMapper.readTree(jsonParser);
        int type = root.get("type").asInt();
        String name = root.get("name").asText();
        int length = root.get("length").asInt();
        int precision = root.get("precision").asInt();
        try {
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta(name, type, length, precision);
            valueMeta.setTrimType(root.get("trimType").asInt());
            valueMeta.setStorageType(root.get("storageType").asInt());
            valueMeta.setConversionMask(this.asString(root.get("conversionMask")));
            JsonNode stringEncoding = root.get("stringEncoding");
            if (!stringEncoding.isNull()) {
                valueMeta.setStringEncoding(stringEncoding.asText());
            }
            valueMeta.setDecimalSymbol(this.asString(root.get("decimalSymbol")));
            valueMeta.setGroupingSymbol(this.asString(root.get("groupingSymbol")));
            valueMeta.setCurrencySymbol(this.asString(root.get("currencySymbol")));
            valueMeta.setCollatorStrength(root.get("collatorStrength").asInt());
            valueMeta.setCaseInsensitive(root.get("caseInsensitive").asBoolean());
            valueMeta.setCollatorDisabled(root.get("collatorDisabled").asBoolean());
            valueMeta.setCollatorLocale(LocaleUtils.toLocale((String)root.get("collatorLocale").asText()));
            valueMeta.setSortedDescending(root.get("sortedDescending").asBoolean());
            valueMeta.setOutputPaddingEnabled(root.get("outputPaddingEnabled").asBoolean());
            valueMeta.setLargeTextField(root.get("largeTextField").asBoolean());
            valueMeta.setDateFormatLocale(LocaleUtils.toLocale((String)root.get("dateFormatLocale").asText()));
            valueMeta.setDateFormatTimeZone(TimeZone.getTimeZone(root.get("dateFormatTimeZone").asText()));
            valueMeta.setDateFormatLenient(root.get("dateFormatLenient").asBoolean());
            valueMeta.setIgnoreWhitespace(root.get("ignoreWhitespace").asBoolean());
            return valueMeta;
        }
        catch (Exception e) {
            throw new IOException("Error creating value metadata '" + name + "' of type " + type, e);
        }
    }

    private String asString(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        return node.asText();
    }
}

