/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_DistributionResult;

@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class DistributionResult {
    public static final DistributionResult IDENTITY_ELEMENT = DistributionResult.create(0L, 0L, Long.MAX_VALUE, Long.MIN_VALUE);

    public abstract long getSum();

    public abstract long getCount();

    public abstract long getMin();

    public abstract long getMax();

    public double getMean() {
        return 1.0 * (double)this.getSum() / (double)this.getCount();
    }

    public static DistributionResult create(long sum, long count, long min, long max) {
        return new AutoValue_DistributionResult(sum, count, min, max);
    }
}

