/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

class SimpleMapWithFailures<InputT, OutputT, FailureT>
extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
    private final transient TypeDescriptor<OutputT> outputType;
    private final Contextful<Contextful.Fn<InputT, OutputT>> fn;
    private final transient TypeDescriptor<FailureT> failureType;
    private final @Nullable ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;
    private final String transformName;

    SimpleMapWithFailures(String transformName, Contextful<Contextful.Fn<InputT, OutputT>> fn, TypeDescriptor<OutputT> outputType, @Nullable ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, TypeDescriptor<FailureT> failureType) {
        this.transformName = transformName;
        this.fn = fn;
        this.outputType = outputType;
        this.exceptionHandler = exceptionHandler;
        this.failureType = failureType;
    }

    @Override
    public WithFailures.Result<PCollection<OutputT>, FailureT> expand(PCollection<InputT> input) {
        if (this.exceptionHandler == null) {
            throw new NullPointerException(".exceptionsVia() is required");
        }
        return (WithFailures.Result)input.apply(this.transformName, MapElements.into(this.outputType).via(this.fn).exceptionsInto(this.failureType).exceptionsVia(this.exceptionHandler));
    }

    public SimpleMapWithFailures<InputT, OutputT, FailureT> exceptionsVia(ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new SimpleMapWithFailures<InputT, OutputT, FailureT>(this.transformName, this.fn, this.outputType, exceptionHandler, this.failureType);
    }
}

