/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.hll.serialization;

import org.apache.ignite.internal.processors.query.stat.hll.serialization.IWordDeserializer;

public class BigEndianAscendingWordDeserializer
implements IWordDeserializer {
    private static final int BITS_PER_BYTE = 8;
    private static final long BYTE_MASK = 255L;
    private final int wordLength;
    private final byte[] bytes;
    private final int bytePadding;
    private final int wordCount;
    private int currentWordIndex;

    public BigEndianAscendingWordDeserializer(int wordLength, int bytePadding, byte[] bytes) {
        if (wordLength < 1 || wordLength > 64) {
            throw new IllegalArgumentException("Word length must be >= 1 and <= 64. (was: " + wordLength + ")");
        }
        if (bytePadding < 0) {
            throw new IllegalArgumentException("Byte padding must be >= zero. (was: " + bytePadding + ")");
        }
        this.wordLength = wordLength;
        this.bytes = bytes;
        this.bytePadding = bytePadding;
        int dataBytes = bytes.length - bytePadding;
        long dataBits = dataBytes * 8;
        this.wordCount = (int)(dataBits / (long)wordLength);
        this.currentWordIndex = 0;
    }

    @Override
    public long readWord() {
        long word = this.readWord(this.currentWordIndex);
        ++this.currentWordIndex;
        return word;
    }

    private long readWord(int position) {
        if (position < 0) {
            throw new ArrayIndexOutOfBoundsException(position);
        }
        long firstBitIdx = position * this.wordLength;
        int firstByteIdx = this.bytePadding + (int)(firstBitIdx / 8L);
        int firstByteSkipBits = (int)(firstBitIdx % 8L);
        long lastBitIdx = firstBitIdx + (long)this.wordLength - 1L;
        int lastByteIdx = this.bytePadding + (int)(lastBitIdx / 8L);
        int bitsAfterByteBoundary = (int)((lastBitIdx + 1L) % 8L);
        int lastByteBitsToConsume = bitsAfterByteBoundary == 0 ? 8 : bitsAfterByteBoundary;
        if (lastByteIdx >= this.bytes.length) {
            throw new ArrayIndexOutOfBoundsException("Word out of bounds of backing array.");
        }
        long val = 0L;
        int bitsRemainingInFirstByte = 8 - firstByteSkipBits;
        int bitsToConsumeInFirstByte = Math.min(bitsRemainingInFirstByte, this.wordLength);
        long firstByte = this.bytes[firstByteIdx];
        long firstByteMask = (1L << bitsRemainingInFirstByte) - 1L;
        firstByte &= firstByteMask;
        val |= (firstByte >>>= bitsRemainingInFirstByte - bitsToConsumeInFirstByte);
        if (firstByteIdx == lastByteIdx) {
            return val;
        }
        int middleByteCnt = lastByteIdx - firstByteIdx - 1;
        for (int i = 0; i < middleByteCnt; ++i) {
            long middleByte = (long)this.bytes[firstByteIdx + i + 1] & 0xFFL;
            val <<= 8;
            val |= middleByte;
        }
        long lastByte = (long)this.bytes[lastByteIdx] & 0xFFL;
        val <<= lastByteBitsToConsume;
        return val |= (lastByte >>= 8 - lastByteBitsToConsume);
    }

    @Override
    public int totalWordCount() {
        return this.wordCount;
    }
}

