/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.probes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.impl.util.BenchmarkClosure;
import org.yardstickframework.impl.util.BenchmarkProcessLauncher;

public class VmStatProbe
implements BenchmarkProbe {
    private static final String PATH = "BENCHMARK_PROBE_VMSTAT_PATH";
    private static final String OPTS = "BENCHMARK_PROBE_VMSTAT_OPTS";
    private static final int DEFAULT_INTERVAL_IN_SECS = 1;
    private static final String DEFAULT_PATH = "vmstat";
    private static final String DEFAULT_OPTS = "-n 1";
    private static final String FIRST_LINE_RE = "^\\s*procs -*memory-* -*swap-* -*io-* -*system-* -*cpu-*\\s*$";
    private static final Pattern FIRST_LINE = Pattern.compile("^\\s*procs -*memory-* -*swap-* -*io-* -*system-* -*cpu-*\\s*$");
    private static final String HEADER_LINE_RE = "^\\s*r\\s+b\\s+swpd\\s+free\\s+buff\\s+cache\\s+si\\s+so\\s+bi\\s+bo\\s+in\\s+cs\\s+us\\s+sy\\s+id\\s+wa\\s*(st\\s*)?$";
    private static final Pattern HEADER_LINE = Pattern.compile("^\\s*r\\s+b\\s+swpd\\s+free\\s+buff\\s+cache\\s+si\\s+so\\s+bi\\s+bo\\s+in\\s+cs\\s+us\\s+sy\\s+id\\s+wa\\s*(st\\s*)?$");
    private static final Pattern VALUES_PAT;
    private BenchmarkConfiguration cfg;
    private BenchmarkProcessLauncher proc;
    private Collection<BenchmarkProbePoint> collected = new ArrayList<BenchmarkProbePoint>();

    @Override
    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg) throws Exception {
        this.cfg = cfg;
        BenchmarkClosure<String> c = new BenchmarkClosure<String>(){
            private final AtomicInteger lineNum = new AtomicInteger(0);

            @Override
            public void apply(String s) {
                VmStatProbe.this.parseLine(this.lineNum.getAndIncrement(), s);
            }
        };
        this.proc = new BenchmarkProcessLauncher();
        ArrayList<String> cmdParams = new ArrayList<String>();
        cmdParams.add(VmStatProbe.path(cfg));
        cmdParams.addAll(VmStatProbe.opts(cfg));
        String execCmd = ((Object)cmdParams).toString().replaceAll(",|\\[|\\]", "");
        try {
            this.proc.exec(cmdParams, Collections.emptyMap(), c);
            BenchmarkUtils.println(cfg, this.getClass().getSimpleName() + " is started. Command: '" + execCmd + "'");
        }
        catch (Exception e) {
            BenchmarkUtils.errorHelp(cfg, "Can not start: '" + execCmd + "'", e);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.proc != null) {
            this.proc.shutdown(false);
            BenchmarkUtils.println(this.cfg, this.getClass().getSimpleName() + " is stopped.");
        }
    }

    @Override
    public Collection<String> metaInfo() {
        return Arrays.asList("Time, sec", "Processes Waiting For Run Time", "Processes In Uninterruptible Sleep", "Memory Used, KB", "Memory Free, KB", "Memory Buffered, KB", "Memory Cached, KB", "Memory Swapped In From Disk, per sec", "Memory Swapped To Disk, per sec", "IO Blocks Received, blocks/sec", "IO Blocks Sent, blocks/sec", "System Interrupts, per sec", "System Context Switches, per sec", "CPU User, %", "CPU System, %", "CPU Idle, %", "CPU Wait, %");
    }

    @Override
    public synchronized Collection<BenchmarkProbePoint> points() {
        Collection<BenchmarkProbePoint> ret = this.collected;
        this.collected = new ArrayList<BenchmarkProbePoint>(ret.size() + 5);
        return ret;
    }

    @Override
    public void buildPoint(long time) {
    }

    private synchronized void collectPoint(BenchmarkProbePoint pnt) {
        this.collected.add(pnt);
    }

    private void parseLine(int lineNum, String line) {
        if (lineNum == 0) {
            Matcher m = FIRST_LINE.matcher(line);
            if (!m.matches()) {
                BenchmarkUtils.println(this.cfg, "WARNING: Unexpected first line: " + line);
            }
        } else if (lineNum == 1) {
            Matcher m = HEADER_LINE.matcher(line);
            if (!m.matches()) {
                BenchmarkUtils.errorHelp(this.cfg, "Header line does not match expected header [exp=" + HEADER_LINE + ", act=" + line + "]");
            }
        } else {
            Matcher m = VALUES_PAT.matcher(line);
            if (m.matches()) {
                try {
                    BenchmarkProbePoint pnt = new BenchmarkProbePoint(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()), new double[]{VmStatProbe.parseValue(m.group(1)), VmStatProbe.parseValue(m.group(2)), VmStatProbe.parseValue(m.group(3)), VmStatProbe.parseValue(m.group(4)), VmStatProbe.parseValue(m.group(5)), VmStatProbe.parseValue(m.group(6)), VmStatProbe.parseValue(m.group(7)), VmStatProbe.parseValue(m.group(8)), VmStatProbe.parseValue(m.group(9)), VmStatProbe.parseValue(m.group(10)), VmStatProbe.parseValue(m.group(11)), VmStatProbe.parseValue(m.group(12)), VmStatProbe.parseValue(m.group(13)), VmStatProbe.parseValue(m.group(14)), VmStatProbe.parseValue(m.group(15)), VmStatProbe.parseValue(m.group(16))});
                    this.collectPoint(pnt);
                }
                catch (NumberFormatException e) {
                    BenchmarkUtils.errorHelp(this.cfg, "Can't parse line: " + line, e);
                }
            } else {
                BenchmarkUtils.errorHelp(this.cfg, "Can't parse line: " + line);
            }
        }
    }

    private static long parseValue(String val) {
        return Long.parseLong(val);
    }

    private static String path(BenchmarkConfiguration cfg) {
        String res = cfg.customProperties().get(PATH);
        return res == null || res.isEmpty() ? DEFAULT_PATH : res;
    }

    private static Collection<String> opts(BenchmarkConfiguration cfg) {
        String res = cfg.customProperties().get(OPTS);
        res = res == null || res.isEmpty() ? DEFAULT_OPTS : res;
        return Arrays.asList(res.split("\\s+"));
    }

    static {
        int numFields = 16;
        StringBuilder sb = new StringBuilder("^\\s*");
        for (int i = 0; i < numFields; ++i) {
            sb.append("(\\d+)");
            if (i < numFields - 1) {
                sb.append("\\s+");
                continue;
            }
            sb.append("\\s*");
        }
        sb.append("(\\d+)?\\s*$");
        VALUES_PAT = Pattern.compile(sb.toString());
    }
}

