/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.performancestatistics;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsHandler;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class FilePerformanceStatisticsReader {
    private static final int DFLT_READ_BUFFER_SIZE = 0x800000;
    private static final String UUID_STR_PATTERN = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final Pattern FILE_PATTERN = Pattern.compile("^node-([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})(-\\d+)?.prf$");
    private static final PerformanceStatisticsHandler[] NOOP_HANDLER = new PerformanceStatisticsHandler[0];
    private final RandomAccessFileIOFactory ioFactory = new RandomAccessFileIOFactory();
    private FileIO fileIo;
    private final ByteBuffer buf;
    private final PerformanceStatisticsHandler[] handlers;
    private PerformanceStatisticsHandler[] curHnd;
    private final Map<Integer, String> knownStrs = new HashMap<Integer, String>();
    private ForwardRead forwardRead;

    public FilePerformanceStatisticsReader(PerformanceStatisticsHandler ... handlers) {
        this(0x800000, handlers);
    }

    FilePerformanceStatisticsReader(int bufSize, PerformanceStatisticsHandler ... handlers) {
        A.notEmpty(handlers, "At least one handler expected.");
        this.buf = ByteBuffer.allocateDirect(bufSize).order(ByteOrder.nativeOrder());
        this.handlers = handlers;
        this.curHnd = handlers;
    }

    public void read(List<File> filesOrDirs) throws IOException {
        List<File> files = FilePerformanceStatisticsReader.resolveFiles(filesOrDirs);
        if (files.isEmpty()) {
            return;
        }
        for (File file : files) {
            this.buf.clear();
            UUID nodeId = FilePerformanceStatisticsReader.nodeId(file);
            try (FileIO io = this.ioFactory.create(file);){
                this.fileIo = io;
                while (true) {
                    if (io.read(this.buf) <= 0) {
                        if (this.forwardRead == null) {
                            break;
                        }
                        io.position(this.forwardRead.nextRecPos);
                        this.buf.clear();
                        this.curHnd = this.handlers;
                        this.forwardRead = null;
                        continue;
                    }
                    this.buf.flip();
                    this.buf.mark();
                    while (this.deserialize(this.buf, nodeId)) {
                        if (this.forwardRead != null && this.forwardRead.found) {
                            if (this.forwardRead.resetBuf) {
                                this.buf.limit(0);
                                io.position(this.forwardRead.curRecPos);
                            } else {
                                this.buf.position(this.forwardRead.bufPos);
                            }
                            this.curHnd = this.handlers;
                            this.forwardRead = null;
                        }
                        this.buf.mark();
                    }
                    this.buf.reset();
                    if (this.forwardRead != null) {
                        this.forwardRead.resetBuf = true;
                    }
                    this.buf.compact();
                }
            }
            this.knownStrs.clear();
            this.forwardRead = null;
        }
    }

    private boolean deserialize(ByteBuffer buf, UUID nodeId) throws IOException {
        if (buf.remaining() < 1) {
            return false;
        }
        byte opTypeByte = buf.get();
        OperationType opType = OperationType.of(opTypeByte);
        if (OperationType.cacheOperation(opType)) {
            if (buf.remaining() < OperationType.cacheRecordSize()) {
                return false;
            }
            int cacheId = buf.getInt();
            long startTime = buf.getLong();
            long duration = buf.getLong();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.cacheOperation(nodeId, opType, cacheId, startTime, duration);
            }
            return true;
        }
        if (OperationType.transactionOperation(opType)) {
            if (buf.remaining() < 4) {
                return false;
            }
            int cacheIdsCnt = buf.getInt();
            if (buf.remaining() < OperationType.transactionRecordSize(cacheIdsCnt) - 4) {
                return false;
            }
            GridIntList cacheIds = new GridIntList(cacheIdsCnt);
            for (int i = 0; i < cacheIdsCnt; ++i) {
                cacheIds.add(buf.getInt());
            }
            long startTime = buf.getLong();
            long duration = buf.getLong();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.transaction(nodeId, cacheIds, startTime, duration, opType == OperationType.TX_COMMIT);
            }
            return true;
        }
        if (opType == OperationType.QUERY) {
            boolean success;
            String text;
            if (buf.remaining() < 1) {
                return false;
            }
            boolean cached = buf.get() != 0;
            int hash = 0;
            if (cached) {
                if (buf.remaining() < 4) {
                    return false;
                }
                hash = buf.getInt();
                text = this.knownStrs.get(hash);
                if (buf.remaining() < OperationType.queryRecordSize(0, true) - 1 - 4) {
                    return false;
                }
            } else {
                if (buf.remaining() < 4) {
                    return false;
                }
                int textLen = buf.getInt();
                if (buf.remaining() < OperationType.queryRecordSize(textLen, false) - 1 - 4) {
                    return false;
                }
                text = this.readString(buf, textLen);
            }
            GridCacheQueryType qryType = GridCacheQueryType.fromOrdinal(buf.get());
            long id = buf.getLong();
            long startTime = buf.getLong();
            long duration = buf.getLong();
            boolean bl = success = buf.get() != 0;
            if (text == null) {
                this.forwardRead(hash);
            }
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.query(nodeId, qryType, text, id, startTime, duration, success);
            }
            return true;
        }
        if (opType == OperationType.QUERY_READS) {
            if (buf.remaining() < OperationType.queryReadsRecordSize()) {
                return false;
            }
            GridCacheQueryType qryType = GridCacheQueryType.fromOrdinal(buf.get());
            UUID uuid = FilePerformanceStatisticsReader.readUuid(buf);
            long id = buf.getLong();
            long logicalReads = buf.getLong();
            long physicalReads = buf.getLong();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.queryReads(nodeId, qryType, uuid, id, logicalReads, physicalReads);
            }
            return true;
        }
        if (opType == OperationType.QUERY_ROWS) {
            String action = this.readCacheableString(buf);
            if (action == null || buf.remaining() < 33) {
                return false;
            }
            GridCacheQueryType qryType = GridCacheQueryType.fromOrdinal(buf.get());
            UUID uuid = FilePerformanceStatisticsReader.readUuid(buf);
            long id = buf.getLong();
            long rows = buf.getLong();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.queryRows(nodeId, qryType, uuid, id, action, rows);
            }
            return true;
        }
        if (opType == OperationType.QUERY_PROPERTY) {
            String name = this.readCacheableString(buf);
            if (name == null) {
                return false;
            }
            String val = this.readCacheableString(buf);
            if (val == null) {
                return false;
            }
            if (buf.remaining() < 25) {
                return false;
            }
            GridCacheQueryType qryType = GridCacheQueryType.fromOrdinal(buf.get());
            UUID uuid = FilePerformanceStatisticsReader.readUuid(buf);
            long id = buf.getLong();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.queryProperty(nodeId, qryType, uuid, id, name, val);
            }
            return true;
        }
        if (opType == OperationType.TASK) {
            String taskName;
            if (buf.remaining() < 1) {
                return false;
            }
            boolean cached = buf.get() != 0;
            int hash = 0;
            if (cached) {
                if (buf.remaining() < 4) {
                    return false;
                }
                hash = buf.getInt();
                taskName = this.knownStrs.get(hash);
                if (buf.remaining() < OperationType.taskRecordSize(0, true) - 1 - 4) {
                    return false;
                }
            } else {
                if (buf.remaining() < 4) {
                    return false;
                }
                int nameLen = buf.getInt();
                if (buf.remaining() < OperationType.taskRecordSize(nameLen, false) - 1 - 4) {
                    return false;
                }
                taskName = this.readString(buf, nameLen);
            }
            IgniteUuid sesId = FilePerformanceStatisticsReader.readIgniteUuid(buf);
            long startTime = buf.getLong();
            long duration = buf.getLong();
            int affPartId = buf.getInt();
            if (taskName == null) {
                this.forwardRead(hash);
            }
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.task(nodeId, sesId, taskName, startTime, duration, affPartId);
            }
            return true;
        }
        if (opType == OperationType.JOB) {
            if (buf.remaining() < OperationType.jobRecordSize()) {
                return false;
            }
            IgniteUuid sesId = FilePerformanceStatisticsReader.readIgniteUuid(buf);
            long queuedTime = buf.getLong();
            long startTime = buf.getLong();
            long duration = buf.getLong();
            boolean timedOut = buf.get() != 0;
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.job(nodeId, sesId, queuedTime, startTime, duration, timedOut);
            }
            return true;
        }
        if (opType == OperationType.CACHE_START) {
            String cacheName;
            if (buf.remaining() < 1) {
                return false;
            }
            boolean cached = buf.get() != 0;
            int hash = 0;
            if (cached) {
                if (buf.remaining() < 4) {
                    return false;
                }
                hash = buf.getInt();
                cacheName = this.knownStrs.get(hash);
                if (buf.remaining() < OperationType.cacheStartRecordSize(0, true) - 1 - 4) {
                    return false;
                }
            } else {
                if (buf.remaining() < 4) {
                    return false;
                }
                int nameLen = buf.getInt();
                if (buf.remaining() < OperationType.cacheStartRecordSize(nameLen, false) - 1 - 4) {
                    return false;
                }
                cacheName = this.readString(buf, nameLen);
            }
            int cacheId = buf.getInt();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.cacheStart(nodeId, cacheId, cacheName);
            }
            return true;
        }
        if (opType == OperationType.CHECKPOINT) {
            if (buf.remaining() < OperationType.checkpointRecordSize()) {
                return false;
            }
            long beforeLockDuration = buf.getLong();
            long lockWaitDuration = buf.getLong();
            long listenersExecDuration = buf.getLong();
            long markDuration = buf.getLong();
            long lockHoldDuration = buf.getLong();
            long pagesWriteDuration = buf.getLong();
            long fsyncDuration = buf.getLong();
            long walCpRecordFsyncDuration = buf.getLong();
            long writeCheckpointEntryDuration = buf.getLong();
            long splitAndSortCpPagesDuration = buf.getLong();
            long totalDuration = buf.getLong();
            long cpStartTime = buf.getLong();
            int pagesSize = buf.getInt();
            int dataPagesWritten = buf.getInt();
            int cowPagesWritten = buf.getInt();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.checkpoint(nodeId, beforeLockDuration, lockWaitDuration, listenersExecDuration, markDuration, lockHoldDuration, pagesWriteDuration, fsyncDuration, walCpRecordFsyncDuration, writeCheckpointEntryDuration, splitAndSortCpPagesDuration, totalDuration, cpStartTime, pagesSize, dataPagesWritten, cowPagesWritten);
            }
            return true;
        }
        if (opType == OperationType.PAGES_WRITE_THROTTLE) {
            if (buf.remaining() < OperationType.pagesWriteThrottleRecordSize()) {
                return false;
            }
            long endTime = buf.getLong();
            long duration = buf.getLong();
            for (PerformanceStatisticsHandler hnd : this.curHnd) {
                hnd.pagesWriteThrottle(nodeId, endTime, duration);
            }
            return true;
        }
        throw new IgniteException("Unknown operation type id [typeId=" + opTypeByte + "]");
    }

    private void forwardRead(int hash) throws IOException {
        if (this.forwardRead != null) {
            return;
        }
        int pos = this.buf.position();
        long nextRecPos = this.fileIo.position() - (long)this.buf.remaining();
        this.buf.reset();
        int bufPos = this.buf.position();
        long curRecPos = this.fileIo.position() - (long)this.buf.remaining();
        this.buf.position(pos);
        this.curHnd = NOOP_HANDLER;
        this.forwardRead = new ForwardRead(hash, curRecPos, nextRecPos, bufPos);
    }

    static List<File> resolveFiles(List<File> filesOrDirs) throws IOException {
        if (filesOrDirs == null || filesOrDirs.isEmpty()) {
            return Collections.emptyList();
        }
        final LinkedList<File> files = new LinkedList<File>();
        for (File file : filesOrDirs) {
            if (file.isDirectory()) {
                Files.walkFileTree(file.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        if (FilePerformanceStatisticsReader.nodeId(path.toFile()) != null) {
                            files.add(path.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            if (FilePerformanceStatisticsReader.nodeId(file) == null) continue;
            files.add(file);
        }
        return files;
    }

    @Nullable
    private static UUID nodeId(File file) {
        Matcher matcher = FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            return UUID.fromString(matcher.group(1));
        }
        return null;
    }

    private String readString(ByteBuffer buf, int size) {
        byte[] bytes = new byte[size];
        buf.get(bytes);
        String str = new String(bytes);
        this.knownStrs.putIfAbsent(str.hashCode(), str);
        if (this.forwardRead != null && this.forwardRead.hash == str.hashCode()) {
            this.forwardRead.found = true;
        }
        return str;
    }

    private String readCacheableString(ByteBuffer buf) {
        boolean cached;
        if (buf.remaining() < 5) {
            return null;
        }
        boolean bl = cached = buf.get() != 0;
        if (cached) {
            int hash = buf.getInt();
            return this.knownStrs.get(hash);
        }
        int textLen = buf.getInt();
        if (buf.remaining() < textLen) {
            return null;
        }
        return this.readString(buf, textLen);
    }

    private static UUID readUuid(ByteBuffer buf) {
        return new UUID(buf.getLong(), buf.getLong());
    }

    private static IgniteUuid readIgniteUuid(ByteBuffer buf) {
        UUID globalId = new UUID(buf.getLong(), buf.getLong());
        return new IgniteUuid(globalId, buf.getLong());
    }

    private static class ForwardRead {
        final int hash;
        final long curRecPos;
        final long nextRecPos;
        final int bufPos;
        boolean found;
        boolean resetBuf;

        private ForwardRead(int hash, long curRecPos, long nextRecPos, int bufPos) {
            this.hash = hash;
            this.curRecPos = curRecPos;
            this.nextRecPos = nextRecPos;
            this.bufPos = bufPos;
        }
    }
}

