/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public final class CollectionUtils {
    private static final Object NO_NEXT_ELEMENT = new Object();

    private CollectionUtils() {
    }

    public static boolean nullOrEmpty(@Nullable Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean nullOrEmpty(@Nullable Iterable<?> c) {
        return c == null || (c instanceof Collection ? ((Collection)c).isEmpty() : !c.iterator().hasNext());
    }

    public static boolean nullOrEmpty(@Nullable Map<?, ?> col) {
        return col == null || col.isEmpty();
    }

    @Nullable
    public static <T> T first(List<? extends T> list) {
        if (CollectionUtils.nullOrEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public static <T> T first(Collection<? extends T> col) {
        if (CollectionUtils.nullOrEmpty(col)) {
            return null;
        }
        return col.iterator().next();
    }

    @Nullable
    public static <T> T first(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> it = iterable.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    @SafeVarargs
    public static <T> Set<T> union(@Nullable Set<T> set, T ... ts) {
        if (CollectionUtils.nullOrEmpty(set)) {
            return ts == null || ts.length == 0 ? Set.of() : Set.of(ts);
        }
        if (ts == null || ts.length == 0) {
            return Collections.unmodifiableSet(set);
        }
        HashSet<T> res = new HashSet<T>(set);
        Collections.addAll(res, ts);
        return Collections.unmodifiableSet(res);
    }

    @SafeVarargs
    public static <T> Collection<T> concat(final Collection<T> ... collections) {
        if (collections == null || collections.length == 0) {
            return List.of();
        }
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return CollectionUtils.concat(collections).iterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (int i = 0; i < collections.length; ++i) {
                    size += collections[i].size();
                }
                return size;
            }

            @Override
            public boolean contains(Object o) {
                for (int i = 0; i < collections.length; ++i) {
                    if (!collections[i].contains(o)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null || iterables.length == 0) {
            return Collections::emptyIterator;
        }
        return () -> new Iterator<T>(){
            int idx = 0;
            Iterator curr = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && this.idx < iterables.length) {
                    this.curr = iterables[this.idx++].iterator();
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.curr.next();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(final Iterator<? extends T> ... iterators) {
        if (iterators == null || iterators.length == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            int idx = 0;
            Iterator<? extends T> curr = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && this.idx < iterators.length) {
                    this.curr = iterators[this.idx++];
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.curr.next();
            }
        };
    }

    public static <T> Iterator<T> concat(final @Nullable Collection<Iterator<? extends T>> iterators) {
        if (iterators == null || iterators.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            final Iterator<Iterator<? extends T>> it;
            Iterator<? extends T> curr;
            {
                this.it = iterators.iterator();
                this.curr = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.curr.hasNext() && this.it.hasNext()) {
                    this.curr = this.it.next();
                }
                return this.curr.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.curr.next();
            }
        };
    }

    @SafeVarargs
    public static <T> List<T> concat(final List<T> ... lists) {
        if (lists == null || lists.length == 0) {
            return List.of();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                for (List list : lists) {
                    if (index >= list.size()) {
                        index -= list.size();
                        continue;
                    }
                    return list.get(index);
                }
                throw new IndexOutOfBoundsException(index);
            }

            @Override
            public Iterator<T> iterator() {
                return CollectionUtils.concat(lists).iterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (List list : lists) {
                    size += list.size();
                }
                return size;
            }

            @Override
            public boolean contains(Object o) {
                for (List list : lists) {
                    if (!list.contains(o)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T1, T2> Collection<T2> viewReadOnly(final @Nullable Collection<? extends T1> collection, final @Nullable Function<? super T1, ? extends T2> mapper) {
        if (CollectionUtils.nullOrEmpty(collection)) {
            return Collections.emptyList();
        }
        if (mapper == null) {
            return Collections.unmodifiableCollection(collection);
        }
        return new AbstractCollection<T2>(){

            @Override
            public Iterator<T2> iterator() {
                final Iterator iterator = collection.iterator();
                return new Iterator<T2>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T2 next() {
                        return mapper.apply(iterator.next());
                    }
                };
            }

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            public boolean isEmpty() {
                return collection.isEmpty();
            }
        };
    }

    public static <T1, T2> Collection<T2> viewReadOnly(final @Nullable Collection<? extends T1> collection, final @Nullable Function<? super T1, ? extends T2> mapper, final @Nullable Predicate<? super T1> predicate) {
        if (collection == null) {
            return Collections.emptyList();
        }
        if (mapper == null && predicate == null) {
            return Collections.unmodifiableCollection(collection);
        }
        return new AbstractCollection<T2>(){

            @Override
            public Iterator<T2> iterator() {
                final Iterator iterator = collection.iterator();
                return new Iterator<T2>(){
                    @Nullable
                    T1 current = this.advance();

                    @Override
                    public boolean hasNext() {
                        return this.current != NO_NEXT_ELEMENT;
                    }

                    @Override
                    public T2 next() {
                        Object current = this.current;
                        if (current == NO_NEXT_ELEMENT) {
                            throw new NoSuchElementException();
                        }
                        this.current = this.advance();
                        return mapper == null ? current : mapper.apply(current);
                    }

                    @Nullable
                    private T1 advance() {
                        while (iterator.hasNext()) {
                            Object next = iterator.next();
                            if (predicate != null && !predicate.test(next)) continue;
                            return next;
                        }
                        return NO_NEXT_ELEMENT;
                    }
                };
            }

            @Override
            public int size() {
                if (predicate == null) {
                    return collection.size();
                }
                int count = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ++count;
                    iterator.next();
                }
                return count;
            }

            @Override
            public boolean isEmpty() {
                if (predicate == null) {
                    return collection.isEmpty();
                }
                return this.size() == 0;
            }
        };
    }

    public static <T> Set<T> difference(@Nullable Set<T> a, @Nullable Set<T> b) {
        if (CollectionUtils.nullOrEmpty(a)) {
            return Set.of();
        }
        if (CollectionUtils.nullOrEmpty(b)) {
            return Collections.unmodifiableSet(a);
        }
        HashSet<T> res = null;
        for (T t : a) {
            if (b.contains(t)) continue;
            if (res == null) {
                res = new HashSet<T>();
            }
            res.add(t);
        }
        return res == null ? Set.of() : Collections.unmodifiableSet(res);
    }

    public static IntSet setOf(Collection<Integer> coll) {
        return IntSets.unmodifiable((IntSet)new IntOpenHashSet(coll));
    }
}

