/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointReadLockTimeoutException;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.NodeStoppingException;

public class CheckpointTimeoutLock {
    protected final IgniteLogger log;
    private final BooleanSupplier safeToUpdateAllPageMemories;
    private final CheckpointReadWriteLock checkpointReadWriteLock;
    private final Checkpointer checkpointer;
    private volatile long checkpointReadLockTimeout;
    private boolean stop;

    public CheckpointTimeoutLock(IgniteLogger log, CheckpointReadWriteLock checkpointReadWriteLock, long checkpointReadLockTimeout, BooleanSupplier safeToUpdateAllPageMemories, Checkpointer checkpointer) {
        this.log = log;
        this.checkpointReadWriteLock = checkpointReadWriteLock;
        this.checkpointReadLockTimeout = checkpointReadLockTimeout;
        this.safeToUpdateAllPageMemories = safeToUpdateAllPageMemories;
        this.checkpointer = checkpointer;
    }

    public void start() {
        this.stop = false;
    }

    public void stop() {
        this.checkpointReadWriteLock.writeLock();
        try {
            this.stop = true;
        }
        finally {
            this.checkpointReadWriteLock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void checkpointReadLock() {
        block20: {
            if (this.checkpointReadWriteLock.isWriteLockHeldByCurrentThread()) {
                return;
            }
            timeout = this.checkpointReadLockTimeout;
            start = FastTimestamps.coarseCurrentTimeMillis();
            interrupted = false;
            try {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        if (timeout > 0L && FastTimestamps.coarseCurrentTimeMillis() - start >= timeout) {
                            this.failCheckpointReadLock();
                        }
                        try {
                            if (timeout > 0L) {
                                if (!this.checkpointReadWriteLock.tryReadLock(timeout - (FastTimestamps.coarseCurrentTimeMillis() - start), TimeUnit.MILLISECONDS)) {
                                    this.failCheckpointReadLock();
                                }
                            } else {
                                this.checkpointReadWriteLock.readLock();
                            }
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            continue;
                        }
                        if (this.stop) {
                            this.checkpointReadWriteLock.readUnlock();
                            throw new IgniteInternalException((Throwable)new NodeStoppingException("Failed to get checkpoint read lock"));
                        }
                        if (this.checkpointReadWriteLock.getReadHoldCount() > 1 || this.safeToUpdateAllPageMemories.getAsBoolean()) break block20;
                        if (this.checkpointer.runner() == null) {
                            break block20;
                        }
                        checkpoint = this.checkpointer.scheduleCheckpoint(0L, "too many dirty pages");
                        this.checkpointReadWriteLock.readUnlock();
                        if (timeout > 0L && FastTimestamps.coarseCurrentTimeMillis() - start >= timeout) {
                            this.failCheckpointReadLock();
                        }
                        try {
                            IgniteUtils.getUninterruptibly(checkpoint.futureFor(CheckpointState.LOCK_RELEASED));
                            continue;
                        }
                        catch (ExecutionException e) {
                            throw new IgniteInternalException("Failed to wait for checkpoint begin", e.getCause());
                        }
                        catch (CancellationException e) {
                            throw new IgniteInternalException("Failed to wait for checkpoint begin", (Throwable)e);
                        }
                        break;
                    }
                }
                catch (CheckpointReadLockTimeoutException e) {
                    this.log.debug(e.getMessage(), (Throwable)e);
                    throw e;
                }
                {
                    ** while (true)
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean tryCheckpointReadLock() {
        return this.checkpointReadWriteLock.tryReadLock();
    }

    public void checkpointReadUnlock() {
        this.checkpointReadWriteLock.readUnlock();
    }

    public long checkpointReadLockTimeout() {
        return this.checkpointReadLockTimeout;
    }

    public void checkpointReadLockTimeout(long val) {
        this.checkpointReadLockTimeout = val;
    }

    public boolean checkpointLockIsHeldByThread() {
        return this.checkpointReadWriteLock.checkpointLockIsHeldByThread();
    }

    private void failCheckpointReadLock() throws CheckpointReadLockTimeoutException {
        throw new CheckpointReadLockTimeoutException("Checkpoint read lock acquisition has been timed out");
    }
}

