/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.sql;

import java.time.Duration;
import java.time.Instant;
import org.apache.ignite.internal.cli.sql.MetadataSupplier;
import org.apache.ignite.internal.cli.sql.SchemaProvider;
import org.apache.ignite.internal.cli.sql.SqlSchema;
import org.apache.ignite.internal.cli.sql.SqlSchemaLoader;

public class SqlSchemaProvider
implements SchemaProvider {
    private static final int SCHEMA_UPDATE_TIMEOUT = 10;
    private final SqlSchemaLoader sqlSchemaLoader;
    private final int schemaUpdateTimeout;
    private SqlSchema schema;
    private Instant lastUpdate;

    public SqlSchemaProvider(MetadataSupplier metadataSupplier) {
        this(metadataSupplier, 10);
    }

    SqlSchemaProvider(MetadataSupplier metadataSupplier, int schemaUpdateTimeout) {
        this.sqlSchemaLoader = new SqlSchemaLoader(metadataSupplier);
        this.schemaUpdateTimeout = schemaUpdateTimeout;
    }

    @Override
    public SqlSchema getSchema() {
        if (this.schema == null || Duration.between(this.lastUpdate, Instant.now()).toSeconds() >= (long)this.schemaUpdateTimeout) {
            this.schema = this.sqlSchemaLoader.loadSchema();
            this.lastUpdate = Instant.now();
        }
        return this.schema;
    }
}

