/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterStateBuilder;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClusterStateImpl
implements ClusterState {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 61;
    @IgniteToStringInclude
    private final ClusterTag clusterTag;
    @IgniteToStringInclude
    private final Set<String> cmgNodes;
    @IgniteToStringInclude
    private final Set<String> metaStorageNodes;
    @IgniteToStringInclude
    private final String version;

    private ClusterStateImpl(ClusterTag clusterTag, Set<String> cmgNodes, Set<String> metaStorageNodes, String version) {
        this.clusterTag = clusterTag;
        this.cmgNodes = cmgNodes;
        this.metaStorageNodes = metaStorageNodes;
        this.version = version;
    }

    @Override
    public ClusterTag clusterTag() {
        return this.clusterTag;
    }

    @Override
    public Set<String> cmgNodes() {
        return this.cmgNodes;
    }

    @Override
    public Set<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @Override
    public String version() {
        return this.version;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterStateImpl.class, (Object)this);
    }

    public short messageType() {
        return 61;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterStateImpl otherMessage = (ClusterStateImpl)other;
        return Objects.equals(this.clusterTag, otherMessage.clusterTag) && Objects.equals(this.cmgNodes, otherMessage.cmgNodes) && Objects.equals(this.metaStorageNodes, otherMessage.metaStorageNodes) && Objects.equals(this.version, otherMessage.version);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterTag, this.cmgNodes, this.metaStorageNodes, this.version);
        return result;
    }

    public static ClusterStateBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ClusterStateBuilder {
        private ClusterTag clusterTag;
        private Set<String> cmgNodes;
        private Set<String> metaStorageNodes;
        private String version;

        private Builder() {
        }

        @Override
        public ClusterStateBuilder clusterTag(ClusterTag clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        @Override
        public ClusterStateBuilder cmgNodes(Set<String> cmgNodes) {
            this.cmgNodes = cmgNodes;
            return this;
        }

        @Override
        public ClusterStateBuilder metaStorageNodes(Set<String> metaStorageNodes) {
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        @Override
        public ClusterStateBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ClusterTag clusterTag() {
            return this.clusterTag;
        }

        @Override
        public Set<String> cmgNodes() {
            return this.cmgNodes;
        }

        @Override
        public Set<String> metaStorageNodes() {
            return this.metaStorageNodes;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public ClusterState build() {
            return new ClusterStateImpl(this.clusterTag, this.cmgNodes, this.metaStorageNodes, this.version);
        }
    }
}

