/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.Context;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Optionality;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlAggFunction
extends SqlFunction
implements Context {
    private final boolean requiresOrder;
    private final boolean requiresOver;
    private final Optionality requiresGroupOrder;

    @Deprecated
    protected SqlAggFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory funcType) {
        this(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, funcType, false, false, Optionality.FORBIDDEN);
    }

    @Deprecated
    protected SqlAggFunction(String name, @Nullable SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory funcType) {
        this(name, sqlIdentifier, kind, returnTypeInference, operandTypeInference, operandTypeChecker, funcType, false, false, Optionality.FORBIDDEN);
    }

    @Deprecated
    protected SqlAggFunction(String name, @Nullable SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory funcType, boolean requiresOrder, boolean requiresOver) {
        this(name, sqlIdentifier, kind, returnTypeInference, operandTypeInference, operandTypeChecker, funcType, requiresOrder, requiresOver, Optionality.FORBIDDEN);
    }

    protected SqlAggFunction(String name, @Nullable SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory funcType, boolean requiresOrder, boolean requiresOver, Optionality requiresGroupOrder) {
        super(name, sqlIdentifier, kind, returnTypeInference, operandTypeInference, operandTypeChecker, funcType);
        this.requiresOrder = requiresOrder;
        this.requiresOver = requiresOver;
        this.requiresGroupOrder = Objects.requireNonNull(requiresGroupOrder, "requiresGroupOrder");
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        return clazz.isInstance(this) ? (T)clazz.cast(this) : null;
    }

    @Override
    public boolean isAggregator() {
        return true;
    }

    @Override
    public boolean isQuantifierAllowed() {
        return true;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        validator.validateAggregateParams(call, null, null, null, scope);
    }

    @Override
    public final boolean requiresOrder() {
        return this.requiresOrder;
    }

    public Optionality requiresGroupOrder() {
        return this.requiresGroupOrder;
    }

    @Override
    public final boolean requiresOver() {
        return this.requiresOver;
    }

    public Optionality getDistinctOptionality() {
        return Optionality.OPTIONAL;
    }

    @Deprecated
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        throw new UnsupportedOperationException("remove before calcite-2.0");
    }

    @Deprecated
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        throw new UnsupportedOperationException("remove before calcite-2.0");
    }

    public boolean allowsFilter() {
        return true;
    }

    public boolean allowsNullTreatment() {
        return false;
    }

    public @Nullable SqlAggFunction getRollup() {
        return null;
    }

    public boolean isPercentile() {
        return false;
    }
}

